/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.networking.c2s;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.networking.JobsPlusNetworking;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.job.Job;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerboundStartPowerupPacket
implements CustomPacketPayload {
    @Nullable
    private final JobInstance jobInstance;
    @Nullable
    private final PowerupInstance powerupInstance;
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundStartPowerupPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ServerboundStartPowerupPacket>(){

        @NotNull
        public ServerboundStartPowerupPacket decode(RegistryFriendlyByteBuf buf) {
            return new ServerboundStartPowerupPacket(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, ServerboundStartPowerupPacket packet) {
            boolean jobInstanceIsNotNull = packet.jobInstance != null;
            buf.writeBoolean(jobInstanceIsNotNull);
            if (jobInstanceIsNotNull) {
                buf.writeResourceLocation(packet.jobInstance.getLocation());
            }
            boolean powerupInstanceIsNotNull = packet.powerupInstance != null;
            buf.writeBoolean(powerupInstanceIsNotNull);
            if (powerupInstanceIsNotNull) {
                buf.writeResourceLocation(packet.powerupInstance.getLocation());
            }
        }
    };

    public ServerboundStartPowerupPacket(@Nullable JobInstance jobInstance, @Nullable PowerupInstance powerupInstance) {
        this.jobInstance = jobInstance;
        this.powerupInstance = powerupInstance;
    }

    public ServerboundStartPowerupPacket(RegistryFriendlyByteBuf friendlyByteBuf) {
        boolean jobInstanceIsNotNull = friendlyByteBuf.readBoolean();
        this.jobInstance = jobInstanceIsNotNull ? JobInstance.of(friendlyByteBuf.readResourceLocation()) : null;
        boolean powerupInstanceIsNotNull = friendlyByteBuf.readBoolean();
        this.powerupInstance = powerupInstanceIsNotNull ? PowerupInstance.of(friendlyByteBuf.readResourceLocation()) : null;
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return JobsPlusNetworking.SERVERBOUND_START_POWERUP;
    }

    public static void handleServerSide(ServerboundStartPowerupPacket packet, NetworkManager.PacketContext context) {
        if (packet.jobInstance == null || packet.powerupInstance == null) {
            return;
        }
        Player player = context.getPlayer();
        if (player instanceof JobsServerPlayer) {
            JobsServerPlayer serverPlayer = (JobsServerPlayer)player;
            Job job = serverPlayer.jobsplus$getJob(packet.jobInstance);
            if (job == null) {
                serverPlayer.jobsplus$getServerPlayer().sendSystemMessage((Component)JobsPlus.translatable("error.job_not_found", packet.jobInstance.getLocation().toString()));
                return;
            }
            if (serverPlayer.jobsplus$getCoins() < packet.powerupInstance.getPrice()) {
                serverPlayer.jobsplus$getServerPlayer().sendSystemMessage((Component)JobsPlus.translatable("error.not_enough_coins"));
                return;
            }
            if (job.getLevel() < packet.powerupInstance.getRequiredLevel()) {
                serverPlayer.jobsplus$getServerPlayer().sendSystemMessage((Component)JobsPlus.translatable("error.not_high_enough_level"));
                return;
            }
            serverPlayer.jobsplus$setCoins(serverPlayer.jobsplus$getCoins() - packet.powerupInstance.getPrice());
            job.getPowerupManager().addPowerup(serverPlayer, job, packet.powerupInstance);
        }
    }
}

