/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.networking.sync.coin;

import com.daqem.jobsplus.client.player.JobsClientPlayer;
import com.daqem.jobsplus.networking.JobsPlusNetworking;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ClientBoundUpdateCoinsPacket
implements CustomPacketPayload {
    private final int coins;
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientBoundUpdateCoinsPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ClientBoundUpdateCoinsPacket>(){

        @NotNull
        public ClientBoundUpdateCoinsPacket decode(RegistryFriendlyByteBuf buf) {
            return new ClientBoundUpdateCoinsPacket(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, ClientBoundUpdateCoinsPacket packet) {
            buf.writeInt(packet.coins);
        }
    };

    public ClientBoundUpdateCoinsPacket(int coins) {
        this.coins = coins;
    }

    public ClientBoundUpdateCoinsPacket(RegistryFriendlyByteBuf buf) {
        this.coins = buf.readInt();
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return JobsPlusNetworking.CLIENTBOUND_UPDATE_COINS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientSide(ClientBoundUpdateCoinsPacket packet, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        if (player instanceof JobsClientPlayer) {
            JobsClientPlayer player2 = (JobsClientPlayer)player;
            player2.jobsplus$setCoins(packet.coins);
        }
    }
}

