/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.player.job;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.event.triggers.JobEvents;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobManager;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.networking.sync.job.ClientboundUpdateJobPacket;
import com.daqem.jobsplus.player.JobsPlayer;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.job.exp.ExpCollector;
import com.daqem.jobsplus.player.job.powerup.JobPowerupManager;
import com.daqem.jobsplus.player.job.powerup.Powerup;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class Job {
    private final JobInstance jobInstance;
    private final JobPowerupManager powerupManager;
    private JobsPlayer player;
    private int level;
    private int experience;
    private final ExpCollector expCollector = new ExpCollector();

    public Job(JobsPlayer player, JobInstance jobInstance) {
        this(player, jobInstance, 0, 0, new ArrayList<Powerup>());
    }

    public Job(JobsPlayer player, JobInstance jobInstance, int level, int experience) {
        this(player, jobInstance, level, experience, new ArrayList<Powerup>());
    }

    public Job(JobsPlayer player, ResourceLocation jobInstanceLocation, int level, int experience, @NotNull List<Powerup> powerups) {
        this(player, JobManager.getInstance().getJobs().get(jobInstanceLocation), level, experience, powerups);
    }

    public Job(JobsPlayer player, JobInstance jobInstance, int level, int experience, @NotNull List<Powerup> powerups) {
        this.player = player;
        this.jobInstance = jobInstance;
        this.powerupManager = new JobPowerupManager(powerups);
        this.level = level;
        this.experience = experience;
    }

    public JobInstance getJobInstance() {
        return this.jobInstance;
    }

    public JobPowerupManager getPowerupManager() {
        return this.powerupManager;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
        this.syncWithClient();
    }

    public int getExperience() {
        return this.experience;
    }

    public void setExperience(int experience, boolean triggerEvent) {
        int change = experience - this.experience;
        this.expCollector.addExp(change);
        this.experience = experience;
        this.checkForLevelUp();
        this.syncWithClient();
        if (triggerEvent) {
            JobEvents.onJobExperience(this.player, this, change);
        }
    }

    public void addExperience(int experience) {
        JobsPlus.debug("Adding {} experience to {}'s {} job.", experience, this.player.jobsplus$getName(), this.jobInstance.getName().getString());
        this.setExperience(this.getExperience() + experience, true);
    }

    public void addExperienceWithoutEvent(int experience) {
        JobsPlus.debug("Adding {} experience to {}'s {} job without event.", experience, this.player.jobsplus$getName(), this.jobInstance.getName().getString());
        this.setExperience(this.getExperience() + experience, false);
    }

    private void checkForLevelUp() {
        int experienceToLevelUp = Job.getExperienceToLevelUp(this.level);
        if (this.experience >= experienceToLevelUp) {
            this.setLevel(this.level + 1);
            this.setExperience(this.experience - experienceToLevelUp, false);
            JobEvents.onJobLevelUp(this.player, this);
            JobsPlayer jobsPlayer = this.player;
            if (jobsPlayer instanceof JobsServerPlayer) {
                JobsServerPlayer serverPlayer = (JobsServerPlayer)jobsPlayer;
                serverPlayer.jobsplus$updateJobOnClient(this);
            }
        }
    }

    private void syncWithClient() {
        JobsPlayer jobsPlayer = this.player;
        if (jobsPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)jobsPlayer;
            NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ClientboundUpdateJobPacket(this));
        }
    }

    public static int getExperienceToLevelUp(int level) {
        if (level == 0) {
            return 0;
        }
        return (int)(100.0 + (double)(level * level) * 0.5791);
    }

    public void setPlayer(JobsPlayer player) {
        this.player = player;
    }

    public CompoundTag toNBT() {
        CompoundTag jobTag = new CompoundTag();
        jobTag.putString("JobInstanceLocation", this.getJobInstance().getLocation().toString());
        jobTag.putInt("Level", this.getLevel());
        jobTag.putInt("Experience", this.getExperience());
        ListTag powerupsTag = new ListTag();
        for (Powerup powerup : this.powerupManager.getAllPowerups()) {
            CompoundTag powerupTag = new CompoundTag();
            powerupTag.putString("PowerupLocation", powerup.getPowerupInstance().getLocation().toString());
            powerupTag.putString("State", powerup.getState().name());
            powerupsTag.add((Object)powerupTag);
        }
        jobTag.put("Powerups", (Tag)powerupsTag);
        return jobTag;
    }

    public static Job fromNBT(JobsPlayer player, CompoundTag tag) {
        AtomicReference job = new AtomicReference();
        tag.getString("JobInstanceLocation").ifPresent(jobLocation -> tag.getInt("Level").ifPresent(level -> tag.getInt("Experience").ifPresent(exp -> {
            ArrayList<Powerup> powerups = new ArrayList<Powerup>();
            tag.getList("Powerups").ifPresent(powerupsTag -> {
                for (Tag powerupTag : powerupsTag) {
                    CompoundTag powerupNBT = (CompoundTag)powerupTag;
                    powerupNBT.getString("PowerupLocation").ifPresent(powerupLocation -> powerupNBT.getString("State").ifPresent(powerupState -> powerups.add(new Powerup(PowerupInstance.of(ResourceLocation.parse((String)powerupLocation)), PowerupState.valueOf(powerupState)))));
                }
            });
            job.set(new Job(player, ResourceLocation.parse((String)jobLocation), (int)level, (int)exp, powerups));
        })));
        return (Job)job.get();
    }

    public double getExperiencePercentage() {
        return (double)this.experience / (double)Job.getExperienceToLevelUp(this.level) * 100.0;
    }

    public ExpCollector getExpCollector() {
        return this.expCollector;
    }

    public static class Serializer {
        public static Job fromNetwork(FriendlyByteBuf friendlyByteBuf, JobsPlayer player) {
            ResourceLocation jobInstanceLocation = friendlyByteBuf.readResourceLocation();
            int level = friendlyByteBuf.readInt();
            int experience = friendlyByteBuf.readInt();
            int powerupCount = friendlyByteBuf.readVarInt();
            ArrayList<Powerup> powerups = new ArrayList<Powerup>();
            for (int i = 0; i < powerupCount; ++i) {
                ResourceLocation powerupLocation = friendlyByteBuf.readResourceLocation();
                PowerupState state = (PowerupState)friendlyByteBuf.readEnum(PowerupState.class);
                powerups.add(new Powerup(PowerupInstance.of(powerupLocation), state));
            }
            return new Job(player, jobInstanceLocation, level, experience, powerups);
        }

        public static void toNetwork(FriendlyByteBuf friendlyByteBuf, Job job) {
            friendlyByteBuf.writeResourceLocation(job.getJobInstance().getLocation());
            friendlyByteBuf.writeInt(job.getLevel());
            friendlyByteBuf.writeInt(job.getExperience());
            friendlyByteBuf.writeVarInt(job.getPowerupManager().getAllPowerups().size());
            for (Powerup powerup : job.getPowerupManager().getAllPowerups()) {
                friendlyByteBuf.writeResourceLocation(powerup.getPowerupInstance().getLocation());
                friendlyByteBuf.writeEnum((Enum)powerup.getState());
            }
        }

        public static List<Job> fromNBT(JobsServerPlayer player, CompoundTag compoundTag) {
            ArrayList<Job> jobs = new ArrayList<Job>();
            compoundTag.getList("Jobs").ifPresent(list -> {
                for (Tag jobTag : list) {
                    CompoundTag jobNBT = (CompoundTag)jobTag;
                    Job job = Job.fromNBT(player, jobNBT);
                    if (job == null) continue;
                    jobs.add(job);
                }
            });
            return jobs;
        }

        public static ListTag toNBT(List<Job> jobs) {
            ListTag jobsListTag = new ListTag();
            for (Job job : jobs) {
                CompoundTag jobNBT = job.toNBT();
                jobsListTag.add((Object)jobNBT);
            }
            return jobsListTag;
        }
    }
}

