/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.event.triggers;

import com.daqem.arc.api.action.data.ActionDataBuilder;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.itemrestrictions.data.ItemRestriction;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.config.JobsPlusConfig;
import com.daqem.jobsplus.integration.arc.action.type.JobsPlusActionType;
import com.daqem.jobsplus.integration.arc.data.type.JobsPlusActionDataType;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.networking.s2c.ClientboundLevelUpJobPacket;
import com.daqem.jobsplus.networking.s2c.ClientboundUnlockItemRestrictionPacket;
import com.daqem.jobsplus.player.JobsPlayer;
import com.daqem.jobsplus.player.job.Job;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_8710;

public class JobEvents {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public static void onJobLevelUp(JobsPlayer player, Job job) {
        class_1657 class_16572;
        if (player instanceof ArcPlayer) {
            ArcPlayer arcPlayer = (ArcPlayer)player;
            new ActionDataBuilder(arcPlayer, JobsPlusActionType.JOB_LEVEL_UP).withData(JobsPlusActionDataType.ONLY_FOR_JOB, (Object)job).build().sendToAction();
        }
        if ((class_16572 = player.jobsplus$getPlayer()) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_8710)new ClientboundLevelUpJobPacket(job.getJobInstance().getLocation(), job.getLevel()));
            List<ItemRestriction> itemRestrictions = job.getJobInstance().getItemRestrictions().entrySet().stream().filter(entry -> ((Integer)entry.getValue()).intValue() == job.getLevel()).map(Map.Entry::getKey).toList();
            for (ItemRestriction itemRestriction : itemRestrictions) {
                NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_8710)new ClientboundUnlockItemRestrictionPacket(itemRestriction.getLocation()));
            }
            JobEvents.triggerLevelUpEffects(serverPlayer);
            player.jobsplus$addCoins((Integer)JobsPlusConfig.coinsPerLevelUp.get());
            JobInstance jobInstance = job.getJobInstance();
            if (serverPlayer.method_5682() == null) {
                return;
            }
            serverPlayer.method_5682().method_3760().method_43514((class_2561)JobsPlus.translatable("job.level_up", serverPlayer.method_5477().method_27661().method_27694(style -> style.method_36139(jobInstance.getColorDecimal())), JobsPlus.literal(String.valueOf(job.getLevel())).method_27694(style -> style.method_36139(jobInstance.getColorDecimal())), jobInstance.getName().getString()), false);
        }
    }

    public static void onJobExperience(JobsPlayer player, Job job, int experience) {
        if (player instanceof ArcPlayer) {
            ArcPlayer arcPlayer = (ArcPlayer)player;
            new ActionDataBuilder(arcPlayer, JobsPlusActionType.JOB_EXP).withData(JobsPlusActionDataType.JOB_EXP, (Object)experience).withData(JobsPlusActionDataType.ONLY_FOR_JOB, (Object)job).build().sendToAction();
        }
    }

    private static void schedule(Runnable task, long delayInMillis) {
        scheduler.schedule(task, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static void triggerLevelUpEffects(class_3222 player) {
        JobEvents.schedule(() -> {
            JobEvents.playLevelUpSound(player, 0.5f, 2.0f);
            JobEvents.playEXPOrbPickupSound(player);
        }, 250L);
        JobEvents.schedule(() -> {
            JobEvents.playLevelUpSound(player, 1.0f, 2.0f);
            JobEvents.playEXPOrbPickupSound(player);
        }, 450L);
        JobEvents.schedule(() -> {
            JobEvents.playLevelUpSound(player, 0.5f, 1.5f);
            JobEvents.playEXPOrbPickupSound(player);
        }, 550L);
    }

    public static void playLevelUpSound(class_3222 player, float volume, float pitch) {
        player.method_51469().method_8396(null, player.method_24515(), class_3417.field_14709, class_3419.field_15256, volume, pitch);
    }

    public static void playEXPOrbPickupSound(class_3222 player) {
        player.method_51469().method_8396(null, player.method_24515(), class_3417.field_14627, class_3419.field_15256, 1.0f, 1.0f);
    }
}

