/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.player.job;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.event.triggers.JobEvents;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobManager;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.player.JobsPlayer;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.job.exp.ExpCollector;
import com.daqem.jobsplus.player.job.powerup.JobPowerupManager;
import com.daqem.jobsplus.player.job.powerup.Powerup;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class Job {
    public static final Codec<Job> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("job_instance").forGetter(job -> job.getJobInstance().getLocation()), (App)Codec.INT.fieldOf("level").forGetter(Job::getLevel), (App)Codec.INT.fieldOf("experience").forGetter(Job::getExperience), (App)Codec.list(Powerup.CODEC).fieldOf("powerups").forGetter(job -> job.getPowerupManager().getAllPowerups())).apply((Applicative)instance, (jobInstanceLocation, level, experience, powerups) -> new Job(null, (class_2960)jobInstanceLocation, (int)level, (int)experience, (List<Powerup>)new ArrayList<Powerup>((Collection<Powerup>)powerups))));
    private final JobInstance jobInstance;
    private final JobPowerupManager powerupManager;
    private JobsPlayer player;
    private int level;
    private int experience;
    private final ExpCollector expCollector = new ExpCollector();

    public Job(JobsPlayer player, JobInstance jobInstance) {
        this(player, jobInstance, 0, 0, new ArrayList<Powerup>());
    }

    public Job(JobsPlayer player, JobInstance jobInstance, int level, int experience) {
        this(player, jobInstance, level, experience, new ArrayList<Powerup>());
    }

    public Job(JobsPlayer player, class_2960 jobInstanceLocation, int level, int experience, @NotNull List<Powerup> powerups) {
        this(player, JobManager.getInstance().getJobs().get(jobInstanceLocation), level, experience, powerups);
    }

    public Job(JobsPlayer player, JobInstance jobInstance, int level, int experience, @NotNull List<Powerup> powerups) {
        this.player = player;
        this.jobInstance = jobInstance;
        this.powerupManager = new JobPowerupManager(powerups);
        this.level = level;
        this.experience = experience;
    }

    public JobInstance getJobInstance() {
        return this.jobInstance;
    }

    public JobPowerupManager getPowerupManager() {
        return this.powerupManager;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getExperience() {
        return this.experience;
    }

    public void setExperience(int experience, boolean triggerEvent) {
        int change = experience - this.experience;
        this.expCollector.addExp(change);
        this.experience = experience;
        this.checkForLevelUp();
        if (triggerEvent) {
            JobEvents.onJobExperience(this.player, this, change);
        }
    }

    public void addExperience(int experience) {
        JobsPlus.debug("Adding {} experience to {}'s {} job.", experience, this.player.jobsplus$getName(), this.jobInstance.getName().getString());
        this.setExperience(this.getExperience() + experience, true);
    }

    public void addExperienceWithoutEvent(int experience) {
        JobsPlus.debug("Adding {} experience to {}'s {} job without event.", experience, this.player.jobsplus$getName(), this.jobInstance.getName().getString());
        this.setExperience(this.getExperience() + experience, false);
    }

    private void checkForLevelUp() {
        int experienceToLevelUp = Job.getExperienceToLevelUp(this.level);
        if (this.experience >= experienceToLevelUp) {
            this.setLevel(this.level + 1);
            this.setExperience(this.experience - experienceToLevelUp, false);
            JobEvents.onJobLevelUp(this.player, this);
        }
    }

    public static int getExperienceToLevelUp(int level) {
        if (level == 0) {
            return 0;
        }
        return (int)(100.0 + (double)(level * level) * 0.5791);
    }

    public void setPlayer(JobsPlayer player) {
        this.player = player;
    }

    public class_2487 toNBT() {
        class_2487 jobTag = new class_2487();
        jobTag.method_10582("JobInstanceLocation", this.getJobInstance().getLocation().toString());
        jobTag.method_10569("Level", this.getLevel());
        jobTag.method_10569("Experience", this.getExperience());
        class_2499 powerupsTag = new class_2499();
        for (Powerup powerup : this.powerupManager.getAllPowerups()) {
            class_2487 powerupTag = new class_2487();
            powerupTag.method_10582("PowerupLocation", powerup.getPowerupInstance().getLocation().toString());
            powerupTag.method_10582("State", powerup.getState().name());
            powerupsTag.add((Object)powerupTag);
        }
        jobTag.method_10566("Powerups", (class_2520)powerupsTag);
        return jobTag;
    }

    public static Job fromNBT(JobsPlayer player, class_2487 tag) {
        AtomicReference job = new AtomicReference();
        tag.method_10558("JobInstanceLocation").ifPresent(jobLocation -> tag.method_10550("Level").ifPresent(level -> tag.method_10550("Experience").ifPresent(exp -> {
            ArrayList<Powerup> powerups = new ArrayList<Powerup>();
            tag.method_10554("Powerups").ifPresent(powerupsTag -> {
                for (class_2520 powerupTag : powerupsTag) {
                    class_2487 powerupNBT = (class_2487)powerupTag;
                    powerupNBT.method_10558("PowerupLocation").ifPresent(powerupLocation -> powerupNBT.method_10558("State").ifPresent(powerupState -> powerups.add(new Powerup(PowerupInstance.of(class_2960.method_60654((String)powerupLocation)), PowerupState.valueOf(powerupState)))));
                }
            });
            job.set(new Job(player, class_2960.method_60654((String)jobLocation), (int)level, (int)exp, powerups));
        })));
        return (Job)job.get();
    }

    public double getExperiencePercentage() {
        return (double)this.experience / (double)Job.getExperienceToLevelUp(this.level) * 100.0;
    }

    public ExpCollector getExpCollector() {
        return this.expCollector;
    }

    public int getExperienceForNextLevel() {
        return Job.getExperienceToLevelUp(this.level);
    }

    public static class Serializer {
        public static Job fromNetwork(class_2540 friendlyByteBuf, JobsPlayer player) {
            class_2960 jobInstanceLocation = friendlyByteBuf.method_10810();
            int level = friendlyByteBuf.readInt();
            int experience = friendlyByteBuf.readInt();
            int powerupCount = friendlyByteBuf.method_10816();
            ArrayList<Powerup> powerups = new ArrayList<Powerup>();
            for (int i = 0; i < powerupCount; ++i) {
                class_2960 powerupLocation = friendlyByteBuf.method_10810();
                PowerupState state = (PowerupState)friendlyByteBuf.method_10818(PowerupState.class);
                powerups.add(new Powerup(PowerupInstance.of(powerupLocation), state));
            }
            return new Job(player, jobInstanceLocation, level, experience, powerups);
        }

        public static void toNetwork(class_2540 friendlyByteBuf, Job job) {
            friendlyByteBuf.method_10812(job.getJobInstance().getLocation());
            friendlyByteBuf.method_53002(job.getLevel());
            friendlyByteBuf.method_53002(job.getExperience());
            friendlyByteBuf.method_10804(job.getPowerupManager().getAllPowerups().size());
            for (Powerup powerup : job.getPowerupManager().getAllPowerups()) {
                friendlyByteBuf.method_10812(powerup.getPowerupInstance().getLocation());
                friendlyByteBuf.method_10817((Enum)powerup.getState());
            }
        }

        public static List<Job> fromNBT(JobsServerPlayer player, class_2487 compoundTag) {
            ArrayList<Job> jobs = new ArrayList<Job>();
            compoundTag.method_10554("Jobs").ifPresent(list -> {
                for (class_2520 jobTag : list) {
                    class_2487 jobNBT = (class_2487)jobTag;
                    Job job = Job.fromNBT(player, jobNBT);
                    if (job == null) continue;
                    jobs.add(job);
                }
            });
            return jobs;
        }

        public static class_2499 toNBT(List<Job> jobs) {
            class_2499 jobsListTag = new class_2499();
            for (Job job : jobs) {
                class_2487 jobNBT = job.toNBT();
                jobsListTag.add((Object)jobNBT);
            }
            return jobsListTag;
        }
    }
}

