/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.gui.jobs.components;

import com.daqem.arc.api.action.IAction;
import com.daqem.jobsplus.client.gui.jobs.JobsScreenState;
import com.daqem.jobsplus.client.gui.jobs.components.ActionItemComponent;
import com.daqem.jobsplus.client.gui.jobs.components.ActionsPaginationComponent;
import com.daqem.jobsplus.client.gui.jobs.widgets.ActionScrollWidget;
import com.daqem.jobsplus.integration.arc.reward.rewards.job.JobExpReward;
import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.api.widget.IWidget;
import com.daqem.uilib.gui.component.EmptyComponent;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import org.jetbrains.annotations.NotNull;

public class ActionScrollComponent
extends EmptyComponent {
    private final JobsScreenState state;
    private IAction cachedAction;
    private final ActionScrollWidget actionScrollWidget;

    public ActionScrollComponent(JobsScreenState state) {
        super(0, 38, 117, 130);
        this.state = state;
        this.actionScrollWidget = new ActionScrollWidget(this.getWidth(), this.getHeight());
        List<IAction> actions = this.getSortedActions(state);
        state.setActiveAction(actions.isEmpty() ? null : actions.getFirst());
        this.cachedAction = state.getActiveAction();
        if (state.getActiveAction() != null) {
            this.actionScrollWidget.addComponent((IComponent)new ActionItemComponent(this.cachedAction, state, () -> ((ActionScrollWidget)this.actionScrollWidget).getRectangle()));
            ActionsPaginationComponent paginationComponent = new ActionsPaginationComponent(actions, state);
            paginationComponent.setY(this.getHeight() - paginationComponent.getHeight());
            if (paginationComponent.getHeight() > 0) {
                this.actionScrollWidget.setHeight(this.getHeight() - paginationComponent.getHeight() - 2);
            }
            this.addWidget((IWidget)this.actionScrollWidget);
            this.addComponent((IComponent)paginationComponent);
        } else {
            this.setWidth(0);
            this.setHeight(0);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        if (this.cachedAction != null && this.cachedAction != this.state.getActiveAction()) {
            this.cachedAction = this.state.getActiveAction();
            this.actionScrollWidget.clearComponents();
            this.actionScrollWidget.addComponent((IComponent)new ActionItemComponent(this.cachedAction, this.state, () -> ((ActionScrollWidget)this.actionScrollWidget).getRectangle()));
            this.actionScrollWidget.setScrollAmount(0.0);
            this.updateParentPosition(this.getParentX(), this.getParentY(), parentWidth, parentHeight);
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick, parentWidth, parentHeight);
    }

    private List<IAction> getSortedActions(JobsScreenState state) {
        return state.getSelectedJob().getJobInstance().getActions().stream().filter(action -> action.getRewards().stream().anyMatch(reward -> reward instanceof JobExpReward)).sorted(Comparator.comparing(o -> {
            JobExpReward jobExpReward = o.getRewards().stream().filter(reward -> reward instanceof JobExpReward).map(reward -> (JobExpReward)((Object)((Object)reward))).findFirst().orElse(null);
            if (jobExpReward == null) {
                return 0;
            }
            return jobExpReward.getMax();
        })).collect(Collectors.toList());
    }

    @NotNull
    public ScreenRectangle getRectangle() {
        return new ScreenRectangle(this.getTotalX(), this.getTotalY(), this.getWidth(), this.getHeight());
    }
}

