/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.gui.jobs.components;

import com.daqem.itemrestrictions.data.RestrictionType;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.gui.component.item.ItemComponent;
import com.daqem.uilib.gui.component.sprite.SpriteComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RecipeItemComponent
extends SpriteComponent {
    private static final int[] SPRITE_IDS = new int[]{4, 1, 2, 3, 3, 1, 4, 3, 2, 4, 2, 4, 3, 1, 2, 1};
    private final List<Component> tooltip;

    public RecipeItemComponent(int x, int y, int index, List<RestrictionType> restrictionTypes, int requiredLevel, ItemStack itemStack) {
        super(x, y, 24, 24, JobsPlus.getId("jobs/item_slot_" + SPRITE_IDS[index % SPRITE_IDS.length]));
        this.tooltip = restrictionTypes.stream().map(restrictionType -> JobsPlus.translatable(restrictionType.getTranslationKey())).sorted((c1, c2) -> String.CASE_INSENSITIVE_ORDER.compare(c1.getString(), c2.getString())).collect(Collectors.toList());
        MutableComponent title = JobsPlus.translatable("gui.jobs.restriction_types", requiredLevel);
        SequencedCollection titleLines = this.getTitleLines(title).reversed();
        titleLines.forEach(this.tooltip::addFirst);
        this.tooltip.add((Component)Component.empty());
        this.tooltip.add((Component)JobsPlus.translatable("gui.jobs.item_info").withStyle(ChatFormatting.GOLD));
        Minecraft minecraft = Minecraft.getInstance();
        List itemTooltips = itemStack.getTooltipLines(Item.TooltipContext.of((Level)minecraft.level), (Player)minecraft.player, (TooltipFlag)TooltipFlag.NORMAL);
        this.tooltip.addAll(itemTooltips);
        ItemComponent iconComponent = new ItemComponent(4, 4, itemStack.copyWithCount(requiredLevel), true);
        this.addComponent((IComponent)iconComponent);
    }

    private List<Component> getTitleLines(MutableComponent title) {
        int maxWidth;
        ArrayList<Component> lines = new ArrayList<Component>();
        String titleString = title.getString();
        int width = Minecraft.getInstance().font.width(titleString);
        if (width <= (maxWidth = 140)) {
            lines.add((Component)title.withStyle(ChatFormatting.GOLD));
        } else {
            String[] words = titleString.split(" ");
            StringBuilder currentLine = new StringBuilder();
            for (String word : words) {
                int wordWidth = Minecraft.getInstance().font.width(word + " ");
                if (Minecraft.getInstance().font.width(currentLine.toString()) + wordWidth <= maxWidth) {
                    currentLine.append(word).append(" ");
                    continue;
                }
                lines.add((Component)Component.literal((String)currentLine.toString().trim()).withStyle(ChatFormatting.GOLD));
                currentLine = new StringBuilder(word).append(" ");
            }
            if (!currentLine.isEmpty()) {
                lines.add((Component)Component.literal((String)currentLine.toString().trim()).withStyle(ChatFormatting.GOLD));
            }
        }
        return lines;
    }

    @NotNull
    public ScreenRectangle getRectangle() {
        return new ScreenRectangle(this.getTotalX(), this.getTotalY(), this.getWidth(), this.getHeight());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        super.render(guiGraphics, mouseX, mouseY, partialTick, parentWidth, parentHeight);
        if (this.getRectangle().containsPoint(mouseX, mouseY)) {
            guiGraphics.setTooltipForNextFrame(Minecraft.getInstance().font, this.tooltip, Optional.empty(), mouseX, mouseY);
        }
    }
}

