/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.gui.jobs.components.conditions;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.client.gui.jobs.components.SlottedItemComponent;
import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.gui.component.EmptyComponent;
import com.daqem.uilib.gui.component.text.TextComponent;
import com.daqem.uilib.gui.component.text.multiline.MultiLineTextComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public class BlockConditionComponent
extends EmptyComponent {
    public BlockConditionComponent(Set<Block> allowedBlocks, Set<Block> deniedBlocks, Supplier<ScreenRectangle> parentBounds) {
        super(0, 0, 99, 0);
        ArrayList<Block> blocks = new ArrayList<Block>(allowedBlocks);
        blocks.removeAll(deniedBlocks);
        List<ItemStack> items = blocks.stream().map(Block::asItem).filter(item -> item != Items.AIR).collect(Collectors.toSet()).stream().map(Item::getDefaultInstance).sorted((b1, b2) -> {
            String name1 = b1.getItem().getName().getString();
            String name2 = b2.getItem().getName().getString();
            return name1.compareToIgnoreCase(name2);
        }).toList();
        if (items.isEmpty()) {
            this.setHeight(0);
        } else if (items.size() == 1) {
            TextComponent dotText = new TextComponent(0, 0, (Component)Component.literal((String)" \u2022 "), -14806000);
            this.addComponent((IComponent)dotText);
            MultiLineTextComponent isBlockTextComponent = new MultiLineTextComponent(10, 0, this.getWidth() - 10, (Component)JobsPlus.translatable("gui.jobs.condition.is", ((Block)blocks.getFirst()).getName()), -14806000);
            this.addComponent((IComponent)isBlockTextComponent);
            this.setHeight(isBlockTextComponent.getHeight());
        } else {
            int columns = 4;
            int rows = (int)Math.ceil((double)items.size() / 4.0);
            int startY = 0;
            int slotSize = 24;
            for (int i = 0; i < items.size(); ++i) {
                ItemStack itemStack = items.get(i);
                int x = i % 4 * (slotSize + 1);
                int y = startY + i / 4 * (slotSize + 1);
                this.addComponent((IComponent)new SlottedItemComponent(x, y, i, itemStack, parentBounds));
            }
            this.setHeight(startY + rows * (slotSize + 1));
        }
    }
}

