/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.event.triggers;

import com.daqem.arc.api.action.data.ActionDataBuilder;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.itemrestrictions.data.ItemRestriction;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.config.JobsPlusConfig;
import com.daqem.jobsplus.integration.arc.action.type.JobsPlusActionType;
import com.daqem.jobsplus.integration.arc.data.type.JobsPlusActionDataType;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.networking.s2c.ClientboundLevelUpJobPacket;
import com.daqem.jobsplus.networking.s2c.ClientboundUnlockItemRestrictionPacket;
import com.daqem.jobsplus.player.JobsPlayer;
import com.daqem.jobsplus.player.job.Job;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class JobEvents {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public static void onJobLevelUp(JobsPlayer player, Job job) {
        Player player2;
        if (player instanceof ArcPlayer) {
            ArcPlayer arcPlayer = (ArcPlayer)player;
            new ActionDataBuilder(arcPlayer, JobsPlusActionType.JOB_LEVEL_UP).withData(JobsPlusActionDataType.ONLY_FOR_JOB, (Object)job).build().sendToAction();
        }
        if ((player2 = player.jobsplus$getPlayer()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player2;
            NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ClientboundLevelUpJobPacket(job.getJobInstance().getLocation(), job.getLevel()));
            List<ItemRestriction> itemRestrictions = job.getJobInstance().getItemRestrictions().entrySet().stream().filter(entry -> ((Integer)entry.getValue()).intValue() == job.getLevel()).map(Map.Entry::getKey).toList();
            for (ItemRestriction itemRestriction : itemRestrictions) {
                NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ClientboundUnlockItemRestrictionPacket(itemRestriction.getLocation()));
            }
            JobEvents.triggerLevelUpEffects(serverPlayer);
            player.jobsplus$addCoins((Integer)JobsPlusConfig.coinsPerLevelUp.get());
            JobInstance jobInstance = job.getJobInstance();
            if (serverPlayer.getServer() == null) {
                return;
            }
            serverPlayer.getServer().getPlayerList().broadcastSystemMessage((Component)JobsPlus.translatable("job.level_up", serverPlayer.getName().copy().withStyle(style -> style.withColor(jobInstance.getColorDecimal())), JobsPlus.literal(String.valueOf(job.getLevel())).withStyle(style -> style.withColor(jobInstance.getColorDecimal())), jobInstance.getName().getString()), false);
        }
    }

    public static void onJobExperience(JobsPlayer player, Job job, int experience) {
        if (player instanceof ArcPlayer) {
            ArcPlayer arcPlayer = (ArcPlayer)player;
            new ActionDataBuilder(arcPlayer, JobsPlusActionType.JOB_EXP).withData(JobsPlusActionDataType.JOB_EXP, (Object)experience).withData(JobsPlusActionDataType.ONLY_FOR_JOB, (Object)job).build().sendToAction();
        }
    }

    private static void schedule(Runnable task, long delayInMillis) {
        scheduler.schedule(task, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static void triggerLevelUpEffects(ServerPlayer player) {
        JobEvents.schedule(() -> {
            JobEvents.playLevelUpSound(player, 0.5f, 2.0f);
            JobEvents.playEXPOrbPickupSound(player);
        }, 250L);
        JobEvents.schedule(() -> {
            JobEvents.playLevelUpSound(player, 1.0f, 2.0f);
            JobEvents.playEXPOrbPickupSound(player);
        }, 450L);
        JobEvents.schedule(() -> {
            JobEvents.playLevelUpSound(player, 0.5f, 1.5f);
            JobEvents.playEXPOrbPickupSound(player);
        }, 550L);
    }

    public static void playLevelUpSound(ServerPlayer player, float volume, float pitch) {
        player.level().playSound(null, player.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.AMBIENT, volume, pitch);
    }

    public static void playEXPOrbPickupSound(ServerPlayer player) {
        player.level().playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.AMBIENT, 1.0f, 1.0f);
    }
}

