/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.condition.conditions.job;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.IConditionType;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.integration.arc.condition.conditions.job.IJobCondition;
import com.daqem.jobsplus.integration.arc.condition.type.JobsPlusConditionType;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.job.Job;
import com.google.gson.JsonObject;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class HasJobCondition
extends AbstractCondition
implements IJobCondition {
    private final ResourceLocation jobLocation;

    public HasJobCondition(boolean inverted, ResourceLocation jobLocation) {
        super(inverted);
        this.jobLocation = jobLocation;
    }

    public boolean isMet(ActionData actionData) {
        JobInstance jobInstance = JobInstance.of(this.jobLocation);
        if (jobInstance != null) {
            JobsServerPlayer jobsServerPlayer;
            Job job;
            ArcPlayer arcPlayer;
            if (jobInstance.getLocation().equals((Object)this.jobLocation) && (arcPlayer = actionData.getPlayer()) instanceof JobsServerPlayer && (job = (jobsServerPlayer = (JobsServerPlayer)arcPlayer).jobsplus$getJob(jobInstance)) != null) {
                return job.getLevel() > 0;
            }
        } else {
            JobsPlus.LOGGER.error("Job " + String.valueOf(this.jobLocation) + " does not exist! Trying to use it in the condition has_job.");
        }
        return false;
    }

    public IConditionType<? extends ICondition> getType() {
        return JobsPlusConditionType.HAS_JOB;
    }

    @Override
    public ResourceLocation getJobLocation() {
        return this.jobLocation;
    }

    @Override
    public int getRequiredLevel() {
        return 0;
    }

    public Component getDescription() {
        JobInstance jobInstance = JobInstance.of(this.jobLocation);
        if (jobInstance == null) {
            return JobsPlus.literal("ERROR: Job not found: '" + this.jobLocation.toString() + "'");
        }
        return this.getDescription(new Object[]{jobInstance.getName()});
    }

    public static class Serializer
    implements IConditionSerializer<HasJobCondition> {
        public HasJobCondition fromJson(ResourceLocation location, JsonObject jsonObject, boolean inverted) {
            return new HasJobCondition(inverted, this.getResourceLocation(jsonObject, "job"));
        }

        public HasJobCondition fromNetwork(ResourceLocation location, RegistryFriendlyByteBuf friendlyByteBuf, boolean inverted) {
            return new HasJobCondition(inverted, friendlyByteBuf.readResourceLocation());
        }

        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, HasJobCondition type) {
            super.toNetwork(friendlyByteBuf, (ICondition)type);
            friendlyByteBuf.writeResourceLocation(type.jobLocation);
        }
    }
}

