/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.condition.conditions.job.powerup;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.IConditionType;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.integration.arc.condition.type.JobsPlusConditionType;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.player.JobsPlayer;
import com.daqem.jobsplus.player.job.powerup.Powerup;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import com.google.gson.JsonObject;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PowerupNotActiveCondition
extends AbstractCondition {
    private final ResourceLocation powerupThatShouldNotBeActiveLocation;

    public PowerupNotActiveCondition(boolean inverted, ResourceLocation powerupThatShouldNotBeActiveLocation) {
        super(inverted);
        this.powerupThatShouldNotBeActiveLocation = powerupThatShouldNotBeActiveLocation;
    }

    public boolean isMet(ActionData actionData) {
        ArcPlayer arcPlayer = actionData.getPlayer();
        if (arcPlayer instanceof JobsPlayer) {
            JobsPlayer player = (JobsPlayer)arcPlayer;
            PowerupInstance powerupInstance = PowerupInstance.of(this.powerupThatShouldNotBeActiveLocation);
            Optional<Powerup> powerup = player.jobsplus$getJobs().stream().map(job -> job.getPowerupManager().getPowerup(powerupInstance)).filter(Optional::isPresent).map(Optional::get).findFirst();
            return powerup.isEmpty() || powerup.get().getPowerupInstance().getLocation().equals((Object)this.powerupThatShouldNotBeActiveLocation) && powerup.get().getState() != PowerupState.ACTIVE;
        }
        return false;
    }

    public IConditionType<? extends ICondition> getType() {
        return JobsPlusConditionType.POWERUP_NOT_ACTIVE;
    }

    public Component getDescription() {
        PowerupInstance powerupInstance = PowerupInstance.of(this.powerupThatShouldNotBeActiveLocation);
        if (powerupInstance == null) {
            return JobsPlus.literal("ERROR: Powerup not found: '" + this.powerupThatShouldNotBeActiveLocation.toString() + "'");
        }
        return this.getDescription(new Object[]{powerupInstance.getName()});
    }

    public static class Serializer
    implements IConditionSerializer<PowerupNotActiveCondition> {
        public PowerupNotActiveCondition fromJson(ResourceLocation location, JsonObject jsonObject, boolean inverted) {
            return new PowerupNotActiveCondition(inverted, this.getResourceLocation(jsonObject, "powerup"));
        }

        public PowerupNotActiveCondition fromNetwork(ResourceLocation location, RegistryFriendlyByteBuf friendlyByteBuf, boolean inverted) {
            return new PowerupNotActiveCondition(inverted, friendlyByteBuf.readResourceLocation());
        }

        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, PowerupNotActiveCondition type) {
            super.toNetwork(friendlyByteBuf, (ICondition)type);
            friendlyByteBuf.writeResourceLocation(type.powerupThatShouldNotBeActiveLocation);
        }
    }
}

