/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.holder.holders.powerup;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.holder.AbstractActionHolder;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.action.holder.serializer.IActionHolderSerializer;
import com.daqem.arc.api.action.holder.type.IActionHolderType;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupManager;
import com.daqem.jobsplus.integration.arc.holder.type.JobsPlusActionHolderType;
import com.daqem.jobsplus.player.JobsPlayer;
import com.daqem.jobsplus.player.job.Job;
import com.daqem.jobsplus.player.job.powerup.Powerup;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import com.daqem.jobsplus.player.job.powerup.PowerupType;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class PowerupInstance
extends AbstractActionHolder {
    private final ResourceLocation jobLocation;
    @Nullable
    private final ResourceLocation parentLocation;
    private final ItemStack icon;
    private final int price;
    private final int requiredLevel;
    private final PowerupType type;

    public PowerupInstance(ResourceLocation location, ResourceLocation jobLocation, @Nullable ResourceLocation parentLocation, ItemStack icon, int price, int requiredLevel, PowerupType type) {
        super(location);
        this.jobLocation = jobLocation;
        this.parentLocation = parentLocation;
        this.icon = icon;
        this.price = price;
        this.requiredLevel = requiredLevel;
        this.type = type;
    }

    public MutableComponent getName() {
        return JobsPlus.translatable("powerup." + this.location.getNamespace() + "." + this.location.getPath().replace('/', '.') + ".name");
    }

    public MutableComponent getDescription() {
        return JobsPlus.translatable("powerup." + this.location.getNamespace() + "." + this.location.getPath().replace('/', '.') + ".description");
    }

    public ResourceLocation getJobLocation() {
        return this.jobLocation;
    }

    @Nullable
    public ResourceLocation getParentLocation() {
        return this.parentLocation;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public int getPrice() {
        return this.price;
    }

    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    public PowerupType getPowerupType() {
        return this.type;
    }

    public IActionHolderType<?> getType() {
        return JobsPlusActionHolderType.POWERUP_INSTANCE;
    }

    @Nullable
    public static PowerupInstance of(ResourceLocation location) {
        return PowerupManager.getInstance().getAllPowerups().get(location);
    }

    public boolean passedHolderCondition(ActionData actionData) {
        Powerup powerup;
        JobsPlayer jobsPlayer;
        Job job;
        ArcPlayer arcPlayer = actionData.getPlayer();
        if (arcPlayer instanceof JobsPlayer && (job = (Job)(jobsPlayer = (JobsPlayer)arcPlayer).jobsplus$getJobs().stream().filter(job1 -> job1 != null && job1.getJobInstance() != null && job1.getJobInstance().getLocation().equals((Object)this.getJobLocation())).findFirst().orElse(null)) != null && (powerup = (Powerup)job.getPowerupManager().getAllPowerups().stream().filter(powerup1 -> powerup1.getPowerupInstance().getLocation().equals((Object)this.getLocation())).findFirst().orElse(null)) != null) {
            return powerup.getState() == PowerupState.ACTIVE;
        }
        return false;
    }

    public PowerupInstance getParent() {
        return this.parentLocation == null ? null : PowerupManager.getInstance().getAllPowerups().get(this.parentLocation);
    }

    public List<PowerupInstance> getChildren() {
        return PowerupManager.getInstance().getAllPowerups().values().stream().filter(powerupInstance -> powerupInstance.getParentLocation() != null && powerupInstance.getParentLocation().equals((Object)this.getLocation())).toList();
    }

    public static class Serializer
    implements JsonDeserializer<PowerupInstance>,
    IActionHolderSerializer<PowerupInstance> {
        public PowerupInstance deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            return this.fromJson(jsonObject, this.getResourceLocation(jsonObject, "location"));
        }

        public PowerupInstance fromJson(JsonObject jsonObject, ResourceLocation resourceLocation) {
            String parentLocation = GsonHelper.getAsString((JsonObject)jsonObject, (String)"parent", null);
            return new PowerupInstance(resourceLocation, this.getResourceLocation(jsonObject, "job"), parentLocation == null ? null : ResourceLocation.parse((String)parentLocation), this.getItemStack((JsonElement)GsonHelper.getAsJsonObject((JsonObject)jsonObject, (String)"icon")), GsonHelper.getAsInt((JsonObject)jsonObject, (String)"price"), GsonHelper.getAsInt((JsonObject)jsonObject, (String)"required_level"), PowerupType.valueOf(GsonHelper.getAsString((JsonObject)jsonObject, (String)"type", (String)"basic").toUpperCase()));
        }

        public PowerupInstance fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf, ResourceLocation resourceLocation) {
            return new PowerupInstance(friendlyByteBuf.readResourceLocation(), friendlyByteBuf.readResourceLocation(), friendlyByteBuf.readBoolean() ? friendlyByteBuf.readResourceLocation() : null, (ItemStack)ItemStack.STREAM_CODEC.decode((Object)friendlyByteBuf), friendlyByteBuf.readInt(), friendlyByteBuf.readInt(), (PowerupType)friendlyByteBuf.readEnum(PowerupType.class));
        }

        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, PowerupInstance powerupInstance) {
            friendlyByteBuf.writeResourceLocation(powerupInstance.getLocation());
            friendlyByteBuf.writeResourceLocation(powerupInstance.getJobLocation());
            friendlyByteBuf.writeBoolean(powerupInstance.getParentLocation() != null);
            if (powerupInstance.getParentLocation() != null) {
                friendlyByteBuf.writeResourceLocation(powerupInstance.getParentLocation());
            }
            ItemStack.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)powerupInstance.getIcon());
            friendlyByteBuf.writeInt(powerupInstance.getPrice());
            friendlyByteBuf.writeInt(powerupInstance.getRequiredLevel());
            friendlyByteBuf.writeEnum((Enum)powerupInstance.getPowerupType());
            super.toNetwork(friendlyByteBuf, (IActionHolder)powerupInstance);
        }
    }
}

