/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.gui.jobs.components;

import com.daqem.arc.api.action.data.ActionDataBuilder;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.action.type.ActionType;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.arc.data.condition.NotCondition;
import com.daqem.arc.data.condition.OrCondition;
import com.daqem.arc.data.condition.block.BlockCondition;
import com.daqem.arc.data.condition.block.BlocksCondition;
import com.daqem.arc.data.condition.block.NotInBlockPosCacheCondition;
import com.daqem.arc.data.condition.block.ore.IsOreCondition;
import com.daqem.arc.data.condition.block.properties.BlockHardnessCondition;
import com.daqem.arc.data.condition.item.ItemCondition;
import com.daqem.arc.data.condition.item.ItemsCondition;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.client.gui.jobs.components.conditions.BlockConditionComponent;
import com.daqem.jobsplus.client.gui.jobs.components.conditions.DefaultConditionComponent;
import com.daqem.jobsplus.client.gui.jobs.components.conditions.ItemConditionComponent;
import com.daqem.jobsplus.client.gui.jobs.components.conditions.NotConditionComponent;
import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.gui.component.EmptyComponent;
import com.daqem.uilib.gui.component.text.TruncatedTextComponent;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;

public class ConditionsComponent
extends EmptyComponent {
    private static List<Block> ORE_BLOCKS = null;

    public ConditionsComponent(List<ICondition> conditions, Supplier<ScreenRectangle> parentBounds) {
        super(0, 0, 99, 9);
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        if (conditions.isEmpty()) {
            TruncatedTextComponent noConditionsText = new TruncatedTextComponent(0, 2, this.getWidth(), (Component)JobsPlus.translatable("gui.jobs.no_conditions"), -14806000);
            this.addComponent((IComponent)noConditionsText);
            this.setHeight(noConditionsText.getHeight());
        } else {
            TruncatedTextComponent title = new TruncatedTextComponent(0, 2, this.getWidth(), (Component)JobsPlus.translatable("gui.jobs.conditions").withStyle(style -> style.withUnderlined(Boolean.valueOf(true))), -14806000);
            this.addComponent((IComponent)title);
            int yOffset = title.getHeight() + 4;
            HashSet<Object> parsedConditions = new HashSet<Object>();
            List<NotCondition> notConditions = this.getNotConditions(conditions);
            conditions = conditions.stream().sorted(Comparator.comparing(x -> {
                if (x instanceof NotCondition) {
                    return 3;
                }
                if (x instanceof OrCondition) {
                    return 2;
                }
                if (x instanceof BlockCondition || x instanceof BlocksCondition || x instanceof ItemCondition || x instanceof ItemsCondition) {
                    return 0;
                }
                return 1;
            })).toList();
            for (ICondition condition : conditions) {
                Object blockConditionComponent;
                float hardness;
                BlocksCondition nbcs;
                BlockCondition nbc;
                Object bcs;
                BlockCondition bc;
                HashSet<Block> deniedBlocks;
                HashSet<Object> allowedBlocks;
                List<ICondition> notBlockConditions;
                if (parsedConditions.contains(condition)) continue;
                if (condition instanceof NotInBlockPosCacheCondition || condition instanceof OrCondition) {
                    parsedConditions.add(condition);
                    continue;
                }
                if (condition instanceof NotCondition) continue;
                if (condition instanceof BlockCondition || condition instanceof BlocksCondition) {
                    List<ICondition> blockConditions = conditions.stream().filter(c -> c instanceof BlockCondition || c instanceof BlocksCondition || c instanceof BlockHardnessCondition).toList();
                    notBlockConditions = notConditions.stream().map(NotCondition::getConditions).flatMap(Collection::stream).filter(c -> c instanceof BlockCondition || c instanceof BlocksCondition || c instanceof BlockHardnessCondition || c instanceof IsOreCondition).toList();
                    allowedBlocks = new HashSet();
                    deniedBlocks = new HashSet<Block>();
                    for (ICondition blockCondition : blockConditions) {
                        if (blockCondition instanceof BlockCondition) {
                            bc = (BlockCondition)blockCondition;
                            allowedBlocks.add(bc.getBlock());
                            parsedConditions.add(blockCondition);
                            continue;
                        }
                        if (!(blockCondition instanceof BlocksCondition)) continue;
                        bcs = (BlocksCondition)blockCondition;
                        allowedBlocks.addAll(bcs.getAllBlocks(level.registryAccess()));
                        parsedConditions.add(blockCondition);
                    }
                    for (ICondition blockCondition : blockConditions) {
                        if (!(blockCondition instanceof BlockHardnessCondition)) continue;
                        BlockHardnessCondition bhc2 = (BlockHardnessCondition)blockCondition;
                        for (Block block2 : allowedBlocks) {
                            float hardness2 = block2.defaultBlockState().getDestroySpeed((BlockGetter)Objects.requireNonNull(level), BlockPos.ZERO);
                            if (bhc2.getMin() > hardness2) {
                                deniedBlocks.add(block2);
                            }
                            if (!(bhc2.getMax() < hardness2)) continue;
                            deniedBlocks.add(block2);
                        }
                        parsedConditions.add(blockCondition);
                    }
                    for (ICondition notBlockCondition : notBlockConditions) {
                        if (notBlockCondition instanceof BlockCondition) {
                            nbc = (BlockCondition)notBlockCondition;
                            deniedBlocks.add(nbc.getBlock());
                            parsedConditions.add(notBlockCondition);
                            continue;
                        }
                        if (notBlockCondition instanceof BlocksCondition) {
                            nbcs = (BlocksCondition)notBlockCondition;
                            deniedBlocks.addAll(nbcs.getAllBlocks(level.registryAccess()));
                            parsedConditions.add(notBlockCondition);
                            continue;
                        }
                        if (notBlockCondition instanceof BlockHardnessCondition) {
                            BlockHardnessCondition blockHardnessCondition = (BlockHardnessCondition)notBlockCondition;
                            for (Block block3 : allowedBlocks) {
                                hardness = block3.defaultBlockState().getDestroySpeed((BlockGetter)Objects.requireNonNull(level), BlockPos.ZERO);
                                if (blockHardnessCondition.getMin() > hardness) {
                                    deniedBlocks.add(block3);
                                }
                                if (!(blockHardnessCondition.getMax() < hardness)) continue;
                                deniedBlocks.add(block3);
                            }
                            parsedConditions.add(notBlockCondition);
                            continue;
                        }
                        if (!(notBlockCondition instanceof IsOreCondition)) continue;
                        for (Block block4 : allowedBlocks) {
                            if (!this.getOreBlocks().contains(block4)) continue;
                            deniedBlocks.add(block4);
                        }
                        parsedConditions.add(notBlockCondition);
                    }
                    blockConditionComponent = new BlockConditionComponent(allowedBlocks, deniedBlocks, parentBounds);
                    blockConditionComponent.setY(yOffset);
                    this.addComponent((IComponent)blockConditionComponent);
                    yOffset += blockConditionComponent.getHeight();
                    continue;
                }
                if (condition instanceof BlockHardnessCondition) {
                    BlockHardnessCondition hardnessCondition = (BlockHardnessCondition)condition;
                    if (parsedConditions.contains(hardnessCondition)) continue;
                    if (conditions.stream().noneMatch(b -> b instanceof BlockCondition || b instanceof BlocksCondition)) {
                        Set allowedBlocks2 = level.registryAccess().lookupOrThrow(Registries.BLOCK).stream().filter(block -> {
                            float hardness = block.defaultBlockState().getDestroySpeed((BlockGetter)Objects.requireNonNull(level), BlockPos.ZERO);
                            return hardnessCondition.getMin() <= hardness && hardness <= hardnessCondition.getMax();
                        }).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
                        BlockConditionComponent hardnessConditionComponent = new BlockConditionComponent(allowedBlocks2, new HashSet<Block>(), parentBounds);
                        hardnessConditionComponent.setY(yOffset);
                        this.addComponent((IComponent)hardnessConditionComponent);
                        yOffset += hardnessConditionComponent.getHeight();
                        parsedConditions.add(hardnessCondition);
                        continue;
                    }
                }
                if (condition instanceof IsOreCondition) {
                    IsOreCondition isOreCondition = (IsOreCondition)condition;
                    if (parsedConditions.contains(isOreCondition)) continue;
                    if (conditions.stream().noneMatch(b -> b instanceof BlockCondition || b instanceof BlocksCondition)) {
                        notBlockConditions = notConditions.stream().map(NotCondition::getConditions).flatMap(Collection::stream).filter(c -> c instanceof BlockCondition || c instanceof BlocksCondition || c instanceof BlockHardnessCondition).toList();
                        allowedBlocks = new HashSet<Block>(this.getOreBlocks());
                        deniedBlocks = new HashSet();
                        for (ICondition notBlockCondition : notBlockConditions) {
                            if (notBlockCondition instanceof BlockCondition) {
                                nbc = (BlockCondition)notBlockCondition;
                                deniedBlocks.add(nbc.getBlock());
                            } else if (notBlockCondition instanceof BlocksCondition) {
                                nbcs = (BlocksCondition)notBlockCondition;
                                deniedBlocks.addAll(nbcs.getBlocks());
                            } else if (notBlockCondition instanceof BlockHardnessCondition) {
                                BlockHardnessCondition blockHardnessCondition = (BlockHardnessCondition)notBlockCondition;
                                for (Block block5 : allowedBlocks) {
                                    hardness = block5.defaultBlockState().getDestroySpeed((BlockGetter)Objects.requireNonNull(level), BlockPos.ZERO);
                                    if (blockHardnessCondition.getMin() > hardness) {
                                        deniedBlocks.add(block5);
                                    }
                                    if (!(blockHardnessCondition.getMax() < hardness)) continue;
                                    deniedBlocks.add(block5);
                                }
                            }
                            parsedConditions.add(notBlockCondition);
                        }
                        blockConditionComponent = new BlockConditionComponent(allowedBlocks, deniedBlocks, parentBounds);
                        blockConditionComponent.setY(yOffset);
                        this.addComponent((IComponent)blockConditionComponent);
                        yOffset += blockConditionComponent.getHeight();
                        parsedConditions.add(isOreCondition);
                        continue;
                    }
                }
                if (condition instanceof ItemCondition || condition instanceof ItemsCondition) {
                    List<ICondition> itemConditions = conditions.stream().filter(c -> c instanceof ItemCondition || c instanceof ItemsCondition).toList();
                    List<ICondition> notItemConditions = notConditions.stream().map(NotCondition::getConditions).flatMap(Collection::stream).filter(c -> c instanceof ItemCondition || c instanceof ItemsCondition).toList();
                    HashSet<ItemStack> allowedItems = new HashSet<ItemStack>();
                    HashSet<ItemStack> deniedItems = new HashSet<ItemStack>();
                    for (ICondition itemCondition : itemConditions) {
                        if (itemCondition instanceof ItemCondition) {
                            bc = (ItemCondition)itemCondition;
                            allowedItems.add(bc.getItemStack());
                            parsedConditions.add(itemCondition);
                            continue;
                        }
                        if (!(itemCondition instanceof ItemsCondition)) continue;
                        bcs = (ItemsCondition)itemCondition;
                        allowedItems.addAll(bcs.getItemStacks(level.registryAccess()));
                        parsedConditions.add(itemCondition);
                    }
                    for (ICondition notItemCondition : notItemConditions) {
                        if (notItemCondition instanceof ItemCondition) {
                            nbc = (ItemCondition)notItemCondition;
                            deniedItems.add(nbc.getItemStack());
                            parsedConditions.add(notItemCondition);
                            continue;
                        }
                        if (!(notItemCondition instanceof ItemsCondition)) continue;
                        nbcs = (ItemsCondition)notItemCondition;
                        deniedItems.addAll(nbcs.getItemStacks(level.registryAccess()));
                        parsedConditions.add(notItemCondition);
                    }
                    ItemConditionComponent itemConditionComponent = new ItemConditionComponent(allowedItems, deniedItems, parentBounds);
                    itemConditionComponent.setY(yOffset);
                    this.addComponent((IComponent)itemConditionComponent);
                    yOffset += itemConditionComponent.getHeight();
                    continue;
                }
                DefaultConditionComponent conditionComponent = new DefaultConditionComponent(condition);
                conditionComponent.setY(yOffset);
                this.addComponent((IComponent)conditionComponent);
                yOffset += conditionComponent.getHeight();
            }
            for (NotCondition notCondition : notConditions) {
                if (parsedConditions.contains(notCondition)) continue;
                for (ICondition innerCondition : notCondition.getConditions()) {
                    if (parsedConditions.contains(innerCondition)) continue;
                    NotConditionComponent notConditionComponent = new NotConditionComponent(notCondition, innerCondition);
                    notConditionComponent.setY(yOffset);
                    this.addComponent((IComponent)notConditionComponent);
                    yOffset += notConditionComponent.getHeight();
                    parsedConditions.add(innerCondition);
                }
                parsedConditions.add(notCondition);
            }
            this.setHeight(yOffset);
        }
    }

    private List<NotCondition> getNotConditions(List<ICondition> conditions) {
        return conditions.stream().filter(c -> c instanceof NotCondition).map(c -> (NotCondition)c).toList();
    }

    private List<Block> getOreBlocks() {
        if (ORE_BLOCKS == null) {
            ClientLevel level = Minecraft.getInstance().level;
            if (level == null) {
                return List.of();
            }
            List<Block> oreBlocks = level.registryAccess().lookupOrThrow(Registries.BLOCK).stream().filter(block -> new IsOreCondition(false).isMet(new ActionDataBuilder((ArcPlayer)Minecraft.getInstance().player, ActionType.BREAK_BLOCK).withData(ActionDataType.BLOCK_STATE, (Object)block.defaultBlockState()).build())).toList();
            ORE_BLOCKS = oreBlocks;
            return oreBlocks;
        }
        return ORE_BLOCKS;
    }
}

