/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.gui.jobs.components;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.client.gui.jobs.JobsScreenState;
import com.daqem.jobsplus.client.gui.jobs.widgets.StartJobButtonWidget;
import com.daqem.jobsplus.config.JobsPlusConfig;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.player.job.Job;
import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.api.widget.IWidget;
import com.daqem.uilib.gui.component.EmptyComponent;
import com.daqem.uilib.gui.component.item.ItemComponent;
import com.daqem.uilib.gui.component.sprite.SpriteComponent;
import com.daqem.uilib.gui.component.text.TruncatedTextComponent;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix3x2fStack;

public class SelectedJobComponent
extends EmptyComponent {
    private final JobsScreenState state;
    private final TruncatedTextComponent jobTitleComponent;
    private final ItemComponent jobIconComponent;
    private final StartJobButtonWidget startJobButtonWidget;

    public SelectedJobComponent(JobsScreenState state) {
        super(21, 20, 117, 34);
        this.state = state;
        this.jobTitleComponent = new TruncatedTextComponent(26, 0, 90, (Component)Component.empty(), 0);
        this.jobIconComponent = new ItemComponent(4, 4, ItemStack.EMPTY);
        this.startJobButtonWidget = new StartJobButtonWidget(this.state);
        SpriteComponent jobIconSlotComponent = new SpriteComponent(0, 0, 24, 24, JobsPlus.getId("jobs/job_icon_slot"));
        SpriteComponent separatorComponent = new SpriteComponent(0, 27, 113, 7, JobsPlus.getId("jobs/separator_line"));
        this.addComponent((IComponent)this.jobTitleComponent);
        this.addComponent((IComponent)jobIconSlotComponent);
        this.addComponent((IComponent)separatorComponent);
        this.addComponent((IComponent)this.jobIconComponent);
        if (this.state.getSelectedJob().getLevel() == 0 && this.canStartNewJob()) {
            this.addWidget((IWidget)this.startJobButtonWidget);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        Job selectedJob = this.state.getSelectedJob();
        JobInstance jobInstance = selectedJob.getJobInstance();
        this.jobTitleComponent.setText((Component)jobInstance.getName().copy().withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
        this.jobTitleComponent.setColor(jobInstance.getColorDecimal() | 0xFF000000);
        this.jobIconComponent.setItemStack(jobInstance.getIconItem());
        if (selectedJob.getLevel() > 0) {
            guiGraphics.pose().pushMatrix();
            Matrix3x2fStack matrix3x2fStack = guiGraphics.pose();
            float f = this.getTotalX() + 26;
            int n = this.getTotalY();
            Objects.requireNonNull(Minecraft.getInstance().font);
            matrix3x2fStack.translate(f, (float)(n + 9));
            guiGraphics.pose().scale(0.75f, 0.75f);
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)JobsPlus.translatable("gui.jobs.level", selectedJob.getLevel()), 0, 0, -14806000, false);
            Font font = Minecraft.getInstance().font;
            MutableComponent mutableComponent = JobsPlus.translatable("gui.jobs.experience", selectedJob.getExperience(), selectedJob.getExperienceForNextLevel());
            Objects.requireNonNull(Minecraft.getInstance().font);
            guiGraphics.drawString(font, (Component)mutableComponent, 0, 9, -14806000, false);
            guiGraphics.pose().popMatrix();
            this.removeWidget((IWidget)this.startJobButtonWidget);
        } else {
            guiGraphics.pose().pushMatrix();
            Matrix3x2fStack matrix3x2fStack = guiGraphics.pose();
            float f = this.getTotalX() + 26;
            int n = this.getTotalY();
            Objects.requireNonNull(Minecraft.getInstance().font);
            matrix3x2fStack.translate(f, (float)(n + 9));
            guiGraphics.pose().scale(0.75f, 0.75f);
            if (this.canStartNewJob()) {
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)JobsPlus.translatable("gui.jobs.price", jobInstance.getPrice()), 0, 0, -14806000, false);
            } else {
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)JobsPlus.translatable("gui.jobs.max_jobs", JobsPlusConfig.maxJobs.get()), 0, 0, -43691, false);
            }
            guiGraphics.pose().popMatrix();
            if (jobInstance.getPrice() > this.state.getCoins() && !this.canStartFreeJob()) {
                this.removeWidget((IWidget)this.startJobButtonWidget);
            } else if (!this.getWidgets().contains((Object)this.startJobButtonWidget) && this.canStartNewJob()) {
                this.addWidget((IWidget)this.startJobButtonWidget);
                this.updateParentPosition(this.getParentX(), this.getParentY(), parentWidth, parentHeight);
            }
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick, parentWidth, parentHeight);
    }

    private boolean canStartNewJob() {
        return this.state.getActiveJobCount() < (Integer)JobsPlusConfig.maxJobs.get();
    }

    private boolean canStartFreeJob() {
        return this.state.getActiveJobCount() < (Integer)JobsPlusConfig.amountOfFreeJobs.get();
    }
}

