/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.gui.jobs.widgets;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.client.gui.jobs.JobsScreenState;
import com.daqem.jobsplus.player.job.Job;
import com.daqem.uilib.gui.widget.CustomButtonWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class JobSelectionItemWidget
extends CustomButtonWidget {
    private static final WidgetSprites SPRITES = new WidgetSprites(JobsPlus.getId("jobs/job_button"), JobsPlus.getId("jobs/job_button_hovered"));
    private final Job job;
    private final JobsScreenState state;

    public JobSelectionItemWidget(Job job, JobsScreenState state) {
        super(0, 0, 99, 19, (Component)job.getJobInstance().getName(), SPRITES, button -> state.setSelectedJob(job));
        this.job = job;
        this.state = state;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SPRITES.get(this.active, this.isHovered() || this.job == this.state.getSelectedJob()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)(this.getX() + 5), (float)(this.getY() + 3));
        guiGraphics.pose().scale(0.75f, 0.75f);
        guiGraphics.renderFakeItem(this.job.getJobInstance().getIconItem(), 0, 0);
        guiGraphics.pose().popMatrix();
        guiGraphics.drawString(minecraft.font, (Component)this.getMessage().copy().withColor(this.job.getJobInstance().getColorDecimal()), this.getX() + 20, this.getY() + (this.job.getLevel() > 0 ? 4 : 5), -14806000, false);
        if (this.job.getLevel() > 0) {
            guiGraphics.drawString(minecraft.font, (Component)JobsPlus.literal("" + this.job.getLevel()), this.getX() + this.getWidth() - 2 - minecraft.font.width("" + this.job.getLevel()), this.getY() + 4, -2572394, false);
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, JobsPlus.getId("jobs/exp_bar"), this.getX() + 20, this.getY() + 13, 76, 3);
            double expPercentage = this.job.getExperiencePercentage();
            int expWidth = (int)Mth.clamp((double)(expPercentage / 100.0 * 75.0), (double)1.0, (double)75.0);
            guiGraphics.fill(this.getX() + 21, this.getY() + 14, this.getX() + 21 + expWidth, this.getY() + 15, this.job.getJobInstance().getColorDecimal() | 0xFF000000);
        }
    }
}

