/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.holder.holders.job;

import com.daqem.arc.api.action.holder.AbstractActionHolder;
import com.daqem.arc.api.action.holder.ActionHolderManager;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.JobsPlusExpectPlatform;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.integration.arc.holder.type.JobsPlusActionHolderType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class JobManager
extends SimplePreparableReloadListener<List<IActionHolder>> {
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(JobInstance.class, (Object)new JobInstance.Serializer()).create();
    private static JobManager instance;

    public JobManager() {
        instance = this;
    }

    @NotNull
    protected List<IActionHolder> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        Map<ResourceLocation, Resource> resourceMap = resourceManager.listResources("jobsplus/jobs", resourceLocation -> resourceLocation.getPath().endsWith(".json")).entrySet().stream().collect(Collectors.toMap(entry -> ResourceLocation.fromNamespaceAndPath((String)((ResourceLocation)entry.getKey()).getNamespace(), (String)((ResourceLocation)entry.getKey()).getPath().substring(0, ((ResourceLocation)entry.getKey()).getPath().length() - ".json".length()).substring("jobsplus/jobs/".length())), Map.Entry::getValue));
        HashMap<ResourceLocation, JsonObject> map = new HashMap<ResourceLocation, JsonObject>();
        for (Map.Entry<ResourceLocation, Resource> entry2 : resourceMap.entrySet()) {
            ResourceLocation location = entry2.getKey();
            try {
                JsonObject jsonElement = GsonHelper.parse((Reader)entry2.getValue().openAsReader());
                map.put(location, jsonElement);
            }
            catch (Exception runtimeException) {
                JobsPlus.LOGGER.error("Parsing error loading job {}", (Object)location, (Object)runtimeException);
            }
        }
        ArrayList<IActionHolder> jobs = new ArrayList<IActionHolder>();
        if (!JobsPlus.isDebugEnvironment()) {
            map.entrySet().removeIf(entry -> ((ResourceLocation)entry.getKey()).getNamespace().equals("debug"));
        }
        for (Map.Entry entry3 : map.entrySet()) {
            ResourceLocation location = (ResourceLocation)entry3.getKey();
            JsonObject jsonObject = (JsonObject)entry3.getValue();
            jsonObject.addProperty("location", location.toString());
            try {
                JobInstance job = (JobInstance)((Object)GSON.fromJson((JsonElement)entry3.getValue(), JobInstance.class));
                jobs.add((IActionHolder)job);
            }
            catch (JsonParseException | IllegalArgumentException runtimeException) {
                JobsPlus.LOGGER.error("Parsing error loading job {}", (Object)location, (Object)runtimeException);
            }
        }
        return jobs;
    }

    protected void apply(List<IActionHolder> jobs, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        ActionHolderManager actionHolderManager = ActionHolderManager.getInstance();
        actionHolderManager.clearAllActionHoldersForType(JobsPlusActionHolderType.JOB_INSTANCE);
        actionHolderManager.registerActionHolders(jobs);
        JobsPlus.LOGGER.info("Loaded {} jobs", (Object)jobs.size());
    }

    public static JobManager getInstance() {
        return instance != null ? instance : JobsPlusExpectPlatform.getJobManager();
    }

    public Map<ResourceLocation, JobInstance> getJobs() {
        return ActionHolderManager.getInstance().getActionHolders().stream().filter(actionHolder -> actionHolder instanceof JobInstance).map(actionHolder -> (JobInstance)((Object)actionHolder)).collect(Collectors.toMap(AbstractActionHolder::getLocation, jobInstance -> jobInstance));
    }
}

