/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.holder.holders.powerup;

import com.daqem.arc.api.action.holder.AbstractActionHolder;
import com.daqem.arc.api.action.holder.ActionHolderManager;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.JobsPlusExpectPlatform;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.integration.arc.holder.type.JobsPlusActionHolderType;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class PowerupManager
extends SimplePreparableReloadListener<List<IActionHolder>> {
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(PowerupInstance.class, (Object)new PowerupInstance.Serializer()).create();
    private static PowerupManager instance;

    public PowerupManager() {
        instance = this;
    }

    @NotNull
    protected List<IActionHolder> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        Map<ResourceLocation, Resource> resourceMap = resourceManager.listResources("jobsplus/powerups", resourceLocation -> resourceLocation.getPath().endsWith(".json")).entrySet().stream().collect(Collectors.toMap(entry -> ResourceLocation.fromNamespaceAndPath((String)((ResourceLocation)entry.getKey()).getNamespace(), (String)((ResourceLocation)entry.getKey()).getPath().substring(0, ((ResourceLocation)entry.getKey()).getPath().length() - ".json".length()).substring("jobsplus/powerups/".length())), Map.Entry::getValue));
        HashMap<ResourceLocation, JsonObject> map = new HashMap<ResourceLocation, JsonObject>();
        for (Map.Entry<ResourceLocation, Resource> entry2 : resourceMap.entrySet()) {
            ResourceLocation location = entry2.getKey();
            try {
                JsonObject jsonElement = GsonHelper.parse((Reader)entry2.getValue().openAsReader());
                map.put(location, jsonElement);
            }
            catch (Exception runtimeException) {
                JobsPlus.LOGGER.error("Parsing error loading powerup {}", (Object)location, (Object)runtimeException);
            }
        }
        ArrayList<IActionHolder> powerups = new ArrayList<IActionHolder>();
        if (!JobsPlus.isDebugEnvironment()) {
            map.entrySet().removeIf(entry -> ((ResourceLocation)entry.getKey()).getNamespace().equals("debug"));
        }
        for (Map.Entry entry3 : map.entrySet()) {
            ResourceLocation location = (ResourceLocation)entry3.getKey();
            JsonObject jsonObject = (JsonObject)entry3.getValue();
            jsonObject.addProperty("location", location.toString());
            try {
                PowerupInstance powerup = (PowerupInstance)((Object)GSON.fromJson((JsonElement)entry3.getValue(), PowerupInstance.class));
                powerups.add((IActionHolder)powerup);
            }
            catch (JsonParseException | IllegalArgumentException runtimeException) {
                JobsPlus.LOGGER.error("Parsing error loading powerup {}", (Object)location, (Object)runtimeException);
            }
        }
        return powerups;
    }

    protected void apply(List<IActionHolder> powerups, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        ActionHolderManager actionHolderManager = ActionHolderManager.getInstance();
        actionHolderManager.clearAllActionHoldersForType(JobsPlusActionHolderType.POWERUP_INSTANCE);
        actionHolderManager.registerActionHolders(powerups);
        JobsPlus.LOGGER.info("Loaded {} powerups", (Object)powerups.size());
    }

    public static PowerupManager getInstance() {
        return instance != null ? instance : JobsPlusExpectPlatform.getPowerupManager();
    }

    public ImmutableMap<ResourceLocation, PowerupInstance> getRootPowerups() {
        return (ImmutableMap)this.getAllPowerups().entrySet().stream().filter(entry -> ((PowerupInstance)((Object)((Object)entry.getValue()))).getParentLocation() == null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<ResourceLocation, PowerupInstance> getAllPowerups() {
        return (Map)ActionHolderManager.getInstance().getActionHolders().stream().filter(actionHolder -> actionHolder instanceof PowerupInstance).map(actionHolder -> (PowerupInstance)((Object)actionHolder)).collect(ImmutableMap.toImmutableMap(AbstractActionHolder::getLocation, powerupInstance -> powerupInstance));
    }
}

