/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.gui.jobs.components;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.client.gui.jobs.JobsScreenState;
import com.daqem.jobsplus.client.gui.jobs.widgets.StartJobButtonWidget;
import com.daqem.jobsplus.config.JobsPlusConfig;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.player.job.Job;
import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.api.widget.IWidget;
import com.daqem.uilib.gui.component.EmptyComponent;
import com.daqem.uilib.gui.component.item.ItemComponent;
import com.daqem.uilib.gui.component.sprite.SpriteComponent;
import com.daqem.uilib.gui.component.text.TruncatedTextComponent;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.joml.Matrix3x2fStack;

public class SelectedJobComponent
extends EmptyComponent {
    private final JobsScreenState state;
    private final TruncatedTextComponent jobTitleComponent;
    private final ItemComponent jobIconComponent;
    private final StartJobButtonWidget startJobButtonWidget;

    public SelectedJobComponent(JobsScreenState state) {
        super(21, 20, 117, 34);
        this.state = state;
        this.jobTitleComponent = new TruncatedTextComponent(26, 0, 90, (class_2561)class_2561.method_43473(), 0);
        this.jobIconComponent = new ItemComponent(4, 4, class_1799.field_8037);
        this.startJobButtonWidget = new StartJobButtonWidget(this.state);
        SpriteComponent jobIconSlotComponent = new SpriteComponent(0, 0, 24, 24, JobsPlus.getId("jobs/job_icon_slot"));
        SpriteComponent separatorComponent = new SpriteComponent(0, 27, 113, 7, JobsPlus.getId("jobs/separator_line"));
        this.addComponent((IComponent)this.jobTitleComponent);
        this.addComponent((IComponent)jobIconSlotComponent);
        this.addComponent((IComponent)separatorComponent);
        this.addComponent((IComponent)this.jobIconComponent);
        if (this.state.getSelectedJob().getLevel() == 0 && this.canStartNewJob()) {
            this.addWidget((IWidget)this.startJobButtonWidget);
        }
    }

    public void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        Job selectedJob = this.state.getSelectedJob();
        JobInstance jobInstance = selectedJob.getJobInstance();
        this.jobTitleComponent.setText((class_2561)jobInstance.getName().method_27661().method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true))));
        this.jobTitleComponent.setColor(jobInstance.getColorDecimal() | 0xFF000000);
        this.jobIconComponent.setItemStack(jobInstance.getIconItem());
        if (selectedJob.getLevel() > 0) {
            guiGraphics.method_51448().pushMatrix();
            Matrix3x2fStack matrix3x2fStack = guiGraphics.method_51448();
            float f = this.getTotalX() + 26;
            int n = this.getTotalY();
            Objects.requireNonNull(class_310.method_1551().field_1772);
            matrix3x2fStack.translate(f, (float)(n + 9));
            guiGraphics.method_51448().scale(0.75f, 0.75f);
            guiGraphics.method_51439(class_310.method_1551().field_1772, (class_2561)JobsPlus.translatable("gui.jobs.level", selectedJob.getLevel()), 0, 0, -14806000, false);
            class_327 class_3272 = class_310.method_1551().field_1772;
            class_5250 class_52502 = JobsPlus.translatable("gui.jobs.experience", selectedJob.getExperience(), selectedJob.getExperienceForNextLevel());
            Objects.requireNonNull(class_310.method_1551().field_1772);
            guiGraphics.method_51439(class_3272, (class_2561)class_52502, 0, 9, -14806000, false);
            guiGraphics.method_51448().popMatrix();
            this.removeWidget((IWidget)this.startJobButtonWidget);
        } else {
            guiGraphics.method_51448().pushMatrix();
            Matrix3x2fStack matrix3x2fStack = guiGraphics.method_51448();
            float f = this.getTotalX() + 26;
            int n = this.getTotalY();
            Objects.requireNonNull(class_310.method_1551().field_1772);
            matrix3x2fStack.translate(f, (float)(n + 9));
            guiGraphics.method_51448().scale(0.75f, 0.75f);
            if (this.canStartNewJob()) {
                guiGraphics.method_51439(class_310.method_1551().field_1772, (class_2561)JobsPlus.translatable("gui.jobs.price", jobInstance.getPrice()), 0, 0, -14806000, false);
            } else {
                guiGraphics.method_51439(class_310.method_1551().field_1772, (class_2561)JobsPlus.translatable("gui.jobs.max_jobs", JobsPlusConfig.maxJobs.get()), 0, 0, -43691, false);
            }
            guiGraphics.method_51448().popMatrix();
            if (jobInstance.getPrice() > this.state.getCoins() && !this.canStartFreeJob()) {
                this.removeWidget((IWidget)this.startJobButtonWidget);
            } else if (!this.getWidgets().contains((Object)this.startJobButtonWidget) && this.canStartNewJob()) {
                this.addWidget((IWidget)this.startJobButtonWidget);
                this.updateParentPosition(this.getParentX(), this.getParentY(), parentWidth, parentHeight);
            }
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick, parentWidth, parentHeight);
    }

    private boolean canStartNewJob() {
        return this.state.getActiveJobCount() < (Integer)JobsPlusConfig.maxJobs.get();
    }

    private boolean canStartFreeJob() {
        return this.state.getActiveJobCount() < (Integer)JobsPlusConfig.amountOfFreeJobs.get();
    }
}

