/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.condition.conditions.job;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.IConditionType;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.integration.arc.condition.conditions.job.IJobCondition;
import com.daqem.jobsplus.integration.arc.condition.type.JobsPlusConditionType;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.job.Job;
import com.google.gson.JsonObject;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_9129;

public class JobLevelCondition
extends AbstractCondition
implements IJobCondition {
    private static final String EMPTY_JOB_LOCATION = "jobsplus:empty";
    private final class_2960 jobLocation;
    private final int level;

    public JobLevelCondition(boolean inverted, class_2960 jobLocation, int level) {
        super(inverted);
        this.jobLocation = jobLocation;
        this.level = level;
    }

    public boolean isMet(ActionData actionData) {
        JobsServerPlayer jobsServerPlayer;
        Job playerJob;
        JobInstance jobInstance;
        if (!this.jobLocation.equals((Object)class_2960.method_60654((String)EMPTY_JOB_LOCATION))) {
            jobInstance = JobInstance.of(this.jobLocation);
        } else {
            IActionHolder iActionHolder = actionData.getSourceActionHolder();
            if (iActionHolder instanceof JobInstance) {
                JobInstance jobInstance2;
                jobInstance = jobInstance2 = (JobInstance)iActionHolder;
            } else {
                return false;
            }
        }
        int playerJobLevel = 0;
        ArcPlayer arcPlayer = actionData.getPlayer();
        if (arcPlayer instanceof JobsServerPlayer && (playerJob = (jobsServerPlayer = (JobsServerPlayer)arcPlayer).jobsplus$getJob(jobInstance)) != null) {
            playerJobLevel = playerJob.getLevel();
        }
        return playerJobLevel >= this.level;
    }

    public IConditionType<? extends ICondition> getType() {
        return JobsPlusConditionType.JOB_LEVEL;
    }

    @Override
    public class_2960 getJobLocation() {
        return this.jobLocation;
    }

    @Override
    public int getRequiredLevel() {
        return this.level;
    }

    public class_2561 getDescription() {
        JobInstance jobInstance = JobInstance.of(this.jobLocation);
        if (jobInstance == null) {
            return JobsPlus.literal("ERROR: Job not found: '" + this.jobLocation.toString() + "'");
        }
        return this.getDescription(new Object[]{jobInstance.getName(), this.level});
    }

    public static class Serializer
    implements IConditionSerializer<JobLevelCondition> {
        public JobLevelCondition fromJson(class_2960 location, JsonObject jsonObject, boolean inverted) {
            return new JobLevelCondition(inverted, class_2960.method_60654((String)class_3518.method_15253((JsonObject)jsonObject, (String)"job", (String)JobLevelCondition.EMPTY_JOB_LOCATION)), class_3518.method_15260((JsonObject)jsonObject, (String)"level"));
        }

        public JobLevelCondition fromNetwork(class_2960 location, class_9129 friendlyByteBuf, boolean inverted) {
            return new JobLevelCondition(inverted, friendlyByteBuf.method_10810(), friendlyByteBuf.readInt());
        }

        public void toNetwork(class_9129 friendlyByteBuf, JobLevelCondition type) {
            super.toNetwork(friendlyByteBuf, (ICondition)type);
            friendlyByteBuf.method_10812(type.jobLocation);
            friendlyByteBuf.method_53002(type.level);
        }
    }
}

