/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.holder.holders.job;

import com.daqem.arc.api.action.holder.AbstractActionHolder;
import com.daqem.arc.api.action.holder.ActionHolderManager;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.action.holder.serializer.IActionHolderSerializer;
import com.daqem.arc.api.action.holder.type.IActionHolderType;
import com.daqem.itemrestrictions.data.ItemRestriction;
import com.daqem.itemrestrictions.data.ItemRestrictionManager;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.integration.arc.condition.conditions.job.IJobCondition;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobManager;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.integration.arc.holder.type.JobsPlusActionHolderType;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;

public class JobInstance
extends AbstractActionHolder {
    private final int price;
    private final String color;
    private final class_1799 iconItem;
    private final boolean isDefault;

    public JobInstance(class_2960 location, int price, String color, class_1799 iconItem, boolean isDefault) {
        super(location);
        this.price = price;
        this.color = color;
        this.iconItem = iconItem;
        this.isDefault = isDefault;
    }

    public int getPrice() {
        return this.price;
    }

    public class_5250 getName() {
        return JobsPlus.translatable("job." + this.location.method_12836() + "." + this.location.method_12832() + ".name");
    }

    public class_5250 getDescription() {
        return JobsPlus.translatable("job." + this.location.method_12836() + "." + this.location.method_12832() + ".description");
    }

    public List<PowerupInstance> getPowerups() {
        return ActionHolderManager.getInstance().getActionHolders().stream().filter(actionHolder -> {
            PowerupInstance powerupInstance;
            return actionHolder instanceof PowerupInstance && (powerupInstance = (PowerupInstance)((Object)actionHolder)).getJobLocation().equals((Object)this.location);
        }).map(actionHolder -> (PowerupInstance)((Object)actionHolder)).collect(Collectors.toList());
    }

    public int getColorDecimal() {
        return Integer.parseInt(this.color.replace("#", ""), 16);
    }

    public class_1799 getIconItem() {
        return this.iconItem;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Map<ItemRestriction, Integer> getItemRestrictions() {
        return ItemRestrictionManager.getInstance().getItemRestrictions().stream().filter(itemRestriction -> itemRestriction.getConditions().stream().anyMatch(condition -> {
            IJobCondition jobCondition;
            return condition instanceof IJobCondition && (jobCondition = (IJobCondition)condition).getJobLocation().equals((Object)this.location);
        })).collect(Collectors.toMap(itemRestriction -> new ItemRestriction(itemRestriction.getLocation(), itemRestriction.getIcon().method_7972(), new ArrayList(itemRestriction.getRestrictionTypes()), new ArrayList(itemRestriction.getConditions())), itemRestriction -> itemRestriction.getConditions().stream().filter(condition -> condition instanceof IJobCondition).map(iCondition -> ((IJobCondition)iCondition).getRequiredLevel()).max(Integer::compareTo).orElse(0)));
    }

    public IActionHolderType<?> getType() {
        return JobsPlusActionHolderType.JOB_INSTANCE;
    }

    @Nullable
    public static JobInstance of(class_2960 location) {
        return JobManager.getInstance().getJobs().get(location);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof JobInstance)) return false;
        JobInstance jobInstance = (JobInstance)((Object)obj);
        if (!jobInstance.location.equals((Object)this.location)) return false;
        return true;
    }

    public static class Serializer
    implements JsonDeserializer<JobInstance>,
    IActionHolderSerializer<JobInstance> {
        public JobInstance deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = element.getAsJsonObject();
            return this.fromJson(jsonObject, this.getResourceLocation(jsonObject, "location"));
        }

        public JobInstance fromJson(JsonObject jsonObject, class_2960 resourceLocation) {
            return new JobInstance(resourceLocation, class_3518.method_15260((JsonObject)jsonObject, (String)"price"), class_3518.method_15265((JsonObject)jsonObject, (String)"color"), this.getItemStack((JsonElement)class_3518.method_15296((JsonObject)jsonObject, (String)"icon")), class_3518.method_15258((JsonObject)jsonObject, (String)"is_default", (boolean)false));
        }

        public JobInstance fromNetwork(class_9129 friendlyByteBuf, class_2960 resourceLocation) {
            return new JobInstance(friendlyByteBuf.method_10810(), friendlyByteBuf.method_10816(), friendlyByteBuf.method_19772(), (class_1799)class_1799.field_48349.decode((Object)friendlyByteBuf), friendlyByteBuf.readBoolean());
        }

        public void toNetwork(class_9129 friendlyByteBuf, JobInstance jobInstance) {
            friendlyByteBuf.method_10812(jobInstance.location);
            friendlyByteBuf.method_10804(jobInstance.price);
            friendlyByteBuf.method_10814(jobInstance.color);
            class_1799.field_48349.encode((Object)friendlyByteBuf, (Object)jobInstance.iconItem);
            friendlyByteBuf.method_52964(jobInstance.isDefault);
            super.toNetwork(friendlyByteBuf, (IActionHolder)jobInstance);
        }
    }
}

