/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.holder.holders.powerup;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.holder.AbstractActionHolder;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.action.holder.serializer.IActionHolderSerializer;
import com.daqem.arc.api.action.holder.type.IActionHolderType;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupManager;
import com.daqem.jobsplus.integration.arc.holder.type.JobsPlusActionHolderType;
import com.daqem.jobsplus.player.JobsPlayer;
import com.daqem.jobsplus.player.job.Job;
import com.daqem.jobsplus.player.job.powerup.Powerup;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import com.daqem.jobsplus.player.job.powerup.PowerupType;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;

public class PowerupInstance
extends AbstractActionHolder {
    private final class_2960 jobLocation;
    @Nullable
    private final class_2960 parentLocation;
    private final class_1799 icon;
    private final int price;
    private final int requiredLevel;
    private final PowerupType type;

    public PowerupInstance(class_2960 location, class_2960 jobLocation, @Nullable class_2960 parentLocation, class_1799 icon, int price, int requiredLevel, PowerupType type) {
        super(location);
        this.jobLocation = jobLocation;
        this.parentLocation = parentLocation;
        this.icon = icon;
        this.price = price;
        this.requiredLevel = requiredLevel;
        this.type = type;
    }

    public class_5250 getName() {
        return JobsPlus.translatable("powerup." + this.location.method_12836() + "." + this.location.method_12832().replace('/', '.') + ".name");
    }

    public class_5250 getDescription() {
        return JobsPlus.translatable("powerup." + this.location.method_12836() + "." + this.location.method_12832().replace('/', '.') + ".description");
    }

    public class_2960 getJobLocation() {
        return this.jobLocation;
    }

    @Nullable
    public class_2960 getParentLocation() {
        return this.parentLocation;
    }

    public class_1799 getIcon() {
        return this.icon;
    }

    public int getPrice() {
        return this.price;
    }

    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    public PowerupType getPowerupType() {
        return this.type;
    }

    public IActionHolderType<?> getType() {
        return JobsPlusActionHolderType.POWERUP_INSTANCE;
    }

    @Nullable
    public static PowerupInstance of(class_2960 location) {
        return PowerupManager.getInstance().getAllPowerups().get(location);
    }

    public boolean passedHolderCondition(ActionData actionData) {
        Powerup powerup;
        JobsPlayer jobsPlayer;
        Job job;
        ArcPlayer arcPlayer = actionData.getPlayer();
        if (arcPlayer instanceof JobsPlayer && (job = (Job)(jobsPlayer = (JobsPlayer)arcPlayer).jobsplus$getJobs().stream().filter(job1 -> job1 != null && job1.getJobInstance() != null && job1.getJobInstance().getLocation().equals((Object)this.getJobLocation())).findFirst().orElse(null)) != null && (powerup = (Powerup)job.getPowerupManager().getAllPowerups().stream().filter(powerup1 -> powerup1.getPowerupInstance().getLocation().equals((Object)this.getLocation())).findFirst().orElse(null)) != null) {
            return powerup.getState() == PowerupState.ACTIVE;
        }
        return false;
    }

    public PowerupInstance getParent() {
        return this.parentLocation == null ? null : PowerupManager.getInstance().getAllPowerups().get(this.parentLocation);
    }

    public List<PowerupInstance> getChildren() {
        return PowerupManager.getInstance().getAllPowerups().values().stream().filter(powerupInstance -> powerupInstance.getParentLocation() != null && powerupInstance.getParentLocation().equals((Object)this.getLocation())).toList();
    }

    public static class Serializer
    implements JsonDeserializer<PowerupInstance>,
    IActionHolderSerializer<PowerupInstance> {
        public PowerupInstance deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            return this.fromJson(jsonObject, this.getResourceLocation(jsonObject, "location"));
        }

        public PowerupInstance fromJson(JsonObject jsonObject, class_2960 resourceLocation) {
            String parentLocation = class_3518.method_15253((JsonObject)jsonObject, (String)"parent", null);
            return new PowerupInstance(resourceLocation, this.getResourceLocation(jsonObject, "job"), parentLocation == null ? null : class_2960.method_60654((String)parentLocation), this.getItemStack((JsonElement)class_3518.method_15296((JsonObject)jsonObject, (String)"icon")), class_3518.method_15260((JsonObject)jsonObject, (String)"price"), class_3518.method_15260((JsonObject)jsonObject, (String)"required_level"), PowerupType.valueOf(class_3518.method_15253((JsonObject)jsonObject, (String)"type", (String)"basic").toUpperCase()));
        }

        public PowerupInstance fromNetwork(class_9129 friendlyByteBuf, class_2960 resourceLocation) {
            return new PowerupInstance(friendlyByteBuf.method_10810(), friendlyByteBuf.method_10810(), friendlyByteBuf.readBoolean() ? friendlyByteBuf.method_10810() : null, (class_1799)class_1799.field_48349.decode((Object)friendlyByteBuf), friendlyByteBuf.readInt(), friendlyByteBuf.readInt(), (PowerupType)friendlyByteBuf.method_10818(PowerupType.class));
        }

        public void toNetwork(class_9129 friendlyByteBuf, PowerupInstance powerupInstance) {
            friendlyByteBuf.method_10812(powerupInstance.getLocation());
            friendlyByteBuf.method_10812(powerupInstance.getJobLocation());
            friendlyByteBuf.method_52964(powerupInstance.getParentLocation() != null);
            if (powerupInstance.getParentLocation() != null) {
                friendlyByteBuf.method_10812(powerupInstance.getParentLocation());
            }
            class_1799.field_48349.encode((Object)friendlyByteBuf, (Object)powerupInstance.getIcon());
            friendlyByteBuf.method_53002(powerupInstance.getPrice());
            friendlyByteBuf.method_53002(powerupInstance.getRequiredLevel());
            friendlyByteBuf.method_10817((Enum)powerupInstance.getPowerupType());
            super.toNetwork(friendlyByteBuf, (IActionHolder)powerupInstance);
        }
    }
}

