/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.holder.holders.powerup;

import com.daqem.arc.api.action.holder.AbstractActionHolder;
import com.daqem.arc.api.action.holder.ActionHolderManager;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.JobsPlusExpectPlatform;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.integration.arc.holder.type.JobsPlusActionHolderType;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.jetbrains.annotations.NotNull;

public class PowerupManager
extends class_4080<List<IActionHolder>> {
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(PowerupInstance.class, (Object)new PowerupInstance.Serializer()).create();
    private static PowerupManager instance;

    public PowerupManager() {
        instance = this;
    }

    @NotNull
    protected List<IActionHolder> prepare(class_3300 resourceManager, class_3695 profilerFiller) {
        Map<class_2960, class_3298> resourceMap = resourceManager.method_14488("jobsplus/powerups", resourceLocation -> resourceLocation.method_12832().endsWith(".json")).entrySet().stream().collect(Collectors.toMap(entry -> class_2960.method_60655((String)((class_2960)entry.getKey()).method_12836(), (String)((class_2960)entry.getKey()).method_12832().substring(0, ((class_2960)entry.getKey()).method_12832().length() - ".json".length()).substring("jobsplus/powerups/".length())), Map.Entry::getValue));
        HashMap<class_2960, JsonObject> map = new HashMap<class_2960, JsonObject>();
        for (Map.Entry<class_2960, class_3298> entry2 : resourceMap.entrySet()) {
            class_2960 location = entry2.getKey();
            try {
                JsonObject jsonElement = class_3518.method_15255((Reader)entry2.getValue().method_43039());
                map.put(location, jsonElement);
            }
            catch (Exception runtimeException) {
                JobsPlus.LOGGER.error("Parsing error loading powerup {}", (Object)location, (Object)runtimeException);
            }
        }
        ArrayList<IActionHolder> powerups = new ArrayList<IActionHolder>();
        if (!JobsPlus.isDebugEnvironment()) {
            map.entrySet().removeIf(entry -> ((class_2960)entry.getKey()).method_12836().equals("debug"));
        }
        for (Map.Entry entry3 : map.entrySet()) {
            class_2960 location = (class_2960)entry3.getKey();
            JsonObject jsonObject = (JsonObject)entry3.getValue();
            jsonObject.addProperty("location", location.toString());
            try {
                PowerupInstance powerup = (PowerupInstance)((Object)GSON.fromJson((JsonElement)entry3.getValue(), PowerupInstance.class));
                powerups.add((IActionHolder)powerup);
            }
            catch (JsonParseException | IllegalArgumentException runtimeException) {
                JobsPlus.LOGGER.error("Parsing error loading powerup {}", (Object)location, (Object)runtimeException);
            }
        }
        return powerups;
    }

    protected void apply(List<IActionHolder> powerups, class_3300 resourceManager, class_3695 profilerFiller) {
        ActionHolderManager actionHolderManager = ActionHolderManager.getInstance();
        actionHolderManager.clearAllActionHoldersForType(JobsPlusActionHolderType.POWERUP_INSTANCE);
        actionHolderManager.registerActionHolders(powerups);
        JobsPlus.LOGGER.info("Loaded {} powerups", (Object)powerups.size());
    }

    public static PowerupManager getInstance() {
        return instance != null ? instance : JobsPlusExpectPlatform.getPowerupManager();
    }

    public ImmutableMap<class_2960, PowerupInstance> getRootPowerups() {
        return (ImmutableMap)this.getAllPowerups().entrySet().stream().filter(entry -> ((PowerupInstance)((Object)((Object)entry.getValue()))).getParentLocation() == null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<class_2960, PowerupInstance> getAllPowerups() {
        return (Map)ActionHolderManager.getInstance().getActionHolders().stream().filter(actionHolder -> actionHolder instanceof PowerupInstance).map(actionHolder -> (PowerupInstance)((Object)actionHolder)).collect(ImmutableMap.toImmutableMap(AbstractActionHolder::getLocation, powerupInstance -> powerupInstance));
    }
}

