/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.mixin;

import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.arc.api.player.ArcServerPlayer;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobManager;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.ServerPlayerData;
import com.daqem.jobsplus.player.job.Job;
import com.daqem.jobsplus.player.job.exp.ExpCollector;
import com.daqem.jobsplus.player.job.powerup.Powerup;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class MixinServerPlayer
extends class_1657
implements JobsServerPlayer {
    @Unique
    private List<Job> jobsplus$jobs = new ArrayList<Job>();
    @Unique
    private int jobsplus$coins = 0;

    public MixinServerPlayer(class_1937 level, GameProfile gameProfile) {
        super(level, gameProfile);
    }

    @Override
    public List<Job> jobsplus$getJobs() {
        return this.jobsplus$jobs;
    }

    @Override
    public List<JobInstance> jobsplus$getJobInstances() {
        return this.jobsplus$jobs.stream().map(Job::getJobInstance).toList();
    }

    @Override
    public List<Job> jobsplus$getInactiveJobs() {
        return JobManager.getInstance().getJobs().values().stream().filter(jobInstance -> !this.jobsplus$getJobInstances().contains(jobInstance)).map(jobInstance -> new Job(this, (JobInstance)((Object)jobInstance))).toList();
    }

    @Override
    @Nullable
    public Job jobsplus$addNewJob(@NotNull JobInstance jobInstance) {
        if (jobInstance.getLocation() == null) {
            return null;
        }
        Job job = this.jobsplus$getJob(jobInstance);
        if (job == null) {
            job = new Job(this, jobInstance, 1, 0);
            this.jobsplus$jobs.add(job);
            this.jobsplus$updateJob(job);
            return job;
        }
        return null;
    }

    @Override
    public void jobsplus$removeJob(JobInstance jobInstance) {
        Job job = this.jobsplus$getJob(jobInstance);
        if (job != null) {
            this.jobsplus$jobs.remove(job);
            this.jobsplus$removeActionHolders(job);
        }
    }

    @Override
    public void jobsplus$removeActionHolders(Job job) {
        class_3222 class_32222 = this.jobsplus$getServerPlayer();
        if (class_32222 instanceof ArcPlayer) {
            ArcPlayer arcPlayer = (ArcPlayer)class_32222;
            arcPlayer.arc$removeActionHolder((IActionHolder)job.getJobInstance());
            job.getPowerupManager().getAllPowerups().forEach(powerup -> arcPlayer.arc$removeActionHolder((IActionHolder)powerup.getPowerupInstance()));
        }
    }

    @Override
    @Nullable
    public Job jobsplus$getJob(@Nullable JobInstance jobLocation) {
        if (jobLocation == null) {
            return null;
        }
        return this.jobsplus$jobs.stream().filter(job -> job.getJobInstance().getLocation().equals((Object)jobLocation.getLocation())).findFirst().orElse(null);
    }

    @Override
    public Job jobsplus$getJob(class_2960 jobLocation) {
        return this.jobsplus$jobs.stream().filter(job -> job.getJobInstance().getLocation().equals((Object)jobLocation)).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public Powerup jobsplus$getPowerup(PowerupInstance powerupInstance) {
        return this.jobsplus$getJobs().stream().map(Job::getPowerupManager).flatMap(powerupManager -> powerupManager.getAllPowerups().stream()).filter(powerup -> powerup.getPowerupInstance().getLocation().equals((Object)powerupInstance.getLocation())).findFirst().orElse(null);
    }

    @Override
    public int jobsplus$getCoins() {
        return this.jobsplus$coins;
    }

    @Override
    public void jobsplus$addCoins(int coins) {
        this.jobsplus$setCoins(class_3532.method_15340((int)(this.jobsplus$coins + coins), (int)0, (int)Integer.MAX_VALUE));
    }

    @Override
    public void jobsplus$setCoins(int coins) {
        this.jobsplus$coins = coins;
    }

    @Override
    public List<IActionHolder> jobsplus$getActionHolders() {
        ArrayList<JobInstance> actionHolders = new ArrayList<JobInstance>(this.jobsplus$getJobInstances());
        actionHolders.addAll(this.jobsplus$getJobs().stream().map(Job::getPowerupManager).flatMap(powerupManager -> powerupManager.getAllPowerups().stream().filter(powerup -> powerup.getState() == PowerupState.ACTIVE)).map(Powerup::getPowerupInstance).toList());
        return actionHolders;
    }

    @Override
    public class_3222 jobsplus$getServerPlayer() {
        return (class_3222)this;
    }

    @Override
    public String jobsplus$getName() {
        return super.method_5477().getString();
    }

    @Override
    public void jobsplus$updateJob(Job job) {
        this.jobsplus$updateActionHolders(job);
    }

    @Override
    public void jobsplus$updateActionHolders(Job job) {
        class_3222 class_32222 = this.jobsplus$getServerPlayer();
        if (class_32222 instanceof ArcPlayer) {
            ArcPlayer arcPlayer = (ArcPlayer)class_32222;
            arcPlayer.arc$removeActionHolder((IActionHolder)job.getJobInstance());
            job.getPowerupManager().getAllPowerups().forEach(powerup -> arcPlayer.arc$removeActionHolder((IActionHolder)powerup.getPowerupInstance()));
            arcPlayer.arc$addActionHolder((IActionHolder)job.getJobInstance());
            job.getPowerupManager().getAllPowerups().stream().filter(powerup -> powerup.getState() == PowerupState.ACTIVE).forEach(powerup -> arcPlayer.arc$addActionHolder((IActionHolder)powerup.getPowerupInstance()));
        }
    }

    @Override
    public class_1657 jobsplus$getPlayer() {
        return this.jobsplus$getServerPlayer();
    }

    @Inject(at={@At(value="TAIL")}, method={"restoreFrom(Lnet/minecraft/server/level/ServerPlayer;Z)V"})
    public void restoreFrom(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        if (oldPlayer instanceof JobsServerPlayer) {
            JobsServerPlayer oldJobsServerPlayer = (JobsServerPlayer)oldPlayer;
            this.jobsplus$jobs = oldJobsServerPlayer.jobsplus$getJobs();
            this.jobsplus$coins = oldJobsServerPlayer.jobsplus$getCoins();
            this.jobsplus$jobs.forEach(job -> job.setPlayer(this));
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    public void addAdditionalSaveData(class_11372 valueOutput, CallbackInfo ci) {
        valueOutput.method_71468("JobsPlus", ServerPlayerData.CODEC, (Object)new ServerPlayerData(this.jobsplus$jobs, this.jobsplus$coins));
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    public void readAdditionalSaveData(class_11368 valueInput, CallbackInfo ci) {
        valueInput.method_71426("JobsPlus", ServerPlayerData.CODEC).ifPresent(serverPlayerData -> {
            this.jobsplus$jobs = serverPlayerData.jobs().stream().filter(job -> job.getJobInstance() != null).peek(job -> job.setPlayer(this)).collect(Collectors.toCollection(ArrayList::new));
            this.jobsplus$coins = serverPlayerData.coins();
            class_3222 patt0$temp = this.jobsplus$getServerPlayer();
            if (patt0$temp instanceof ArcServerPlayer) {
                ArcServerPlayer arcServerPlayer = (ArcServerPlayer)patt0$temp;
                List<IActionHolder> iActionHolders = this.jobsplus$getActionHolders();
                arcServerPlayer.arc$addActionHolders(new ArrayList<IActionHolder>(iActionHolders));
            }
        });
    }

    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    public void tickTail(CallbackInfo ci) {
        this.jobsplus$jobs.forEach(job -> {
            ExpCollector expCollector = job.getExpCollector();
            int exp = expCollector.getExp();
            if (exp > 0) {
                JobInstance jobInstance = job.getJobInstance();
                class_5250 component = JobsPlus.translatable("job.exp.gain", exp, jobInstance.getName().getString()).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)jobInstance.getColorDecimal()))).method_27692(class_124.field_1067);
                this.jobsplus$getServerPlayer().method_43502((class_2561)component, true);
            }
            expCollector.clear();
        });
    }
}

