/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.networking.c2s;

import com.daqem.jobsplus.networking.JobsPlusNetworking;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.job.Job;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class ServerboundTogglePowerUpPacket
implements CustomPacketPayload {
    private final ResourceLocation jobLocation;
    private final ResourceLocation powerupLocation;
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundTogglePowerUpPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ServerboundTogglePowerUpPacket>(){

        @NotNull
        public ServerboundTogglePowerUpPacket decode(RegistryFriendlyByteBuf buf) {
            return new ServerboundTogglePowerUpPacket(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, ServerboundTogglePowerUpPacket packet) {
            buf.writeResourceLocation(packet.jobLocation);
            buf.writeResourceLocation(packet.powerupLocation);
        }
    };

    public ServerboundTogglePowerUpPacket(ResourceLocation jobLocation, ResourceLocation powerupLocation) {
        this.jobLocation = jobLocation;
        this.powerupLocation = powerupLocation;
    }

    public ServerboundTogglePowerUpPacket(RegistryFriendlyByteBuf friendlyByteBuf) {
        this.jobLocation = friendlyByteBuf.readResourceLocation();
        this.powerupLocation = friendlyByteBuf.readResourceLocation();
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return JobsPlusNetworking.SERVERBOUND_TOGGLE_POWERUP;
    }

    public static void handleServerSide(ServerboundTogglePowerUpPacket packet, NetworkManager.PacketContext context) {
        JobsServerPlayer serverPlayer;
        Job job;
        Player player = context.getPlayer();
        if (player instanceof JobsServerPlayer && (job = (serverPlayer = (JobsServerPlayer)player).jobsplus$getJob(packet.jobLocation)) != null) {
            job.getPowerupManager().getPowerup(packet.powerupLocation).ifPresent(powerup -> {
                powerup.toggle();
                serverPlayer.jobsplus$updateJob(job);
            });
        }
    }
}

