/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.networking.s2c;

import com.daqem.jobsplus.networking.JobsPlusNetworking;
import com.daqem.jobsplus.player.job.Job;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ClientboundOpenPowerupsScreenPacket
implements CustomPacketPayload {
    private final List<Job> jobs;
    private final int coins;
    private final ResourceLocation jobLocation;
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundOpenPowerupsScreenPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ClientboundOpenPowerupsScreenPacket>(){

        @NotNull
        public ClientboundOpenPowerupsScreenPacket decode(RegistryFriendlyByteBuf buf) {
            return new ClientboundOpenPowerupsScreenPacket(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, ClientboundOpenPowerupsScreenPacket packet) {
            buf.writeCollection(packet.jobs, Job.Serializer::toNetwork);
            buf.writeInt(packet.coins);
            buf.writeResourceLocation(packet.jobLocation);
        }
    };

    public ClientboundOpenPowerupsScreenPacket(List<Job> jobs, int coins, ResourceLocation jobLocation) {
        this.jobs = jobs;
        this.coins = coins;
        this.jobLocation = jobLocation;
    }

    public ClientboundOpenPowerupsScreenPacket(RegistryFriendlyByteBuf friendlyByteBuf) {
        this.jobs = friendlyByteBuf.readList(friendlyByteBuf1 -> Job.Serializer.fromNetwork(friendlyByteBuf1, null));
        this.coins = friendlyByteBuf.readInt();
        this.jobLocation = friendlyByteBuf.readResourceLocation();
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return JobsPlusNetworking.CLIENTBOUND_OPEN_POWERUPS_SCREEN;
    }

    public List<Job> getJobs() {
        return this.jobs;
    }

    public int getCoins() {
        return this.coins;
    }

    public ResourceLocation getJobLocation() {
        return this.jobLocation;
    }
}

