/*
 * Decompiled with CFR 0.152.
 */
package net.notcoded.wayfix.mixin;

import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.notcoded.wayfix.WayFix;
import net.notcoded.wayfix.platforms.forge.WayFixForge;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientMixin {
    @Redirect(method={"resizeDisplay()V"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/Window;calculateScale(IZ)I"))
    private int fixHiDPIScaling(Window instance, int guiScale, boolean forceUnicodeFont) {
        if (guiScale != 0 && WayFix.config.autoScaleGUI) {
            guiScale = Math.round((float)guiScale * this.wayfix$getScaleFactor(instance));
        }
        return instance.calculateScale(guiScale, forceUnicodeFont);
    }

    @Unique
    private float wayfix$getScaleFactor(Window instance) {
        float[] pos = new float[1];
        GLFW.glfwGetWindowContentScale((long)instance.getWindow(), (float[])pos, (float[])pos);
        return pos[0];
    }

    @Inject(method={"<clinit>()V"}, at={@At(value="HEAD")})
    private static void initMod(CallbackInfo ci) {
        WayFixForge.ForgePlatform platform = new WayFixForge.ForgePlatform();
        WayFix.init(platform);
    }
}

