/*
 * Decompiled with CFR 0.152.
 */
package net.notcoded.wayfix.mixin;

import com.mojang.blaze3d.platform.IconSet;
import com.mojang.blaze3d.platform.Window;
import java.io.IOException;
import net.minecraft.server.packs.PackResources;
import net.notcoded.wayfix.WayFix;
import net.notcoded.wayfix.util.DesktopFileInjector;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Window.class})
public abstract class WindowMixin {
    @Redirect(method={"<init>(Lcom/mojang/blaze3d/platform/WindowEventHandler;Lcom/mojang/blaze3d/platform/ScreenManager;Lcom/mojang/blaze3d/platform/DisplayData;Ljava/lang/String;Ljava/lang/String;)V"}, at=@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwDefaultWindowHints()V", remap=false))
    private void onWindowHints() {
        GLFW.glfwDefaultWindowHints();
        if (WayFix.isWayland()) {
            GLFW.glfwWindowHint((int)131084, (int)0);
            if (!WayFix.config.injectIcon) {
                return;
            }
            DesktopFileInjector.inject();
            GLFW.glfwWindowHintString((int)155649, (CharSequence)"com.mojang.minecraft.java-edition");
        }
    }

    @Inject(method={"setIcon(Lnet/minecraft/server/packs/PackResources;Lcom/mojang/blaze3d/platform/IconSet;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectIcon(PackResources resourcePack, IconSet icons, CallbackInfo ci) {
        if (WayFix.isWayland()) {
            try {
                DesktopFileInjector.setIcon(icons.getStandardIcons(resourcePack));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ci.cancel();
        }
    }
}

