/*
 * Decompiled with CFR 0.152.
 */
package net.notcoded.wayfix.platforms.forge;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLLoader;
import net.notcoded.wayfix.config.ModClothConfig;
import net.notcoded.wayfix.platforms.ModPlatform;

@Mod(value="wayfix")
@OnlyIn(value=Dist.CLIENT)
public class WayFixForge {
    public WayFixForge() {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> WayFixForge::setupConfigScreen);
    }

    private static void setupConfigScreen() {
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> ModClothConfig.buildScreen(parent)));
    }

    public static void checkEarlyWindow() {
        try {
            if (!FMLConfig.getBoolConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_CONTROL)) {
                return;
            }
            FMLConfig.updateConfig((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_CONTROL, (Object)false);
            Minecraft.getInstance().getToasts().addToast((Toast)new SystemToast(SystemToast.SystemToastId.WORLD_BACKUP, (Component)Component.translatable((String)"wayfix.toast.restart-game.title"), (Component)Component.translatable((String)"wayfix.toast.restart-game.description")));
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
    }

    public static class ForgePlatform
    implements ModPlatform {
        @Override
        public String getModLoader() {
            return "Forge";
        }

        @Override
        public boolean isModLoaded(String modId) {
            return ModList.get().isLoaded(modId);
        }

        @Override
        public boolean isDevelopmentEnvironment() {
            return !FMLLoader.isProduction();
        }
    }
}

