/*
 * Decompiled with CFR 0.152.
 */
package net.notcoded.wayfix.util;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.notcoded.wayfix.WayFix;

public class WindowHelper {
    public static boolean enabled = true;
    public static boolean canUseWindowHelper = false;
    private static String windowID = "";

    public static void checkIfCanUseWindowHelper() {
        block3: {
            if (!WindowHelper.isKDE()) {
                return;
            }
            try {
                new ProcessBuilder("kdotool").start();
                canUseWindowHelper = true;
            }
            catch (Exception ignored) {
                if (!WayFix.config.kdotoolWarning) break block3;
                WayFix.LOGGER.warn("WayFix recommends installing 'kdotool' to properly fix the minecraft full-screening functionality.");
            }
        }
    }

    public static boolean canUseWindowHelper() {
        return canUseWindowHelper && !WayFix.config.disableWindowHelper;
    }

    public static boolean isKDE() {
        String currentDesktop = System.getenv("XDG_CURRENT_DESKTOP");
        return currentDesktop != null && currentDesktop.contains("KDE");
    }

    public static int[] getWindowPos() {
        if (windowID.trim().isEmpty() && !WindowHelper.setWindowID()) {
            return null;
        }
        String[] command = new String[]{"kdotool", "getwindowgeometry", windowID};
        ProcessBuilder builder = new ProcessBuilder(command);
        try {
            Process process = builder.start();
            String result = new String(process.getInputStream().readAllBytes());
            Pattern pattern = Pattern.compile("Position:\\s*(-?[\\d.]+),\\s*(-?[\\d.]+)");
            Matcher matcher = pattern.matcher(result);
            if (matcher.find()) {
                return new int[]{(int)Double.parseDouble(matcher.group(1)), (int)Double.parseDouble(matcher.group(2))};
            }
            return null;
        }
        catch (IOException ignored) {
            return null;
        }
    }

    public static boolean setWindowID() {
        if (!Minecraft.getInstance().isWindowActive()) {
            return false;
        }
        String[] command = new String[]{"kdotool", "getactivewindow", "getwindowgeometry"};
        ProcessBuilder builder = new ProcessBuilder(command);
        try {
            Process process = builder.start();
            String result = new String(process.getInputStream().readAllBytes());
            Pattern pattern = Pattern.compile("Window \\{(\\w+-\\w+-\\w+-\\w+-\\w+)}");
            Matcher matcher = pattern.matcher(result);
            if (matcher.find()) {
                windowID = "{" + matcher.group(1) + "}";
                return true;
            }
            return false;
        }
        catch (IOException ignored) {
            return false;
        }
    }
}

