/*
 * Decompiled with CFR 0.152.
 */
package net.notcoded.wayfix.config;

import com.google.common.collect.Lists;
import java.util.HashMap;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.DropdownMenuBuilder;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.notcoded.wayfix.WayFix;
import net.notcoded.wayfix.config.ModConfig;
import net.notcoded.wayfix.util.WindowHelper;

@Config(name="wayfix")
public class ModClothConfig
extends ModConfig
implements ConfigData {
    public static HashMap<String, Long> monitors = new HashMap();

    public static Screen buildScreen(Screen parent) {
        ModConfig config = WayFix.config;
        ConfigBuilder builder = ConfigBuilder.create();
        builder.setParentScreen(parent);
        builder.setTitle(ModClothConfig.getText("title"));
        builder.setDoesConfirmSave(false);
        builder.setSavingRunnable(() -> AutoConfig.getConfigHolder(ModClothConfig.class).save());
        ConfigCategory category = builder.getOrCreateCategory(ModClothConfig.getText("title"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ModClothConfig.getText("autoScaleGUI"), config.autoScaleGUI).setDefaultValue(true).setTooltip(new ITextComponent[]{ModClothConfig.getText("autoScaleGUI.tooltip"), ModClothConfig.getText("autoScaleGUI.tooltip2")}).setSaveConsumer(value -> {
            config.autoScaleGUI = value;
        }).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ModClothConfig.getText("injectIcon"), config.injectIcon).setDefaultValue(true).setTooltip(new ITextComponent[]{ModClothConfig.getText("injectIcon.tooltip")}).requireRestart().setSaveConsumer(value -> {
            config.injectIcon = value;
        }).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ModClothConfig.getText("keyModifiersFix"), config.keyModifiersFix).setDefaultValue(true).setTooltip(new ITextComponent[]{ModClothConfig.getText("keyModifiersFix.tooltip")}).setSaveConsumer(value -> {
            config.keyModifiersFix = value;
        }).build());
        if (!WindowHelper.canUseWindowHelper) {
            if (WindowHelper.enabled) {
                category.addEntry((AbstractConfigListEntry)entryBuilder.startDropdownMenu(ModClothConfig.getText("monitorName"), DropdownMenuBuilder.TopCellElementBuilder.of((Object)config.monitorName, s -> s)).setDefaultValue((Object)"").setSuggestionMode(false).setTooltip(new ITextComponent[]{ModClothConfig.getText("monitorName.tooltip"), ModClothConfig.getText("monitorName.tooltip2"), ModClothConfig.getText("empty"), ModClothConfig.getText("monitorName.tooltip3")}).setSaveConsumer(value -> {
                    config.monitorName = value;
                }).setSelections((Iterable)Lists.newArrayList(monitors.keySet())).build());
            }
            if (WindowHelper.isKDE()) {
                category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ModClothConfig.getText("kdotoolWarning"), config.kdotoolWarning).setDefaultValue(true).setTooltip(new ITextComponent[]{ModClothConfig.getText("kdotoolWarning.tooltip")}).setSaveConsumer(value -> {
                    config.kdotoolWarning = value;
                }).build());
            }
        } else {
            category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ModClothConfig.getText("disableWindowHelper"), config.disableWindowHelper).setDefaultValue(false).setTooltip(new ITextComponent[]{ModClothConfig.getText("disableWindowHelper.tooltip")}).setSaveConsumer(value -> {
                config.disableWindowHelper = value;
            }).build());
        }
        return builder.build();
    }

    private static ITextComponent getText(String key) {
        return new TranslationTextComponent("wayfix.option." + key);
    }
}

