/*
 * Decompiled with CFR 0.152.
 */
package net.notcoded.wayfix.mixin;

import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.notcoded.wayfix.WayFix;
import net.notcoded.wayfix.platforms.forge.WayFixForge;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientMixin {
    @Redirect(method={"onResolutionChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/util/Window;calculateScaleFactor(IZ)I"))
    private int fixHiDPIScaling(MainWindow instance, int guiScale, boolean forceUnicodeFont) {
        if (guiScale != 0 && WayFix.config.autoScaleGUI) {
            guiScale = Math.round((float)guiScale * this.wayfix$getScaleFactor(instance));
        }
        return instance.func_216521_a(guiScale, forceUnicodeFont);
    }

    @Unique
    private float wayfix$getScaleFactor(MainWindow instance) {
        float[] pos = new float[1];
        GLFW.glfwGetWindowContentScale((long)instance.func_198092_i(), (float[])pos, (float[])pos);
        return pos[0];
    }

    @Inject(method={"<clinit>"}, at={@At(value="HEAD")})
    private static void initMod(CallbackInfo ci) {
        WayFixForge.ForgePlatform platform = new WayFixForge.ForgePlatform();
        WayFix.init(platform);
    }
}

