/*
 * Decompiled with CFR 0.152.
 */
package net.notcoded.wayfix.mixin;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Monitor;
import net.minecraft.client.renderer.MonitorHandler;
import net.notcoded.wayfix.WayFix;
import net.notcoded.wayfix.config.ModClothConfig;
import net.notcoded.wayfix.util.WindowHelper;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MainWindow.class})
public abstract class MonitorFixWindowMixin {
    @Shadow
    @Final
    private long field_198119_f;

    @Shadow
    protected abstract void func_198080_a(long var1, int var3, int var4);

    @Redirect(method={"updateWindowRegion"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/util/MonitorTracker;getMonitor(Lnet/minecraft/client/util/Window;)Lnet/minecraft/client/util/Monitor;"))
    private Monitor fixWrongMonitor(MonitorHandler instance, MainWindow window) {
        return WindowHelper.canUseWindowHelper() ? instance.func_216515_a(window) : this.wayfix$getMonitor(instance);
    }

    @Unique
    private Monitor wayfix$getMonitor(MonitorHandler instance) {
        String monitorName = WayFix.config.monitorName;
        long monitorID = GLFW.glfwGetPrimaryMonitor();
        if (!monitorName.trim().isEmpty() && (monitorID = ModClothConfig.monitors.getOrDefault(monitorName, 0L).longValue()) == 0L && monitorName.toLowerCase().startsWith("dp-") && Character.isDigit(monitorName.charAt(monitorName.length() - 1))) {
            ArrayList<Long> values = new ArrayList<Long>(ModClothConfig.monitors.values());
            values.sort(Collections.reverseOrder());
            try {
                monitorID = values.get(Integer.parseInt(monitorName.substring(monitorName.length() - 1)) - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (monitorID <= 0L || instance.func_216512_a(monitorID) == null) {
            WayFix.LOGGER.warn("Error occurred while trying to set monitor.");
            WayFix.LOGGER.warn("Using primary monitor instead.");
            monitorID = GLFW.glfwGetPrimaryMonitor();
        }
        return instance.func_216512_a(monitorID);
    }

    @Inject(method={"updateWindowRegion"}, at={@At(value="HEAD")})
    private void fixWrongMonitor(CallbackInfo ci) {
        if (!WindowHelper.canUseWindowHelper()) {
            return;
        }
        int[] pos = WindowHelper.getWindowPos();
        if (pos == null) {
            return;
        }
        this.func_198080_a(this.field_198119_f, pos[0], pos[1]);
    }
}

