/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.experience.enchanting;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import insane96mcp.insanelib.data.IdTagMatcher;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.util.GsonHelper;

@JsonAdapter(value=Serializer.class)
public class EnchantmentData {
    public IdTagMatcher enchantment;
    public int costPerLevel;
    public int[] cost;
    public static final Type LIST_TYPE = new TypeToken<ArrayList<EnchantmentData>>(){}.getType();

    public EnchantmentData(IdTagMatcher enchantment) {
        this.enchantment = enchantment;
    }

    public EnchantmentData(String enchantment) {
        this(IdTagMatcher.newId((String)enchantment));
    }

    public EnchantmentData costPerLevel(int costPerLevel) {
        this.costPerLevel = costPerLevel;
        return this;
    }

    public EnchantmentData cost(int ... cost) {
        this.cost = cost;
        return this;
    }

    public int getCost(int lvl) {
        if (this.costPerLevel != 0) {
            return this.costPerLevel * lvl;
        }
        if (this.cost.length >= lvl) {
            return this.cost[lvl - 1];
        }
        return 0;
    }

    public static class Serializer
    implements JsonDeserializer<EnchantmentData>,
    JsonSerializer<EnchantmentData> {
        public EnchantmentData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            IdTagMatcher idTagMatcher = (IdTagMatcher)context.deserialize(jObject.get("id"), IdTagMatcher.class);
            EnchantmentData enchantmentData = new EnchantmentData(idTagMatcher);
            if (!jObject.has("cost_per_level") && !jObject.has("costs")) {
                throw new JsonParseException("Missing cost_per_level or costs field");
            }
            if (jObject.has("cost_per_level")) {
                enchantmentData.costPerLevel(GsonHelper.m_13927_((JsonObject)jObject, (String)"cost_per_level"));
            }
            if (jObject.has("costs")) {
                if (jObject.get("costs").isJsonPrimitive()) {
                    enchantmentData.cost(GsonHelper.m_13927_((JsonObject)jObject, (String)"costs"));
                } else {
                    JsonArray jsonArray = jObject.get("costs").getAsJsonArray();
                    int[] cost = new int[jsonArray.size()];
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        cost[i] = jsonArray.get(i).getAsInt();
                    }
                    enchantmentData.cost(cost);
                }
            }
            return enchantmentData;
        }

        public JsonElement serialize(EnchantmentData src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("id", context.serialize((Object)src.enchantment));
            if (src.cost != null) {
                if (src.cost.length > 1) {
                    jObject.add("costs", context.serialize((Object)src.cost));
                } else if (src.cost.length == 1) {
                    jObject.addProperty("costs", (Number)src.cost[0]);
                }
            }
            if (src.costPerLevel != 0) {
                jObject.addProperty("cost_per_level", (Number)src.costPerLevel);
            }
            return jObject;
        }
    }
}

