/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.experience.enchanting;

import insane96mcp.iguanatweaksexpanded.module.experience.enchanting.EnchantingFeature;
import insane96mcp.iguanatweaksexpanded.module.experience.enchanting.ISEEnchantingTableBlockEntity;
import insane96mcp.iguanatweaksexpanded.network.message.SyncISEEnchantingTableLearnedEnchantments;
import insane96mcp.iguanatweaksexpanded.network.message.SyncISEEnchantingTableStatus;
import insane96mcp.iguanatweaksreborn.module.experience.DroppedExperience;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.EnchantmentsFeature;
import insane96mcp.insanelib.util.ModNBTData;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ISEEnchantingTableMenu
extends AbstractContainerMenu {
    public static final int ITEM_SLOT = 0;
    public static final int CATALYST_SLOT = 1;
    public static final int SLOT_COUNT = 2;
    private static final int INV_SLOT_START = 2;
    private static final int INV_SLOT_END = 29;
    private static final int USE_ROW_SLOT_START = 29;
    private static final int USE_ROW_SLOT_END = 38;
    private final Container container;
    private final ContainerLevelAccess access;
    protected final Level level;
    public DataSlot maxCost = DataSlot.m_39401_();

    public ISEEnchantingTableMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, (Container)new SimpleContainer(2), ContainerLevelAccess.f_39287_);
    }

    protected ISEEnchantingTableMenu(int pContainerId, Inventory pPlayerInventory, Container pContainer, ContainerLevelAccess access) {
        super((MenuType)EnchantingFeature.ENCHANTING_TABLE_MENU_TYPE.get(), pContainerId);
        ISEEnchantingTableMenu.m_38869_((Container)pContainer, (int)2);
        this.container = pContainer;
        this.access = access;
        this.level = pPlayerInventory.f_35978_.m_9236_();
        this.m_38897_(new Slot(pContainer, 0, 20, 19){

            public int m_6641_() {
                return 1;
            }

            public void m_6654_() {
                super.m_6654_();
                ISEEnchantingTableMenu.this.m_6199_(this.f_40218_);
            }

            public boolean m_5857_(ItemStack stack) {
                return EnchantingFeature.canBeEnchanted(stack);
            }
        });
        this.m_38897_(new Slot(pContainer, 1, 38, 19){

            public boolean m_5857_(ItemStack p_39517_) {
                return p_39517_.m_204117_(Tags.Items.ENCHANTING_FUELS);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)pPlayerInventory, j + i * 9 + 9, 37 + j * 18, 104 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)pPlayerInventory, k, 37 + k * 18, 162));
        }
        this.m_38895_(this.maxCost);
        this.access.m_39292_((level, blockPos) -> this.updateMaxCost(this.container.m_8020_(0), (Level)level, (BlockPos)blockPos));
    }

    public void m_6199_(Container pContainer) {
        this.access.m_39292_((level, blockPos) -> {
            this.updateMaxCost(this.container.m_8020_(0), (Level)level, (BlockPos)blockPos);
            SyncISEEnchantingTableLearnedEnchantments.sync((ServerLevel)level, (ISEEnchantingTableBlockEntity)level.m_7702_(blockPos));
        });
    }

    public int calculateMaxCost(ItemStack stack, Level level, BlockPos blockPos) {
        float enchantingPower = 0.0f;
        for (BlockPos blockpos : EnchantmentTableBlock.f_207902_) {
            if (!EnchantmentTableBlock.m_207909_((Level)level, (BlockPos)blockPos, (BlockPos)blockpos)) continue;
            enchantingPower += level.m_8055_(blockPos.m_121955_((Vec3i)blockpos)).getEnchantPowerBonus((LevelReader)level, blockPos.m_121955_((Vec3i)blockpos));
        }
        if (enchantingPower > (float)EnchantingFeature.enchantingTableMaxEnchantingPower.intValue()) {
            enchantingPower = EnchantingFeature.enchantingTableMaxEnchantingPower.intValue();
        }
        int baseTableEnchantability = EnchantingFeature.enchantingTableBaseEnchantability;
        double enchantabilityModifier = EnchantingFeature.enchantingTableEnchantabilityMultiplier;
        if (stack.m_41783_() != null && ((Boolean)ModNBTData.get((ItemStack)stack, (ResourceLocation)EnchantingFeature.PURIFIED_ITEM, Boolean.class)).booleanValue()) {
            enchantabilityModifier = EnchantingFeature.enchantingTablePurifiedEnchantabilityMultiplier;
            baseTableEnchantability += EnchantingFeature.enchantingTablePurifiedEnchantabilityFlat.intValue();
        }
        double ratio = enchantingPower / EnchantingFeature.enchantingTableMaxEnchantingPower.floatValue();
        double maxCost = (double)EnchantmentsFeature.getEnchantmentValue((ItemStack)stack) * enchantabilityModifier * ratio + (double)baseTableEnchantability * ratio + (double)EnchantingFeature.getCurseCost(stack);
        return (int)Math.max(1L, Math.round(maxCost));
    }

    private void updateMaxCost(ItemStack stack, Level level, BlockPos blockPos) {
        if (stack.m_41619_() || !EnchantingFeature.canBeEnchanted(stack)) {
            this.maxCost.m_6422_(0);
        } else {
            this.maxCost.m_6422_(this.calculateMaxCost(stack, level, blockPos));
        }
        this.m_38946_();
    }

    public void updateEnchantmentsChosen(List<EnchantmentInstance> enchantments, @Nullable Player dontSync) {
        this.access.m_39292_((level, blockPos) -> {
            CompoundTag tag = this.container.m_8020_(0).m_41784_();
            if (enchantments.isEmpty()) {
                if (tag.m_128425_("PendingEnchantments", 9)) {
                    tag.m_128473_("PendingEnchantments");
                }
                return;
            }
            if (!tag.m_128425_("PendingEnchantments", 9)) {
                tag.m_128365_("PendingEnchantments", (Tag)new ListTag());
            }
            ListTag pendingEnchantments = tag.m_128437_("PendingEnchantments", 10);
            pendingEnchantments.clear();
            for (EnchantmentInstance enchantmentInstance : enchantments) {
                pendingEnchantments.add((Object)EnchantmentHelper.m_182443_((ResourceLocation)ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantmentInstance.f_44947_), (int)((byte)enchantmentInstance.f_44948_)));
            }
            SyncISEEnchantingTableStatus.sync((ServerLevel)level, blockPos, (ISEEnchantingTableBlockEntity)level.m_7702_(blockPos), dontSync);
        });
    }

    public boolean m_6366_(Player player, int pId) {
        if (pId != 0) {
            Util.m_143785_((String)(String.valueOf(player.m_7755_()) + " pressed invalid button id: " + pId));
            return false;
        }
        this.access.m_39292_((level, blockPos) -> {
            ItemStack stack = this.container.m_8020_(0);
            List<EnchantmentInstance> enchantmentInstances = EnchantingFeature.getPendingEnchantments(stack);
            if (enchantmentInstances.isEmpty()) {
                return;
            }
            ISEEnchantingTableBlockEntity table = (ISEEnchantingTableBlockEntity)level.m_7702_(blockPos);
            if (table == null) {
                return;
            }
            int cost = 0;
            int lapisCost = 0;
            for (EnchantmentInstance instance : enchantmentInstances) {
                if (!table.knownEnchantments.containsKey(instance.f_44947_)) {
                    player.m_213846_((Component)Component.m_237110_((String)"iguanatweaksexpanded.enchanting_table.doesnt_know", (Object[])new Object[]{Component.m_237115_((String)instance.f_44947_.m_44704_())}));
                    return;
                }
                cost += EnchantingFeature.getCost(instance.f_44947_, instance.f_44948_);
                lapisCost += instance.f_44948_;
            }
            if (cost > this.getMaxCost(enchantmentInstances) && !player.m_150110_().f_35937_ && !DroppedExperience.disableExperience.booleanValue()) {
                player.m_213846_((Component)Component.m_237110_((String)"iguanatweaksexpanded.enchanting_table.cost_higher_than_max", (Object[])new Object[]{cost, this.getMaxCost(enchantmentInstances)}));
                return;
            }
            enchantmentInstances.forEach(enchantmentInstance -> stack.m_41663_(enchantmentInstance.f_44947_, enchantmentInstance.f_44948_));
            if (!player.m_150110_().f_35937_) {
                for (EnchantmentInstance instance : enchantmentInstances) {
                    if (!EnchantingFeature.isConsumedOnEnchant(instance.f_44947_)) continue;
                    table.forgetEnchantment(instance.f_44947_, instance.f_44948_);
                    EnchantingFeature.removePendingEnchantment(stack, instance.f_44947_);
                }
                ItemStack lapis = this.container.m_8020_(1);
                lapis.m_41774_(lapisCost);
                if (!DroppedExperience.disableExperience.booleanValue()) {
                    player.m_7408_(stack, cost);
                }
            }
            level.m_5594_(null, blockPos, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.updateMaxCost(stack, (Level)level, (BlockPos)blockPos);
            SyncISEEnchantingTableStatus.sync((ServerLevel)level, blockPos, table);
        });
        this.m_38946_();
        return true;
    }

    private int getMaxCost(List<EnchantmentInstance> enchantmentInstances) {
        int maxCost = this.maxCost.m_6501_();
        for (EnchantmentInstance enchantmentInstance : enchantmentInstances) {
            if (!enchantmentInstance.f_44947_.m_6589_()) continue;
            maxCost += EnchantingFeature.getCost(enchantmentInstance.f_44947_, enchantmentInstance.f_44948_, true);
        }
        return maxCost;
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slotClicked = (Slot)this.f_38839_.get(pIndex);
        if (!slotClicked.m_6657_()) {
            return itemstack;
        }
        ItemStack itemClicked = slotClicked.m_7993_();
        itemstack = itemClicked.m_41777_();
        if (pIndex == 0) {
            if (!this.m_38903_(itemClicked, 2, 38, true)) {
                return ItemStack.f_41583_;
            }
        } else if (pIndex == 1) {
            if (!this.m_38903_(itemClicked, 2, 38, true)) {
                return ItemStack.f_41583_;
            }
        } else if (((Slot)this.f_38839_.get(1)).m_5857_(itemClicked)) {
            if (!this.m_38903_(itemClicked, 1, 2, true)) {
                return ItemStack.f_41583_;
            }
        } else if (!((Slot)this.f_38839_.get(0)).m_6657_() && ((Slot)this.f_38839_.get(0)).m_5857_(itemClicked)) {
            ItemStack itemstack2 = itemClicked.m_255036_(1);
            itemClicked.m_41774_(1);
            ((Slot)this.f_38839_.get(0)).m_269060_(itemstack2);
        }
        if (itemClicked.m_41619_()) {
            slotClicked.m_269060_(ItemStack.f_41583_);
        } else {
            slotClicked.m_6654_();
        }
        if (itemClicked.m_41613_() == itemstack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slotClicked.m_142406_(pPlayer, itemClicked);
        return itemstack;
    }

    public boolean m_6875_(Player pPlayer) {
        return this.container.m_6542_(pPlayer);
    }
}

