/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.experience.enchantments.enchantment;

import insane96mcp.iguanatweaksexpanded.module.experience.enchantments.NewEnchantmentsFeature;
import insane96mcp.iguanatweaksexpanded.module.items.solarium.integration.BuzzierBeesIntegration;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.EnchantmentsFeature;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.event.HurtItemStackEvent;
import insane96mcp.insanelib.util.MCUtils;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;

public class Weathering
extends Enchantment {
    public static final UUID ATTACK_SPEED_MODIFIER_UUID = UUID.fromString("435317e9-0146-4f1b-bc21-67f466ee5f9c");

    public Weathering() {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.VANISHABLE, new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET});
    }

    public int m_6183_(int level) {
        return 20 + (level - 1) * 30;
    }

    public int m_6175_(int level) {
        return this.m_6183_(level) + 20;
    }

    public static float getMiningSpeedBoost(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof DiggerItem)) {
            return 0.0f;
        }
        DiggerItem diggerItem = (DiggerItem)item;
        int lvl = stack.getEnchantmentLevel((Enchantment)NewEnchantmentsFeature.WEATHERING.get());
        if (lvl == 0) {
            return 0.0f;
        }
        return diggerItem.f_40980_ * 0.5f;
    }

    public static float getMiningSpeedBoost(ItemStack stack, LivingEntity entity, BlockState state, boolean tooltip) {
        float miningSpeedBoost = Weathering.getMiningSpeedBoost(stack);
        if (miningSpeedBoost == 0.0f) {
            return 0.0f;
        }
        float skyLightRatio = Weathering.getSunLightRatio((Entity)entity);
        if (skyLightRatio <= 0.0f) {
            return 0.0f;
        }
        return EnchantmentsFeature.applyMiningSpeedModifiers((float)(miningSpeedBoost *= skyLightRatio), (BlockState)state, (boolean)false, (LivingEntity)entity, (!tooltip ? 1 : 0) != 0);
    }

    public static float getSunLightRatio(Entity entity) {
        if (!entity.m_9236_().m_46461_() || entity.m_9236_().m_46470_()) {
            return 0.0f;
        }
        float sunLight = Weathering.getSunLight(entity);
        if (entity.m_9236_().m_46471_()) {
            sunLight *= 0.35f;
        }
        return Math.min(sunLight, 12.0f) / 12.0f;
    }

    public static float getSunLight(Entity entity) {
        float calculatedSkyLight = entity.m_9236_().m_45517_(LightLayer.SKY, entity.m_20183_()) - entity.m_9236_().m_7445_();
        if (ModList.get().isLoaded("buzzier_bees") && BuzzierBeesIntegration.hasSunny(entity)) {
            calculatedSkyLight = 15.0f;
        }
        return calculatedSkyLight;
    }

    public static float getAttackSpeedBoost(ItemStack stack) {
        int lvl = stack.getEnchantmentLevel((Enchantment)NewEnchantmentsFeature.WEATHERING.get());
        if (lvl == 0) {
            return 0.0f;
        }
        return 0.25f;
    }

    public static void applyAttackSpeedBoost(LivingEntity entity) {
        if (entity.f_19797_ % 5 != 3) {
            return;
        }
        float attackSpeedBoost = Weathering.getAttackSpeedBoost(entity.m_21205_());
        if (attackSpeedBoost == 0.0f) {
            return;
        }
        AttributeInstance attributeInstance = entity.m_21051_(Attributes.f_22283_);
        if (attributeInstance == null) {
            return;
        }
        float skyLightRatio = Weathering.getMoonLightRatio((Entity)entity);
        AttributeModifier modifier = attributeInstance.m_22111_(ATTACK_SPEED_MODIFIER_UUID);
        if (modifier != null && modifier.m_22218_() != (double)(attackSpeedBoost *= skyLightRatio)) {
            attributeInstance.m_22120_(ATTACK_SPEED_MODIFIER_UUID);
        }
        if (attackSpeedBoost > 0.0f) {
            MCUtils.applyModifier((LivingEntity)entity, (Attribute)Attributes.f_22283_, (UUID)ATTACK_SPEED_MODIFIER_UUID, (String)"Weathering boost", (double)attackSpeedBoost, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE, (boolean)false);
        }
    }

    public static float getMoonLightRatio(Entity entity) {
        if (entity.m_9236_().m_46461_() || entity.m_9236_().m_46470_()) {
            return 0.0f;
        }
        float moonLight = Weathering.getMoonLight(entity);
        if (entity.m_9236_().m_46471_()) {
            moonLight *= 0.35f;
        }
        return Math.min(moonLight, 12.0f) / 12.0f;
    }

    public static float getMoonLight(Entity entity) {
        float calculatedSkyLight = entity.m_9236_().m_45517_(LightLayer.SKY, entity.m_20183_());
        if (ModList.get().isLoaded("buzzier_bees") && BuzzierBeesIntegration.hasSunny(entity)) {
            calculatedSkyLight = 0.0f;
        }
        return calculatedSkyLight;
    }

    public static void applyUnbreaking(HurtItemStackEvent event) {
        float skyLightRatio = Weathering.getRainRatio((Entity)event.getEntity());
        if (skyLightRatio <= 0.0f) {
            return;
        }
        int newAmount = event.getAmount();
        for (int i = 0; i < event.getAmount(); ++i) {
            if (!(event.getEntity().m_217043_().m_188501_() <= 0.667f)) continue;
            --newAmount;
        }
        event.setAmount(newAmount);
    }

    public static float getRainRatio(Entity entity) {
        return entity.m_9236_().m_46758_(entity.m_20183_()) ? 1.0f : 0.0f;
    }

    public boolean m_6592_() {
        return Feature.isEnabled(NewEnchantmentsFeature.class);
    }
}

