/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.items.solarium;

import insane96mcp.iguanatweaksexpanded.InsaneSE;
import insane96mcp.iguanatweaksexpanded.module.items.solarium.SoliumMossBlock;
import insane96mcp.iguanatweaksexpanded.module.items.solarium.integration.BuzzierBeesIntegration;
import insane96mcp.iguanatweaksexpanded.module.items.solarium.item.SolariumArmorItem;
import insane96mcp.iguanatweaksexpanded.module.items.solarium.item.SolariumAxeItem;
import insane96mcp.iguanatweaksexpanded.module.items.solarium.item.SolariumHoeItem;
import insane96mcp.iguanatweaksexpanded.module.items.solarium.item.SolariumPickaxeItem;
import insane96mcp.iguanatweaksexpanded.module.items.solarium.item.SolariumShield;
import insane96mcp.iguanatweaksexpanded.module.items.solarium.item.SolariumShovelItem;
import insane96mcp.iguanatweaksexpanded.module.items.solarium.item.SolariumSwordItem;
import insane96mcp.iguanatweaksexpanded.module.misc.ISEDataPacks;
import insane96mcp.iguanatweaksexpanded.setup.ISERegistries;
import insane96mcp.iguanatweaksexpanded.setup.registry.SimpleBlockWithItem;
import insane96mcp.iguanatweaksreborn.module.combat.RegeneratingAbsorption;
import insane96mcp.insanelib.InsaneLib;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.item.ILItemTier;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.shieldsplus.world.item.SPShieldItem;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GlowLichenBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.RegistryObject;

@LoadFeature(module="iguanatweaksexpanded:items", description="Add Solarium, a new material made by alloying Overgrown solium moss ball (found in hot biomes) and can be used to upgrade Iron Equipment. Disabling this will disable ore generation and items in the creative inventory.", enabledByDefault=false)
public class Solarium
extends Feature {
    public static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("c9c18638-6505-4544-9871-6397916fd0b7");
    public static final UUID ATTACK_SPEED_MODIFIER_UUID = UUID.fromString("435317e9-0146-4f1b-bc21-67f466ee5f9c");
    public static final TagKey<Item> SOLARIUM_EQUIPMENT = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("iguanatweaksexpanded", "equipment/solarium"));
    public static final TagKey<Item> SOLARIUM_HAND_EQUIPMENT = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("iguanatweaksexpanded", "equipment/hand/solarium"));
    public static final SimpleBlockWithItem SOLIUM_MOSS = SimpleBlockWithItem.register("solium_moss", () -> new SoliumMossBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283843_).m_278166_(PushReaction.DESTROY).m_60910_().m_60978_(0.4f).m_60918_(SoundType.f_154676_).m_60953_(GlowLichenBlock.m_181222_((int)9)).m_60977_()));
    public static final RegistryObject<Item> SOLARIUM_BALL = ISERegistries.ITEMS.register("solarium_ball", () -> new Item(new Item.Properties()));
    public static final ILItemTier ITEM_TIER = new ILItemTier(2, 207, 5.0f, 1.0f, 11, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)SOLARIUM_BALL.get()}));
    public static final RegistryObject<Item> SWORD = ISERegistries.ITEMS.register("solarium_sword", () -> new SolariumSwordItem(3, -2.4f, new Item.Properties()));
    public static final RegistryObject<Item> SHOVEL = ISERegistries.ITEMS.register("solarium_shovel", () -> new SolariumShovelItem(1.5f, -3.0f, new Item.Properties()));
    public static final RegistryObject<Item> PICKAXE = ISERegistries.ITEMS.register("solarium_pickaxe", () -> new SolariumPickaxeItem(1, -2.8f, new Item.Properties()));
    public static final RegistryObject<Item> AXE = ISERegistries.ITEMS.register("solarium_axe", () -> new SolariumAxeItem(5.5f, -3.2f, new Item.Properties()));
    public static final RegistryObject<Item> HOE = ISERegistries.ITEMS.register("solarium_hoe", () -> new SolariumHoeItem(0, -1.0f, new Item.Properties()));
    public static final RegistryObject<Item> HELMET = ISERegistries.ITEMS.register("solarium_helmet", () -> new SolariumArmorItem(ArmorItem.Type.HELMET, new Item.Properties()));
    public static final RegistryObject<Item> CHESTPLATE = ISERegistries.ITEMS.register("solarium_chestplate", () -> new SolariumArmorItem(ArmorItem.Type.CHESTPLATE, new Item.Properties()));
    public static final RegistryObject<Item> LEGGINGS = ISERegistries.ITEMS.register("solarium_leggings", () -> new SolariumArmorItem(ArmorItem.Type.LEGGINGS, new Item.Properties()));
    public static final RegistryObject<Item> BOOTS = ISERegistries.ITEMS.register("solarium_boots", () -> new SolariumArmorItem(ArmorItem.Type.BOOTS, new Item.Properties()));

    public Solarium(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        InsaneSE.addServerPack("solarium", "Insane's Survival Extra Solarium", () -> this.isEnabled() && ISEDataPacks.disableAllDataPacks == false);
    }

    public static void healGear(ItemStack stack, Entity entity, Level level) {
        if (level.f_46443_ || entity.f_19797_ % 60 != 22) {
            return;
        }
        float chance = Solarium.getCalculatedSkyLightRatio(entity);
        if (chance <= 0.0f || level.f_46441_.m_188501_() >= chance) {
            return;
        }
        stack.m_41721_(stack.m_41773_() - 1);
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        Solarium.armorBoost(event);
    }

    public static void armorBoost(LivingEvent.LivingTickEvent event) {
        if (event.getEntity().f_19797_ % 5 != 4) {
            return;
        }
        Attribute attr = (Attribute)RegeneratingAbsorption.SPEED_ATTRIBUTE.get();
        AttributeInstance attributeInstance = event.getEntity().m_21051_(attr);
        if (attributeInstance == null) {
            return;
        }
        float calculatedSkyLightRatio = Solarium.getCalculatedSkyLightRatio((Entity)event.getEntity());
        float amount = 0.0f;
        for (ItemStack stack : event.getEntity().m_6168_()) {
            if (!stack.m_204117_(SOLARIUM_EQUIPMENT)) continue;
            amount += 0.05f;
        }
        AttributeModifier modifier = attributeInstance.m_22111_(ARMOR_MODIFIER_UUID);
        if (modifier != null && modifier.m_22218_() != (double)(amount *= calculatedSkyLightRatio)) {
            attributeInstance.m_22120_(ARMOR_MODIFIER_UUID);
        }
        if (amount > 0.0f) {
            MCUtils.applyModifier((LivingEntity)event.getEntity(), (Attribute)attr, (UUID)ARMOR_MODIFIER_UUID, (String)"Solarium boost", (double)amount, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION, (boolean)false);
        }
    }

    @SubscribeEvent
    public void boostAD(LivingHurtEvent event) {
        LivingEntity entity;
        Entity entity2 = event.getSource().m_7639_();
        if (!(entity2 instanceof LivingEntity) || !(entity = (LivingEntity)entity2).m_21205_().m_204117_(SOLARIUM_EQUIPMENT)) {
            return;
        }
        float calculatedSkyLightRatio = Solarium.getCalculatedSkyLightRatio((Entity)event.getEntity());
        if (calculatedSkyLightRatio <= 0.0f) {
            return;
        }
        event.setAmount(event.getAmount() * (1.0f + 0.2f * calculatedSkyLightRatio));
    }

    @SubscribeEvent
    public void boostMiningSpeed(PlayerEvent.BreakSpeed event) {
        if (!event.getEntity().m_21205_().m_204117_(SOLARIUM_EQUIPMENT) || !event.getEntity().m_21205_().m_41735_(event.getState())) {
            return;
        }
        float calculatedSkyLightRatio = Solarium.getCalculatedSkyLightRatio((Entity)event.getEntity());
        if (calculatedSkyLightRatio <= 0.0f) {
            return;
        }
        event.setNewSpeed(event.getNewSpeed() * (1.0f + calculatedSkyLightRatio * 0.5f));
    }

    public static float getCalculatedSkyLight(Entity entity) {
        float calculatedSkyLight = Solarium.getCalculatedSkyLight(entity.m_9236_(), entity.m_20183_());
        if (ModList.get().isLoaded("buzzier_bees") && BuzzierBeesIntegration.hasSunny(entity)) {
            calculatedSkyLight = 15.0f;
        }
        return calculatedSkyLight;
    }

    private static float getCalculatedSkyLight(Level level, BlockPos pos) {
        if (!level.m_46461_() || level.m_46470_()) {
            return 0.0f;
        }
        float skyLight = level.m_45517_(LightLayer.SKY, pos) - level.m_7445_();
        if (level.m_46471_()) {
            skyLight /= 3.0f;
        }
        return skyLight;
    }

    public static float getCalculatedSkyLightRatio(Entity entity) {
        return Math.min(Solarium.getCalculatedSkyLight(entity), 12.0f) / 12.0f;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onTooltip(ItemTooltipEvent event) {
        if (!this.isEnabled() || event.getEntity() == null) {
            return;
        }
        float calculatedSkyLightRatio = Solarium.getCalculatedSkyLightRatio((Entity)event.getEntity());
        if (event.getItemStack().m_204117_(SOLARIUM_EQUIPMENT)) {
            event.getToolTip().add(Component.m_237110_((String)"iguanatweaksexpanded.solarium.sunlight_repair", (Object[])new Object[]{InsaneLib.ONE_DECIMAL_FORMATTER.format(calculatedSkyLightRatio * 100.0f), 3}).m_130948_(Style.f_131099_.m_178520_(0xFFFF4D)));
        }
        if (event.getItemStack().m_204117_(SOLARIUM_HAND_EQUIPMENT)) {
            float bonusMiningSpeed = calculatedSkyLightRatio * 0.5f;
            event.getToolTip().add(Component.m_237110_((String)"iguanatweaksexpanded.solarium.sunlight_mining_speed", (Object[])new Object[]{InsaneLib.ONE_DECIMAL_FORMATTER.format(bonusMiningSpeed * 100.0f)}).m_130948_(Style.f_131099_.m_178520_(0xFFFF4D)));
            float bonusAttackDamage = calculatedSkyLightRatio * 0.2f;
            event.getToolTip().add(Component.m_237110_((String)"iguanatweaksexpanded.solarium.sunlight_bonus_damage", (Object[])new Object[]{InsaneLib.ONE_DECIMAL_FORMATTER.format(bonusAttackDamage * 100.0f)}).m_130948_(Style.f_131099_.m_178520_(0xFFFF4D)));
        } else if (event.getItemStack().m_41720_() instanceof SolariumArmorItem) {
            float bonusRegenSpeed = calculatedSkyLightRatio * 0.05f;
            event.getToolTip().add(Component.m_237110_((String)"iguanatweaksexpanded.solarium.sunlight_bonus_regen_absorption_speed", (Object[])new Object[]{ItemStack.f_41584_.format(bonusRegenSpeed)}).m_130948_(Style.f_131099_.m_178520_(0xFFFF4D)));
        }
    }

    @SubscribeEvent
    public void onBlockBreak(PlayerEvent.BreakSpeed event) {
        if (!(this.isEnabled() && event.getState().m_60713_((Block)SOLIUM_MOSS.block().get()) && event.getEntity().m_21205_().m_41720_() instanceof ShearsItem)) {
            return;
        }
        event.setNewSpeed(event.getOriginalSpeed() * 5.0f);
    }

    public static class ShieldsPlusIntegration {
        public static final RegistryObject<SPShieldItem> SHIELD = SolariumShield.registerShield("solarium_shield");

        public static void init() {
        }
    }
}

