/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.mining.miningcharge;

import insane96mcp.iguanatweaksexpanded.module.mining.miningcharge.MiningCharge;
import insane96mcp.iguanatweaksexpanded.module.mining.miningcharge.PrimedMiningCharge;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MiningChargeBlock
extends TntBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    private static final VoxelShape SHAPE_UP = Block.m_49796_((double)2.0, (double)10.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)6.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)14.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)6.0, (double)14.0, (double)14.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)10.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);

    public MiningChargeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_57419_, (Comparable)Boolean.FALSE)).m_61124_((Property)FACING, (Comparable)Direction.DOWN));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        switch (direction) {
            case DOWN: {
                return SHAPE_DOWN;
            }
            case UP: {
                return SHAPE_UP;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case EAST: {
                return SHAPE_EAST;
            }
        }
        return SHAPE_DOWN;
    }

    public void onCaughtFire(BlockState state, Level level, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        if (!level.f_46443_) {
            PrimedMiningCharge primedMiningCharge = new PrimedMiningCharge(level, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, igniter, (Direction)state.m_61143_((Property)FACING));
            level.m_7967_((Entity)primedMiningCharge);
            level.m_6263_(null, primedMiningCharge.m_20185_(), primedMiningCharge.m_20186_(), primedMiningCharge.m_20189_(), (SoundEvent)MiningCharge.PRIMED_MINING_CHARGE_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.2f);
            level.m_142346_((Entity)igniter, GameEvent.f_157776_, pos);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_43719_().m_122424_());
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (!level.f_46443_) {
            PrimedMiningCharge primedMiningCharge = new PrimedMiningCharge(level, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, explosion.m_252906_(), (Direction)state.m_61143_((Property)FACING));
            int fuse = primedMiningCharge.getFuse();
            primedMiningCharge.setFuse((short)(level.f_46441_.m_188503_(fuse / 4) + fuse / 8));
            level.m_7967_((Entity)primedMiningCharge);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_57419_, FACING});
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return false;
    }
}

