/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.mining.multiblockfurnaces.block;

import com.google.common.collect.Lists;
import insane96mcp.iguanatweaksexpanded.module.mining.multiblockfurnaces.block.AbstractMultiBlockFurnace;
import insane96mcp.iguanatweaksexpanded.module.mining.multiblockfurnaces.crafting.AbstractMultiItemSmeltingRecipe;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMultiBlockFurnaceBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible {
    private static final int[] SLOTS_FOR_DOWN = new int[]{7, 6};
    private static final int[] SLOTS_FOR_SIDES = new int[]{6};
    public static final int DATA_LIT_TIME = 0;
    public static final int DATA_LIT_DURATION = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int BURN_TIME_STANDARD = 200;
    public static final int BURN_COOL_SPEED = 2;
    private final RecipeType<? extends AbstractMultiItemSmeltingRecipe> recipeType;
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
    int litTime;
    int litDuration;
    int cookingProgress;
    int cookingTotalTime;
    boolean isValid = false;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int dataId) {
            return switch (dataId) {
                case 0 -> AbstractMultiBlockFurnaceBlockEntity.this.litTime;
                case 1 -> AbstractMultiBlockFurnaceBlockEntity.this.litDuration;
                case 2 -> AbstractMultiBlockFurnaceBlockEntity.this.cookingProgress;
                case 3 -> AbstractMultiBlockFurnaceBlockEntity.this.cookingTotalTime;
                default -> 0;
            };
        }

        public void m_8050_(int dataId, int data) {
            switch (dataId) {
                case 0: {
                    AbstractMultiBlockFurnaceBlockEntity.this.litTime = data;
                    break;
                }
                case 1: {
                    AbstractMultiBlockFurnaceBlockEntity.this.litDuration = data;
                    break;
                }
                case 2: {
                    AbstractMultiBlockFurnaceBlockEntity.this.cookingProgress = data;
                    break;
                }
                case 3: {
                    AbstractMultiBlockFurnaceBlockEntity.this.cookingTotalTime = data;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeManager.CachedCheck<Container, ? extends AbstractMultiItemSmeltingRecipe> quickCheck;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    protected AbstractMultiBlockFurnaceBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState, RecipeType<? extends AbstractMultiItemSmeltingRecipe> pRecipeType) {
        super(pType, pPos, pBlockState);
        this.quickCheck = RecipeManager.m_220267_(pRecipeType);
        this.recipeType = pRecipeType;
    }

    public boolean isLit() {
        return this.litTime > 0;
    }

    public boolean lit(ItemStack stack, Level level, BlockPos pos, BlockState state) {
        boolean wasLit = this.isLit();
        this.litTime += this.getBurnDuration(stack);
        if (!wasLit) {
            this.litDuration = this.litTime;
        }
        state = (BlockState)state.m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(this.isLit()));
        level.m_7731_(pos, state, 3);
        AbstractMultiBlockFurnaceBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        return this.isLit();
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)pTag, this.items);
        this.litTime = pTag.m_128451_("BurnTime");
        this.cookingProgress = pTag.m_128451_("CookTime");
        this.cookingTotalTime = pTag.m_128451_("CookTimeTotal");
        this.litDuration = pTag.m_128451_("LitDuration");
        CompoundTag compoundtag = pTag.m_128469_("RecipesUsed");
        for (String s : compoundtag.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), compoundtag.m_128451_(s));
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("BurnTime", this.litTime);
        pTag.m_128405_("CookTime", this.cookingProgress);
        pTag.m_128405_("CookTimeTotal", this.cookingTotalTime);
        pTag.m_128405_("LitDuration", this.litDuration);
        ContainerHelper.m_18973_((CompoundTag)pTag, this.items);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((p_187449_, p_187450_) -> compoundtag.m_128405_(p_187449_.toString(), p_187450_.intValue()));
        pTag.m_128365_("RecipesUsed", (Tag)compoundtag);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, AbstractMultiBlockFurnaceBlockEntity blockEntity) {
        boolean hasFuel;
        int[] inputSlots;
        if (pLevel.m_46467_() % 20L == 11L) {
            blockEntity.isValid = ((AbstractMultiBlockFurnace)pState.m_60734_()).isValidMultiBlock(pLevel, pPos);
        }
        if (!blockEntity.isValid) {
            return;
        }
        boolean isLit = blockEntity.isLit();
        boolean setChanged = false;
        if (isLit && blockEntity.shouldBurnTimeTick()) {
            --blockEntity.litTime;
        }
        ItemStack fuelStack = (ItemStack)blockEntity.items.get(6);
        boolean hasInputItem = false;
        for (int slot : inputSlots = blockEntity.getIngredientSlots()) {
            if (((ItemStack)blockEntity.items.get(slot)).m_41619_()) continue;
            hasInputItem = true;
            break;
        }
        int burnDuration = blockEntity.getBurnDuration(fuelStack);
        boolean bl = hasFuel = !fuelStack.m_41619_() && burnDuration > 0;
        if ((blockEntity.isLit() || hasFuel) && hasInputItem) {
            boolean canOverflow;
            Recipe recipe = blockEntity.quickCheck.m_213657_((Container)blockEntity, pLevel).orElse(null);
            int i = blockEntity.m_6893_();
            boolean bl2 = canOverflow = blockEntity.canOverflowFuel() && blockEntity.litTime + burnDuration < blockEntity.maxOverflow();
            if ((!blockEntity.isLit() || canOverflow) && blockEntity.canBurn(pLevel.m_9598_(), recipe, inputSlots, blockEntity.items, i)) {
                blockEntity.litTime += burnDuration;
                if (!isLit) {
                    blockEntity.litDuration = blockEntity.litTime;
                }
                if (blockEntity.isLit()) {
                    setChanged = true;
                    if (fuelStack.hasCraftingRemainingItem()) {
                        blockEntity.items.set(6, (Object)fuelStack.getCraftingRemainingItem());
                    } else if (hasFuel) {
                        fuelStack.m_41774_(1);
                        if (fuelStack.m_41619_()) {
                            blockEntity.items.set(6, (Object)fuelStack.getCraftingRemainingItem());
                        }
                    }
                }
            }
            if (blockEntity.isLit() && blockEntity.canBurn(pLevel.m_9598_(), recipe, inputSlots, blockEntity.items, i)) {
                ++blockEntity.cookingProgress;
                if (blockEntity.cookingProgress == blockEntity.cookingTotalTime) {
                    blockEntity.cookingProgress = 0;
                    blockEntity.cookingTotalTime = AbstractMultiBlockFurnaceBlockEntity.getTotalCookTime(pLevel, blockEntity);
                    if (blockEntity.burn(pLevel.m_9598_(), recipe, inputSlots, blockEntity.items, i)) {
                        blockEntity.m_6029_(recipe);
                    }
                    setChanged = true;
                    AbstractMultiBlockFurnaceBlockEntity.tryGetItemFromLevel(pPos, pState, pLevel, blockEntity);
                }
            } else {
                blockEntity.cookingProgress = 0;
            }
        } else if (!blockEntity.isLit() && blockEntity.cookingProgress > 0) {
            blockEntity.cookingProgress = Mth.m_14045_((int)(blockEntity.cookingProgress - 2), (int)0, (int)blockEntity.cookingTotalTime);
        }
        if (!(hasInputItem && hasFuel || pLevel.m_46467_() % 100L != 21L)) {
            AbstractMultiBlockFurnaceBlockEntity.tryGetItemFromLevel(pPos, pState, pLevel, blockEntity);
        }
        if (isLit != blockEntity.isLit()) {
            setChanged = true;
            pState = (BlockState)pState.m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(blockEntity.isLit()));
            pLevel.m_7731_(pPos, pState, 3);
        }
        if (setChanged) {
            AbstractMultiBlockFurnaceBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    protected static void tryGetItemFromLevel(BlockPos pPos, BlockState pState, Level level, AbstractMultiBlockFurnaceBlockEntity blockEntity) {
        Tuple<ItemStack, Integer> fuelItem;
        BlockPos posBehind = pPos.m_121945_(((Direction)pState.m_61143_((Property)AbstractMultiBlockFurnace.FACING)).m_122424_()).m_7494_();
        Optional oHopperBlockEntity = level.m_141902_(posBehind, BlockEntityType.f_58933_);
        if (oHopperBlockEntity.isEmpty()) {
            return;
        }
        HopperBlockEntity hopperBlockEntity = (HopperBlockEntity)oHopperBlockEntity.get();
        ItemStack currentFuelStack = blockEntity.m_8020_(6);
        if (currentFuelStack.m_41613_() < currentFuelStack.m_41741_() && (fuelItem = AbstractMultiBlockFurnaceBlockEntity.getFirstFuelItem(blockEntity, hopperBlockEntity)) != null) {
            ItemStack inHopperStack = (ItemStack)fuelItem.m_14418_();
            int hopperSlot = (Integer)fuelItem.m_14419_();
            if (currentFuelStack.m_41619_()) {
                blockEntity.m_6836_(6, inHopperStack);
                hopperBlockEntity.m_6836_(hopperSlot, ItemStack.f_41583_);
            } else if (AbstractMultiBlockFurnaceBlockEntity.canMergeItems(currentFuelStack, inHopperStack)) {
                int placeableItemsCount = inHopperStack.m_41741_() - currentFuelStack.m_41613_();
                int actuallyPlaceableItemsCount = Math.min(inHopperStack.m_41613_(), placeableItemsCount);
                hopperBlockEntity.m_7407_(hopperSlot, actuallyPlaceableItemsCount);
                currentFuelStack.m_41769_(actuallyPlaceableItemsCount);
            }
        }
        int[] ingredientSlots = blockEntity.getIngredientSlots();
        boolean isInventoryEmpty = true;
        for (int slot = 0; slot < ingredientSlots.length; ++slot) {
            ItemStack destinationStack = blockEntity.m_8020_(slot);
            if (destinationStack.m_41619_()) continue;
            isInventoryEmpty = false;
            break;
        }
        if (isInventoryEmpty) {
            Tuple<ItemStack, Integer> inHopperStack = AbstractMultiBlockFurnaceBlockEntity.getFirstBurnableItem(blockEntity, level, hopperBlockEntity);
            if (inHopperStack == null) {
                return;
            }
            blockEntity.m_6836_(ingredientSlots[0], (ItemStack)inHopperStack.m_14418_());
            hopperBlockEntity.m_6836_(((Integer)inHopperStack.m_14419_()).intValue(), ItemStack.f_41583_);
        } else {
            List<Tuple<ItemStack, Integer>> hopperItems = AbstractMultiBlockFurnaceBlockEntity.getHopperItems(hopperBlockEntity);
            if (hopperItems.isEmpty()) {
                return;
            }
            for (int slot = 0; slot < ingredientSlots.length; ++slot) {
                ItemStack newStack;
                Tuple possibleStack;
                ItemStack destinationStack = blockEntity.m_8020_(slot);
                if (destinationStack.m_41619_() || destinationStack.m_41613_() >= destinationStack.m_41741_() || (possibleStack = (Tuple)hopperItems.stream().filter(tuple -> ((ItemStack)tuple.m_14418_()).m_150930_(destinationStack.m_41720_())).findFirst().orElse(null)) == null || !AbstractMultiBlockFurnaceBlockEntity.canMergeItems(destinationStack, newStack = ((ItemStack)possibleStack.m_14418_()).m_41777_())) continue;
                int placeableItemsCount = newStack.m_41741_() - destinationStack.m_41613_();
                int actuallyPlaceableItemsCount = Math.min(newStack.m_41613_(), placeableItemsCount);
                hopperBlockEntity.m_7407_(((Integer)possibleStack.m_14419_()).intValue(), actuallyPlaceableItemsCount);
                destinationStack.m_41769_(actuallyPlaceableItemsCount);
            }
        }
    }

    private static List<Tuple<ItemStack, Integer>> getHopperItems(HopperBlockEntity hopperBlockEntity) {
        ArrayList<Tuple<ItemStack, Integer>> items = new ArrayList<Tuple<ItemStack, Integer>>();
        for (int i = 0; i < hopperBlockEntity.m_6643_(); ++i) {
            ItemStack stack = hopperBlockEntity.m_8020_(i);
            if (stack.m_41619_()) continue;
            items.add((Tuple<ItemStack, Integer>)new Tuple((Object)stack, (Object)i));
        }
        return items;
    }

    @Nullable
    private static Tuple<ItemStack, Integer> getFirstBurnableItem(AbstractMultiBlockFurnaceBlockEntity blockEntity, Level level, HopperBlockEntity hopperBlockEntity) {
        for (int i = 0; i < hopperBlockEntity.m_6643_(); ++i) {
            ItemStack stack = hopperBlockEntity.m_8020_(i);
            if (stack.m_41619_() || !blockEntity.canSmelt(stack, level)) continue;
            return new Tuple((Object)stack, (Object)i);
        }
        return null;
    }

    @Nullable
    private static Tuple<ItemStack, Integer> getFirstFuelItem(AbstractMultiBlockFurnaceBlockEntity pBlockEntity, HopperBlockEntity hopperBlockEntity) {
        for (int i = 0; i < hopperBlockEntity.m_6643_(); ++i) {
            ItemStack stack = hopperBlockEntity.m_8020_(i);
            if (pBlockEntity.getBurnDuration(stack) <= 0) continue;
            return new Tuple((Object)stack, (Object)i);
        }
        return null;
    }

    protected boolean canSmelt(ItemStack pStack, Level level) {
        return level.m_7465_().m_44013_(this.recipeType).stream().anyMatch(recipe -> recipe.hasIngredient(pStack, this.f_58857_));
    }

    protected abstract boolean canOverflowFuel();

    protected abstract int maxOverflow();

    protected abstract boolean shouldBurnTimeTick();

    private boolean canBurn(RegistryAccess registryAccess, @javax.annotation.Nullable Recipe<?> recipe, int[] inputSlots, NonNullList<ItemStack> slotsStacks, int stackSize) {
        if (recipe == null) {
            return false;
        }
        boolean hasIngredient = false;
        for (int slot : inputSlots) {
            if (((ItemStack)slotsStacks.get(slot)).m_41619_()) continue;
            hasIngredient = true;
        }
        if (!hasIngredient) {
            return false;
        }
        ItemStack resultStack = recipe.m_8043_(registryAccess);
        if (resultStack.m_41619_()) {
            return false;
        }
        ItemStack resultSlotStack = (ItemStack)slotsStacks.get(7);
        if (resultSlotStack.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_41656_((ItemStack)resultSlotStack, (ItemStack)resultStack)) {
            return false;
        }
        if (resultSlotStack.m_41613_() >= resultStack.m_41741_()) {
            return false;
        }
        return resultSlotStack.m_41613_() + resultStack.m_41613_() < stackSize;
    }

    private boolean burn(RegistryAccess registryAccess, @javax.annotation.Nullable Recipe<?> recipe, int[] inputSlots, NonNullList<ItemStack> slotStacks, int stackSize) {
        if (!this.canBurn(registryAccess, recipe, inputSlots, slotStacks, stackSize)) {
            return false;
        }
        ItemStack resultStack = recipe.m_5874_((Container)this, registryAccess);
        ItemStack resultSlotStack = (ItemStack)slotStacks.get(7);
        if (resultSlotStack.m_41619_()) {
            this.m_6836_(7, resultStack.m_41777_());
        } else if (resultSlotStack.m_150930_(resultStack.m_41720_())) {
            resultSlotStack.m_41769_(resultStack.m_41613_());
        }
        for (int slot : inputSlots) {
            ((ItemStack)slotStacks.get(slot)).m_41774_(1);
        }
        return true;
    }

    public boolean canLit(ItemStack stack) {
        return !this.isLit() || this.canOverflowFuel() && this.litTime + this.getBurnDuration(stack) <= this.maxOverflow();
    }

    protected int getBurnDuration(ItemStack pFuel) {
        return pFuel.m_41619_() ? 0 : ForgeHooks.getBurnTime((ItemStack)pFuel, this.recipeType);
    }

    private static int getTotalCookTime(Level pLevel, AbstractMultiBlockFurnaceBlockEntity pBlockEntity) {
        return pBlockEntity.quickCheck.m_213657_((Container)pBlockEntity, pLevel).map(AbstractMultiItemSmeltingRecipe::getCookingTime).orElse(200);
    }

    private static boolean canMergeItems(ItemStack stack1, ItemStack stack2) {
        if (!stack1.m_150930_(stack2.m_41720_()) || stack1.m_41773_() != stack2.m_41773_()) {
            return false;
        }
        return stack1.m_41613_() <= stack1.m_41741_() && ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2);
    }

    public int[] m_7071_(Direction pSide) {
        if (pSide == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        if (pSide != Direction.UP) {
            return SLOTS_FOR_SIDES;
        }
        return this.getIngredientSlots();
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return this.m_7013_(pIndex, pItemStack);
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        if (pDirection == Direction.DOWN && pIndex == 6) {
            return pStack.m_150930_(Items.f_42446_);
        }
        if (pDirection == Direction.UP) {
            for (int slot = 0; slot < this.getIngredientSlots().length; ++slot) {
                if (slot != pIndex) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected Component m_6820_() {
        return null;
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return null;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int pSlot) {
        return (ItemStack)this.items.get(pSlot);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return ContainerHelper.m_18969_(this.items, (int)pSlot, (int)pAmount);
    }

    public ItemStack m_8016_(int pSlot) {
        return ContainerHelper.m_18966_(this.items, (int)pSlot);
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        ItemStack itemstack = (ItemStack)this.items.get(pSlot);
        boolean flag = !pStack.m_41619_() && ItemStack.m_150942_((ItemStack)pStack, (ItemStack)itemstack);
        this.items.set(pSlot, (Object)pStack);
        if (pSlot < 6 && !flag) {
            this.cookingTotalTime = AbstractMultiBlockFurnaceBlockEntity.getTotalCookTime(this.f_58857_, this);
            this.cookingProgress = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player pPlayer) {
        return Container.m_272074_((BlockEntity)this, (Player)pPlayer);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_6029_(@Nullable Recipe<?> pRecipe) {
        if (pRecipe != null) {
            ResourceLocation resourcelocation = pRecipe.m_6423_();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer pPlayer) {
        List<Recipe<?>> list = this.getRecipesToAwardAndPopExperience((ServerLevel)pPlayer.m_9236_(), pPlayer.m_20182_());
        pPlayer.m_7281_(list);
        this.recipesUsed.clear();
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel pLevel, Vec3 pPopVec) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            pLevel.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(p_155023_ -> {
                list.add(p_155023_);
                AbstractMultiBlockFurnaceBlockEntity.createExperience(pLevel, pPopVec, entry.getIntValue(), ((AbstractMultiItemSmeltingRecipe)p_155023_).getExperience());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel pLevel, Vec3 pPopVec, int pRecipeIndex, float pExperience) {
        int i = Mth.m_14143_((float)((float)pRecipeIndex * pExperience));
        float f = Mth.m_14187_((float)((float)pRecipeIndex * pExperience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.m_147082_((ServerLevel)pLevel, (Vec3)pPopVec, (int)i);
    }

    public void m_5809_(StackedContents pHelper) {
        for (ItemStack itemstack : this.items) {
            pHelper.m_36491_(itemstack);
        }
    }

    public int m_6893_() {
        return 96;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }

    public abstract int[] getIngredientSlots();
}

