/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.mining.quaron;

import insane96mcp.iguanatweaksexpanded.InsaneSE;
import insane96mcp.iguanatweaksexpanded.integration.ShieldsPlusRegistration;
import insane96mcp.iguanatweaksexpanded.item.ISEArmorMaterial;
import insane96mcp.iguanatweaksexpanded.module.mining.quaron.QuaronFishingRod;
import insane96mcp.iguanatweaksexpanded.module.misc.ISEDataPacks;
import insane96mcp.iguanatweaksexpanded.setup.ISERegistries;
import insane96mcp.iguanatweaksexpanded.setup.registry.SimpleBlockWithItem;
import insane96mcp.iguanatweaksreborn.event.HookTickToHookLureEvent;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.EnchantmentsFeature;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.event.HurtItemStackEvent;
import insane96mcp.insanelib.item.ILItemTier;
import insane96mcp.shieldsplus.world.item.SPShieldItem;
import insane96mcp.shieldsplus.world.item.SPShieldMaterial;
import java.util.EnumMap;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegistryObject;

@Label(name="Quaron", description="Add Quaron, a new metal made by alloying Iron and Amethyst. Disabling this will disable ore generation and items in the creative inventory.")
@LoadFeature(module="iguanatweaksexpanded:mining", enabledByDefault=false)
public class Quaron
extends Feature {
    public static final TagKey<Item> TOOL_EQUIPMENT = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("iguanatweaksexpanded", "equipment/hand/tools/quaron"));
    public static final SimpleBlockWithItem BLOCK = SimpleBlockWithItem.register("quaron_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60999_().m_60913_(5.0f, 7.0f).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Item> INGOT = ISERegistries.ITEMS.register("quaron_ingot", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> NUGGET = ISERegistries.ITEMS.register("quaron_nugget", () -> new Item(new Item.Properties()));
    public static final ILItemTier ITEM_TIER = new ILItemTier(3, 1242, 6.0f, 2.5f, 11, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)INGOT.get()}));
    public static final RegistryObject<Item> SWORD = ISERegistries.ITEMS.register("quaron_sword", () -> new SwordItem((Tier)ITEM_TIER, 3, -2.4f, new Item.Properties()));
    public static final RegistryObject<Item> SHOVEL = ISERegistries.ITEMS.register("quaron_shovel", () -> new ShovelItem((Tier)ITEM_TIER, 1.5f, -3.0f, new Item.Properties()));
    public static final RegistryObject<Item> PICKAXE = ISERegistries.ITEMS.register("quaron_pickaxe", () -> new PickaxeItem((Tier)ITEM_TIER, 1, -2.8f, new Item.Properties()));
    public static final RegistryObject<Item> AXE = ISERegistries.ITEMS.register("quaron_axe", () -> new AxeItem((Tier)ITEM_TIER, 6.0f, -3.1f, new Item.Properties()));
    public static final RegistryObject<Item> HOE = ISERegistries.ITEMS.register("quaron_hoe", () -> new HoeItem((Tier)ITEM_TIER, -2, -1.0f, new Item.Properties()));
    private static final ISEArmorMaterial ARMOR_MATERIAL = new ISEArmorMaterial("iguanatweaksexpanded:quaron", 20, (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), p_266652_ -> {
        p_266652_.put(ArmorItem.Type.BOOTS, 2);
        p_266652_.put(ArmorItem.Type.LEGGINGS, 5);
        p_266652_.put(ArmorItem.Type.CHESTPLATE, 6);
        p_266652_.put(ArmorItem.Type.HELMET, 2);
    }), 6, SoundEvents.f_11677_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)INGOT.get()}));
    public static final RegistryObject<Item> HELMET = ISERegistries.ITEMS.register("quaron_helmet", () -> new ArmorItem((ArmorMaterial)ARMOR_MATERIAL, ArmorItem.Type.HELMET, new Item.Properties()));
    public static final RegistryObject<Item> CHESTPLATE = ISERegistries.ITEMS.register("quaron_chestplate", () -> new ArmorItem((ArmorMaterial)ARMOR_MATERIAL, ArmorItem.Type.CHESTPLATE, new Item.Properties()));
    public static final RegistryObject<Item> LEGGINGS = ISERegistries.ITEMS.register("quaron_leggings", () -> new ArmorItem((ArmorMaterial)ARMOR_MATERIAL, ArmorItem.Type.LEGGINGS, new Item.Properties()));
    public static final RegistryObject<Item> BOOTS = ISERegistries.ITEMS.register("quaron_boots", () -> new ArmorItem((ArmorMaterial)ARMOR_MATERIAL, ArmorItem.Type.BOOTS, new Item.Properties()));
    public static final RegistryObject<QuaronFishingRod> FISHING_ROD = ISERegistries.ITEMS.register("quaron_fishing_rod", () -> new QuaronFishingRod(new Item.Properties().m_41503_(94)));

    public Quaron(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        InsaneSE.addServerPack("quaron", "Insane's Survival Extra Quaron", () -> this.isEnabled() && ISEDataPacks.disableAllDataPacks == false);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockBreak(PlayerEvent.BreakSpeed event) {
        if (!this.isEnabled() || !event.getEntity().m_21205_().m_204117_(TOOL_EQUIPMENT) || event.getState().m_60834_()) {
            return;
        }
        int effLevel = event.getEntity().m_21205_().getEnchantmentLevel(Enchantments.f_44984_);
        float bonus = EnchantmentsFeature.applyMiningSpeedModifiers((float)(1.0f + (float)effLevel * 0.25f), (BlockState)event.getState(), (boolean)false, (LivingEntity)event.getEntity(), (boolean)true);
        event.setNewSpeed(event.getOriginalSpeed() + bonus);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onHurtItemStack(HurtItemStackEvent event) {
        if (event.getAmount() <= 1 || !event.getStack().m_150930_((Item)FISHING_ROD.get())) {
            return;
        }
        event.setAmount(1);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onHookTickToHookLure(HookTickToHookLureEvent event) {
        Player playerOwner = event.getHookEntity().m_37168_();
        if (!this.isEnabled() || playerOwner == null) {
            return;
        }
        boolean mainHand = playerOwner.m_21205_().m_150930_((Item)FISHING_ROD.get());
        boolean offHand = playerOwner.m_21206_().m_150930_((Item)FISHING_ROD.get());
        if (playerOwner.m_21205_().m_41720_() instanceof QuaronFishingRod) {
            offHand = false;
        }
        if (!mainHand && !offHand) {
            return;
        }
        if (playerOwner.m_9236_().m_213780_().m_188501_() < 0.2f) {
            event.setTick(event.getTick() - 1);
        }
    }

    public static class ShieldsPlusIntegration {
        public static final SPShieldMaterial SHIELD_MATERIAL = new SPShieldMaterial("quaron", 441, INGOT, 9, Rarity.COMMON);
        public static final RegistryObject<SPShieldItem> SHIELD = ShieldsPlusRegistration.registerShield("quaron_shield", SHIELD_MATERIAL);

        public static void init() {
        }
    }
}

