/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.experience.enchanting;

import com.teamabnormals.allurement.core.AllurementConfig;
import insane96mcp.iguanatweaksexpanded.InsaneSE;
import insane96mcp.iguanatweaksexpanded.data.generator.ISEItemTagsProvider;
import insane96mcp.iguanatweaksexpanded.module.experience.enchanting.EnchantmentData;
import insane96mcp.iguanatweaksexpanded.module.experience.enchanting.ISEEnchantingTable;
import insane96mcp.iguanatweaksexpanded.module.experience.enchanting.ISEEnchantingTableBlockEntity;
import insane96mcp.iguanatweaksexpanded.module.experience.enchanting.ISEEnchantingTableMenu;
import insane96mcp.iguanatweaksexpanded.module.experience.enchanting.ISEEnchantingTableScreen;
import insane96mcp.iguanatweaksexpanded.module.experience.enchanting.ISEEnsorceller;
import insane96mcp.iguanatweaksexpanded.module.experience.enchanting.ISEEnsorcellerBlockEntity;
import insane96mcp.iguanatweaksexpanded.module.misc.ISEDataPacks;
import insane96mcp.iguanatweaksexpanded.setup.ISERegistries;
import insane96mcp.iguanatweaksexpanded.setup.registry.SimpleBlockWithItem;
import insane96mcp.iguanatweaksexpanded.utils.LogHelper;
import insane96mcp.iguanatweaksreborn.module.experience.PlayerExperience;
import insane96mcp.iguanatweaksreborn.module.experience.anvils.Anvils;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.EnchantmentsFeature;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.data.IdTagMatcher;
import insane96mcp.insanelib.data.IdTagValue;
import insane96mcp.insanelib.util.ModNBTData;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.GrindstoneEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Label(name="Enchanting", description="Adds a brand new enchanting table. If this feature is enabled, a data pack is also enabled that changes the enchanting table recipe to give the new one. Items in iguanatweaksexpanded:not_enchantable tag cannot be enchanted.")
@LoadFeature(module="iguanatweaksexpanded:experience")
public class EnchantingFeature
extends JsonFeature {
    public static final TagKey<Item> NOT_ENCHANTABLE = ISEItemTagsProvider.create("not_enchantable");
    public static final SimpleBlockWithItem ENCHANTING_TABLE = SimpleBlockWithItem.register("enchanting_table", () -> new ISEEnchantingTable(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50201_)));
    public static final RegistryObject<BlockEntityType<ISEEnchantingTableBlockEntity>> ENCHANTING_TABLE_BLOCK_ENTITY = ISERegistries.BLOCK_ENTITY_TYPES.register("enchanting_table", () -> BlockEntityType.Builder.m_155273_(ISEEnchantingTableBlockEntity::new, (Block[])new Block[]{(Block)ENCHANTING_TABLE.block().get()}).m_58966_(null));
    public static final RegistryObject<MenuType<ISEEnchantingTableMenu>> ENCHANTING_TABLE_MENU_TYPE = ISERegistries.MENU_TYPES.register("enchanting_table", () -> new MenuType(ISEEnchantingTableMenu::new, FeatureFlags.f_244377_));
    public static final SimpleBlockWithItem ENSORCELLER = SimpleBlockWithItem.register("ensorceller", () -> new ISEEnsorceller(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50201_).m_60953_(state -> 10)));
    public static final RegistryObject<BlockEntityType<ISEEnsorcellerBlockEntity>> ENSORCELLER_BLOCK_ENTITY = ISERegistries.BLOCK_ENTITY_TYPES.register("ensorceller", () -> BlockEntityType.Builder.m_155273_(ISEEnsorcellerBlockEntity::new, (Block[])new Block[]{(Block)ENSORCELLER.block().get()}).m_58966_(null));
    public static final ResourceLocation PURIFIED_ITEM = InsaneSE.location("purified");
    public static final Component PURIFIED_COMPONENT = Component.m_237115_((String)InsaneSE.lang("enchanting_purified")).m_130940_(ChatFormatting.DARK_PURPLE);
    public static final String EMPOWERED_ITEM_LEGACY = "iguanatweaksexpanded:empowered";
    @Config
    @Label(name="No enchantment merge", description="Enchanted items can no longer be merged with other enchanted items.")
    public static Boolean noEnchantmentMerge = true;
    @Config(description="Enchanted Books can no longer be merged with other enchanted books.")
    public static Boolean preventMergingBooks = false;
    @Config
    @Label(name="No enchanted smithing", description="Enchanted items can no longer be upgraded (e.g. netherite)")
    public static Boolean noEnchantedSmithing = true;
    @Config
    @Label(name="Grindstone.Better XP", description="If true, grindstone will give XP based off the new enchanting table. This is based off the ITR levelScalingFormula set to a fixed value")
    public static Boolean grindstoneBetterXp = true;
    @Config
    @Label(name="Grindstone.Treasure enchantment extraction", description="If true, grindstone will be able to extract treasure enchantments (and curses) from items onto books. Please note this feature is incompatible with Forgery, so you should ban the \"Grindstone disenchantment\" feature from it.")
    public static Boolean grindstoneTreasureEnchantmentExtraction = true;
    @Config
    @Label(name="Grindstone.Enchantment extraction", description="If true, grindstone will be able to extract all enchantments, not only treasure enchantments.")
    public static Boolean grindstoneEnchantmentExtraction = true;
    @Config
    @Label(name="Grindstone.Curse removal", description="If true, grindstone will also remove curses when disenchanting.")
    public static Boolean grindstoneCurseRemoval = false;
    @Config
    @Label(name="Allurement integration", description="If true, some mixins are used on Allurement to make the enchantments work on more things and configs are changed to not overlap with ITE.\nRequires Minecraft Restart.\nPLEASE NOTE that due to config limitation, some things cannot be disabled, so use item tags. E.g. Launch enchantment uses a new iguanatweaksexpanded:enchanting/allurement/accepts_launch_enchantments item tag to decide which item accepts the enchantment.\n")
    public static Boolean allurementIntegration = false;
    @Config
    @Label(name="Enchanting Table.Requires learning enchantments", description="If true, the new enchanting table must learn all the enchantments and not only treasure.")
    public static Boolean enchantingTableRequiresLearning = true;
    @Config
    @Label(name="Enchanting Table.One time use enchantments", description="If true, all the enchantments in the enchanting table (so, not only curses) are one time use. If enabled, you can no longer disenchant items in grindstone to prevent accidental loss.")
    public static Boolean enchantingTableOneTimeUseEnchantments = true;
    @Config(min=0.0)
    @Label(name="Enchanting Table.Max enchanting power", description="Increasing this increases bookshelves required. Vanilla is 15")
    public static Integer enchantingTableMaxEnchantingPower = 20;
    @Config(min=0.0)
    @Label(name="Enchanting Table.Enchantability multiplier", description="Tool enchantability multiplier if not purified")
    public static Double enchantingTableEnchantabilityMultiplier = 1.0;
    @Config(min=0.0)
    @Label(name="Enchanting Table.Purified Enchantability multiplier", description="Tool enchantability multiplier when purified")
    public static Double enchantingTablePurifiedEnchantabilityMultiplier = 1.25;
    @Config(min=0.0)
    @Label(name="Enchanting Table.Purified Enchantability flat", description="Tool enchantability bonus when purified")
    public static Integer enchantingTablePurifiedEnchantabilityFlat = 0;
    @Config(min=0.0)
    @Label(name="Enchanting Table.Base enchantability", description="Enchantability with no bookshelves")
    public static Integer enchantingTableBaseEnchantability = 0;
    @Config(description="How many ticks will the ensorceller take to generate a new enchantment")
    public static Integer ensorceller$timeToGenerate = 2400;
    @Config
    public static Boolean enablePurifyItems = true;
    public static final List<EnchantmentData> DEFAULT_ENCHANTMENTS_DATA = List.of(new EnchantmentData("minecraft:keego").costPerLevel(3), new EnchantmentData("minecraft:unbreaking").costPerLevel(1), new EnchantmentData("iguanatweaksexpanded:enduring").costPerLevel(1), new EnchantmentData("minecraft:mending").costPerLevel(2), new EnchantmentData("allurement:reforming").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:soulbound").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:keego").costPerLevel(3), new EnchantmentData("iguanatweaksreborn:luck").costPerLevel(4), new EnchantmentData("iguanatweaksexpanded:smartness").costPerLevel(4), new EnchantmentData("iguanatweaksexpanded:reach").costPerLevel(3), new EnchantmentData("iguanatweaksexpanded:knowledgeable").costPerLevel(4), new EnchantmentData("iguanatweaksexpanded:adrenaline").costPerLevel(1), new EnchantmentData("minecraft:lure").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:lucky_hook").costPerLevel(4), new EnchantmentData("minecraft:power").costPerLevel(1), new EnchantmentData("minecraft:punch").costPerLevel(2), new EnchantmentData("minecraft:flame").costPerLevel(2), new EnchantmentData("minecraft:infinity").costPerLevel(1), new EnchantmentData("minecraft:quick_charge").cost(1, 2, 4, 6), new EnchantmentData("minecraft:multishot").costPerLevel(3), new EnchantmentData("minecraft:piercing").costPerLevel(1), new EnchantmentData("allurement:reeling").costPerLevel(2), new EnchantmentData("allurement:spread_of_ailments").costPerLevel(1), new EnchantmentData("iguanatweaksexpanded:gravity_defying").costPerLevel(2), new EnchantmentData("minecraft:loyalty").costPerLevel(3), new EnchantmentData("minecraft:channeling").costPerLevel(4), new EnchantmentData("minecraft:riptide").costPerLevel(1), new EnchantmentData("minecraft:impaling").costPerLevel(1), new EnchantmentData("minecraft:efficiency").costPerLevel(1), new EnchantmentData("iguanatweaksexpanded:haste").costPerLevel(1), new EnchantmentData("iguanatweaksexpanded:blasting").costPerLevel(1), new EnchantmentData("iguanatweaksexpanded:expanded").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:veining").costPerLevel(2), new EnchantmentData("minecraft:silk_touch").costPerLevel(4), new EnchantmentData("iguanatweaksexpanded:exchange").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:earthbound").costPerLevel(3), new EnchantmentData("iguanatweaksreborn:sharpness").costPerLevel(1), new EnchantmentData("iguanatweaksreborn:bane_of_sssss").costPerLevel(1), new EnchantmentData("iguanatweaksreborn:smite").costPerLevel(1), new EnchantmentData("iguanatweaksexpanded:water_coolant").costPerLevel(1), new EnchantmentData("iguanatweaksexpanded:bane_of_noses").costPerLevel(1), new EnchantmentData("iguanatweaksexpanded:rage").costPerLevel(1), new EnchantmentData("iguanatweaksexpanded:fire_surge").costPerLevel(1), new EnchantmentData("iguanatweaksexpanded:swift_strike").costPerLevel(1), new EnchantmentData("iguanatweaksreborn:critical").costPerLevel(1), new EnchantmentData("iguanatweaksexpanded:armor_piercer").costPerLevel(1), new EnchantmentData("iguanatweaksreborn:fire_aspect").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:cryo_aspect").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:explosive").costPerLevel(2), new EnchantmentData("iguanatweaksreborn:knockback").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:padding").costPerLevel(2), new EnchantmentData("allurement:launch").costPerLevel(2), new EnchantmentData("iguanatweaksreborn:sweeping_edge").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:part_breaker").costPerLevel(4), new EnchantmentData("iguanatweaksexpanded:air_stealer").costPerLevel(2), new EnchantmentData("iguanatweaksreborn:protection").costPerLevel(4), new EnchantmentData("iguanatweaksreborn:blast_protection").costPerLevel(1), new EnchantmentData("iguanatweaksreborn:fire_protection").costPerLevel(1), new EnchantmentData("iguanatweaksreborn:projectile_protection").costPerLevel(1), new EnchantmentData("iguanatweaksexpanded:magic_protection").costPerLevel(1), new EnchantmentData("iguanatweaksexpanded:melee_protection").costPerLevel(1), new EnchantmentData("iguanatweaksexpanded:healthy").costPerLevel(1), new EnchantmentData("allurement:alleviating").costPerLevel(4), new EnchantmentData("iguanatweaksexpanded:flat_protection").costPerLevel(4), new EnchantmentData("iguanatweaksexpanded:absorption").costPerLevel(4), new EnchantmentData("minecraft:aqua_affinity").costPerLevel(3), new EnchantmentData("minecraft:respiration").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:enlightened").costPerLevel(2), new EnchantmentData("minecraft:thorns").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:air_born").costPerLevel(3), new EnchantmentData("iguanatweaksexpanded:recovery").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:vindication").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:invulnerability").costPerLevel(4), new EnchantmentData("iguanatweaksexpanded:fire_guardian").costPerLevel(3), new EnchantmentData("minecraft:swift_sneak").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:magnetic").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:retreat").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:sprint_pact").costPerLevel(4), new EnchantmentData("iguanatweaksexpanded:step_up").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:zippy").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:charged_jump").costPerLevel(3), new EnchantmentData("iguanatweaksreborn:feather_falling").costPerLevel(1), new EnchantmentData("minecraft:soul_speed").costPerLevel(2), new EnchantmentData("minecraft:depth_strider").costPerLevel(2), new EnchantmentData("minecraft:frost_walker").costPerLevel(2), new EnchantmentData("allurement:shockwave").costPerLevel(1), new EnchantmentData("iguanatweaksexpanded:double_jump").costPerLevel(4), new EnchantmentData("iguanatweaksexpanded:hoppy").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:steady_fall").costPerLevel(4), new EnchantmentData("passablefoliage:leaf_walker").costPerLevel(2), new EnchantmentData("shieldsplus:ablaze").costPerLevel(1), new EnchantmentData("shieldsplus:aegis").costPerLevel(1), new EnchantmentData("shieldsplus:celestial_guardian").costPerLevel(4), new EnchantmentData("shieldsplus:fast_recovery").costPerLevel(2), new EnchantmentData("shieldsplus:lightweight").costPerLevel(2), new EnchantmentData("shieldsplus:perfect_parry").costPerLevel(4), new EnchantmentData("shieldsplus:recoil").costPerLevel(2), new EnchantmentData("shieldsplus:reflection").costPerLevel(1), new EnchantmentData("shieldsplus:reinforced").costPerLevel(1), new EnchantmentData("allurement:ascension_curse").costPerLevel(3), new EnchantmentData("allurement:fleeting_curse").costPerLevel(2), new EnchantmentData("allurement:obedience").costPerLevel(2), new EnchantmentData("farmersdelight:backstabbing").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:blood_pact_curse").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:dumbness_curse").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:ender_curse").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:experience_curse").costPerLevel(3), new EnchantmentData("iguanatweaksexpanded:fragility_curse").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:frenzy_curse").costPerLevel(3), new EnchantmentData("iguanatweaksexpanded:hop_curse").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:inefficiency_curse").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:obscurity_curse").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:short_arm_curse").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:slow_charge_curse").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:slow_strike_curse").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:static_charge_curse").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:steel_fall_curse").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:tear_curse").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:unhurried_curse").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:unstable_motion_curse").costPerLevel(3), new EnchantmentData("iguanatweaksexpanded:void_curse").costPerLevel(2), new EnchantmentData("iguanatweaksexpanded:walking_curse").costPerLevel(3), new EnchantmentData("minecraft:binding_curse").costPerLevel(3), new EnchantmentData("minecraft:vanishing_curse").costPerLevel(3), new EnchantmentData("supplementaries:stasis").costPerLevel(4));
    public static final ArrayList<EnchantmentData> enchantmentsData = new ArrayList();
    public static final List<IdTagMatcher> DEFAULT_OVER_LEVEL_ENCHANTMENT_BLACKLIST = List.of(IdTagMatcher.newId((String)"minecraft:depth_strider"));
    public static final ArrayList<IdTagMatcher> overLevelEnchantmentBlacklist = new ArrayList();
    public static final List<IdTagValue> DEFAULT_STARTING_ENCHANTMENTS = List.of();
    public static final ArrayList<IdTagValue> startingEnchantments = new ArrayList();

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        InsaneSE.addServerPack("new_enchanting_table", "IguanaTweaks Expanded New Enchanting Table", () -> this.isEnabled() && ISEDataPacks.disableAllDataPacks == false);
        EnchantingFeature.addSyncType((ResourceLocation)InsaneSE.location("enchantments_data"), (JsonFeature.SyncType)new JsonFeature.SyncType(json -> EnchantingFeature.loadAndReadJson((String)json, enchantmentsData, DEFAULT_ENCHANTMENTS_DATA, (Type)EnchantmentData.LIST_TYPE)));
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("enchantments_data.json", enchantmentsData, DEFAULT_ENCHANTMENTS_DATA, EnchantmentData.LIST_TYPE, true, InsaneSE.location("enchantments_data")));
        EnchantingFeature.addSyncType((ResourceLocation)InsaneSE.location("over_level_enchantment_blacklist"), (JsonFeature.SyncType)new JsonFeature.SyncType(json -> EnchantingFeature.loadAndReadJson((String)json, overLevelEnchantmentBlacklist, DEFAULT_OVER_LEVEL_ENCHANTMENT_BLACKLIST, (Type)IdTagMatcher.LIST_TYPE)));
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("over_level_enchantment_blacklist.json", overLevelEnchantmentBlacklist, DEFAULT_OVER_LEVEL_ENCHANTMENT_BLACKLIST, IdTagMatcher.LIST_TYPE, true, InsaneSE.location("over_level_enchantment_blacklist")));
        EnchantingFeature.addSyncType((ResourceLocation)InsaneSE.location("starting_enchantments"), (JsonFeature.SyncType)new JsonFeature.SyncType(json -> EnchantingFeature.loadAndReadJson((String)json, startingEnchantments, DEFAULT_STARTING_ENCHANTMENTS, (Type)IdTagValue.LIST_TYPE)));
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("starting_enchantments.json", startingEnchantments, DEFAULT_STARTING_ENCHANTMENTS, IdTagValue.LIST_TYPE, true, InsaneSE.location("over_level_enchantment_blacklist")));
    }

    public String getModConfigFolder() {
        return "config/insanesurvivaloverhaul";
    }

    public void loadJsonConfigs() {
        super.loadJsonConfigs();
        if (!this.isEnabled()) {
            return;
        }
        if (ModList.get().isLoaded("allurement") && allurementIntegration.booleanValue()) {
            AllurementConfig.COMMON.cheapItemRenaming.set((Object)false);
            AllurementConfig.COMMON.removeTooExpensive.set((Object)false);
            AllurementConfig.COMMON.anvilIngotRepairing.set((Object)false);
            AllurementConfig.COMMON.capAnvilCosts.set((Object)false);
            AllurementConfig.COMMON.enchantableHorseArmor.set((Object)false);
            AllurementConfig.COMMON.enchantedHorseArmorGenerates.set((Object)false);
            AllurementConfig.COMMON.enableVengeance.set((Object)false);
            AllurementConfig.COMMON.alleviatingHealingFactor.set((Object)0.2);
        }
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS.getValues()) {
            if (EnchantmentsFeature.isEnchantmentDisabled((Enchantment)enchantment)) continue;
            int maxLvl = enchantment.m_6586_();
            if (maxLvl > 1 && EnchantingFeature.canOverLevel(enchantment)) {
                ++maxLvl;
            }
            StringBuilder costs = new StringBuilder();
            for (int i = 1; i <= maxLvl; ++i) {
                costs.append(EnchantingFeature.getCost(enchantment, i, true)).append(" ");
            }
            LogHelper.debug("%s %d (%s) %s", ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment).toString(), maxLvl, costs, enchantment.m_6591_());
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        this.preventMergingEnchantedItems(event);
        this.preventMergingEnchantedBooks(event);
        this.purifyItem(event);
        this.fixLegacyEmpowered(event);
    }

    public void fixLegacyEmpowered(AnvilUpdateEvent event) {
        if (event.getLeft().m_41783_() != null && event.getLeft().m_41783_().m_128471_(EMPOWERED_ITEM_LEGACY) && event.getRight().m_150930_(Items.f_42534_) && event.getRight().m_41613_() == 1) {
            ItemStack output = event.getLeft().m_41777_();
            output.m_41783_().m_128473_(EMPOWERED_ITEM_LEGACY);
            ModNBTData.put((ItemStack)output, (ResourceLocation)PURIFIED_ITEM, (Object)true);
            event.setOutput(output);
        }
    }

    public void preventMergingEnchantedItems(AnvilUpdateEvent event) {
        if (!noEnchantmentMerge.booleanValue()) {
            return;
        }
        if (event.getRight().m_41793_()) {
            event.setCanceled(true);
        }
    }

    public void preventMergingEnchantedBooks(AnvilUpdateEvent event) {
        if (!preventMergingBooks.booleanValue()) {
            return;
        }
        if (event.getLeft().m_150930_(Items.f_42690_) && !event.getRight().m_41619_()) {
            event.setCanceled(true);
        }
    }

    public void purifyItem(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        if (!enablePurifyItems.booleanValue() || !left.m_41720_().m_8120_(left) || EnchantingFeature.isPurified(left)) {
            return;
        }
        ItemStack right = event.getRight().m_41777_();
        if (!right.m_150930_(Items.f_42612_)) {
            return;
        }
        event.setCost(0);
        event.setMaterialCost(1);
        ItemStack result = left.m_41777_();
        ModNBTData.put((ItemStack)result, (ResourceLocation)PURIFIED_ITEM, (Object)true);
        event.setOutput(result);
    }

    @SubscribeEvent
    public void onGrindstoneTake(GrindstoneEvent.OnTakeItem event) {
        if (!this.isEnabled() || !grindstoneBetterXp.booleanValue() || EnchantingFeature.onExtractEnchantments(event)) {
            return;
        }
        float lvl = 0.0f;
        for (Map.Entry enchantment : EnchantmentHelper.m_44831_((ItemStack)event.getTopItem()).entrySet()) {
            lvl += (float)EnchantingFeature.getCost((Enchantment)enchantment.getKey(), (Integer)enchantment.getValue());
        }
        for (Map.Entry enchantment : EnchantmentHelper.m_44831_((ItemStack)event.getBottomItem()).entrySet()) {
            lvl += (float)EnchantingFeature.getCost((Enchantment)enchantment.getKey(), (Integer)enchantment.getValue());
        }
        lvl = (int)Math.floor(lvl);
        event.setXp((int)(lvl * (float)PlayerExperience.getBetterScalingLevel((int)30) * EnchantingFeature.getGrindstonePercentageXpGiven()));
    }

    public static boolean onExtractEnchantments(GrindstoneEvent.OnTakeItem event) {
        if (!(grindstoneTreasureEnchantmentExtraction.booleanValue() && event.getTopItem().m_41793_() && event.getBottomItem().m_150930_(Items.f_42517_))) {
            return false;
        }
        if (EnchantingFeature.isPurified(event.getTopItem())) {
            ItemStack topItem = event.getTopItem().m_41777_();
            topItem.m_41783_().m_128473_("Enchantments");
            event.setNewTopItem(topItem);
        }
        return true;
    }

    public static float getGrindstonePercentageXpGiven() {
        return 0.75f;
    }

    @SubscribeEvent
    public void onGrindstoneUpdate(GrindstoneEvent.OnPlaceItem event) {
        if (!this.isEnabled()) {
            return;
        }
        EnchantingFeature.extractEnchantments(event);
        EnchantingFeature.resetLodestoneCompass(event);
        EnchantingFeature.removeAllEnchantments(event);
        if (enchantingTableOneTimeUseEnchantments.booleanValue() && !event.getTopItem().m_41619_() && event.getBottomItem().m_41619_() || event.getTopItem().m_41619_() && !event.getBottomItem().m_41619_()) {
            event.setCanceled(true);
        }
    }

    public static void extractEnchantments(GrindstoneEvent.OnPlaceItem event) {
        if (!(grindstoneTreasureEnchantmentExtraction.booleanValue() && event.getTopItem().m_41793_() && event.getBottomItem().m_150930_(Items.f_42517_) && event.getBottomItem().m_41613_() <= 1)) {
            return;
        }
        ItemStack output = new ItemStack((ItemLike)Items.f_42690_);
        for (Map.Entry enchantmentInstance : EnchantmentHelper.m_44831_((ItemStack)event.getTopItem()).entrySet()) {
            if (!((Enchantment)enchantmentInstance.getKey()).m_6591_() && !grindstoneEnchantmentExtraction.booleanValue()) continue;
            EnchantedBookItem.m_41153_((ItemStack)output, (EnchantmentInstance)new EnchantmentInstance((Enchantment)enchantmentInstance.getKey(), ((Integer)enchantmentInstance.getValue()).intValue()));
        }
        if (EnchantingFeature.isPurified(event.getTopItem())) {
            ModNBTData.put((ItemStack)output, (ResourceLocation)PURIFIED_ITEM, (Object)true);
        }
        event.setOutput(output);
        event.setXp(0);
    }

    public static void resetLodestoneCompass(GrindstoneEvent.OnPlaceItem event) {
        if (!(event.getTopItem().m_150930_(Items.f_42522_) && CompassItem.m_40736_((ItemStack)event.getTopItem()) && event.getBottomItem().m_41619_())) {
            return;
        }
        ItemStack output = new ItemStack((ItemLike)Items.f_42522_);
        event.setOutput(output);
        event.setXp(0);
    }

    public static void removeAllEnchantments(GrindstoneEvent.OnPlaceItem event) {
        ItemStack output;
        if (!grindstoneCurseRemoval.booleanValue()) {
            return;
        }
        if (event.getBottomItem().m_41619_() && event.getTopItem().m_41619_()) {
            return;
        }
        if (!event.getBottomItem().m_41619_() && !event.getTopItem().m_41619_()) {
            return;
        }
        ItemStack itemStack = output = event.getBottomItem().m_41619_() ? event.getTopItem().m_41777_() : event.getBottomItem().m_41777_();
        if (output.m_41619_() || !output.m_41793_()) {
            return;
        }
        output.m_41783_().m_128473_("Enchantments");
        event.setOutput(output);
    }

    public static int getCost(Enchantment enchantment, int lvl, boolean checkCurses) {
        if (lvl <= 0 || enchantment.m_6589_() && !checkCurses) {
            return 0;
        }
        float vanillaCost = Anvils.getRarityCost((Enchantment)enchantment);
        EnchantmentData enchantmentData = enchantmentsData.stream().filter(data -> data.enchantment.matchesEnchantment(enchantment)).findFirst().orElse(null);
        if (enchantmentData != null) {
            int cost = enchantmentData.getCost(lvl);
            if (cost > 0) {
                return cost;
            }
            LogHelper.warn("Enchantment data for %s lvl %s is missing. Using default formula", ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment), lvl);
        } else {
            LogHelper.warn("Enchantment data for %s is missing. Using default formula", ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment));
        }
        return Math.round(vanillaCost * (float)lvl);
    }

    public static int getCost(Enchantment enchantment, int lvl) {
        return EnchantingFeature.getCost(enchantment, lvl, false);
    }

    public static boolean canBeEnchanted(ItemStack stack) {
        return stack.m_41720_().m_8120_(stack) && (!stack.m_41793_() || EnchantingFeature.hasOnlyCurses(stack)) && !stack.m_204117_(NOT_ENCHANTABLE);
    }

    public static boolean hasOnlyCurses(ItemStack stack) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (enchantments.isEmpty()) {
            return false;
        }
        for (Map.Entry enchantment : enchantments.entrySet()) {
            if (((Enchantment)enchantment.getKey()).m_6589_()) continue;
            return false;
        }
        return true;
    }

    public static boolean hasCurses(ItemStack stack) {
        if (!stack.m_41793_()) {
            return false;
        }
        for (Map.Entry enchantment : stack.getAllEnchantments().entrySet()) {
            if (!((Enchantment)enchantment.getKey()).m_6589_()) continue;
            return true;
        }
        return false;
    }

    public static float getCurseCost(ItemStack stack) {
        float cost = 0.0f;
        for (Map.Entry enchantment : stack.getAllEnchantments().entrySet()) {
            if (!((Enchantment)enchantment.getKey()).m_6589_()) continue;
            cost += (float)EnchantingFeature.getCost((Enchantment)enchantment.getKey(), 1, true);
        }
        return cost;
    }

    public static boolean isConsumedOnEnchant(Enchantment enchantment) {
        return enchantment.m_6589_() || enchantingTableOneTimeUseEnchantments != false;
    }

    public static boolean hasEnchantGlintOnly(ItemStack stack) {
        ListTag enchantments = stack.m_41785_();
        if (enchantments.isEmpty()) {
            return false;
        }
        return enchantments.size() == 1 && enchantments.m_128728_(0).m_128456_();
    }

    public static boolean canOverLevel(Enchantment enchantment) {
        for (IdTagMatcher idTagMatcher : overLevelEnchantmentBlacklist) {
            if (!idTagMatcher.matchesEnchantment(enchantment)) continue;
            return false;
        }
        return true;
    }

    public static List<EnchantmentInstance> getPendingEnchantments(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return Collections.emptyList();
        }
        ArrayList<EnchantmentInstance> pendingEnchantments = new ArrayList<EnchantmentInstance>();
        ListTag enchantmentsListTag = stack.m_41783_().m_128437_("PendingEnchantments", 10);
        for (int i = 0; i < enchantmentsListTag.size(); ++i) {
            CompoundTag compoundtag = enchantmentsListTag.m_128728_(i);
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)compoundtag.m_128461_("id")));
            short lvl = compoundtag.m_128448_("lvl");
            if (enchantment == null) continue;
            pendingEnchantments.add(new EnchantmentInstance(enchantment, (int)lvl));
        }
        return pendingEnchantments;
    }

    public static void removePendingEnchantment(ItemStack stack, Enchantment enchantment) {
        if (stack.m_41783_() == null) {
            return;
        }
        CompoundTag toRemove = null;
        ListTag enchantmentsListTag = stack.m_41783_().m_128437_("PendingEnchantments", 10);
        for (int i = 0; i < enchantmentsListTag.size(); ++i) {
            CompoundTag compoundtag = enchantmentsListTag.m_128728_(i);
            Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)compoundtag.m_128461_("id")));
            if (ench == null || ench != enchantment) continue;
            toRemove = compoundtag;
            break;
        }
        if (toRemove != null) {
            enchantmentsListTag.remove(toRemove);
        }
    }

    public static void clearPendingEnchantments(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return;
        }
        stack.m_41783_().m_128473_("PendingEnchantments");
    }

    public static boolean isStartingEnchantment(Enchantment enchantment) {
        for (IdTagValue idTagValue : startingEnchantments) {
            if (!idTagValue.id.matchesEnchantment(enchantment)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPurified(ItemStack stack) {
        return stack.m_41783_() != null && (Boolean)ModNBTData.get((ItemStack)stack, (ResourceLocation)PURIFIED_ITEM, Boolean.class) != false;
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (!EnchantingFeature.isEnabled(EnchantingFeature.class) || !(event.getEntity() instanceof Player)) {
            return;
        }
        EnchantingFeature.treasureEnchantmentsEnchantedBooksTooltip(stack, event.getToolTip());
        Minecraft mc = Minecraft.m_91087_();
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(EMPOWERED_ITEM_LEGACY)) {
            event.getToolTip().add(Component.m_237113_((String)"This item contains legacy data. Place in an anvil to upgrade").m_130940_(ChatFormatting.GOLD));
        }
        if (!(mc.f_91080_ instanceof AnvilScreen || mc.f_91080_ instanceof ISEEnchantingTableScreen || Screen.m_96638_())) {
            return;
        }
        EnchantingFeature.enchantabilityTooltip(stack, event.getToolTip());
        if (tag == null) {
            return;
        }
        EnchantingFeature.infusedEmpoweredTooltip(stack, tag, event.getToolTip());
        EnchantingFeature.pendingEnchantmentsTooltip(stack, tag, event.getToolTip());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void treasureEnchantmentsEnchantedBooksTooltip(ItemStack stack, List<Component> tooltip) {
        if (stack.m_150930_(Items.f_42690_)) {
            for (Map.Entry enchantment : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
                if (!((Enchantment)enchantment.getKey()).m_6591_() && !enchantingTableRequiresLearning.booleanValue()) continue;
                tooltip.add((Component)Component.m_237119_());
                tooltip.add((Component)Component.m_237115_((String)"iguanatweaksexpanded.apply_to_enchanting_table").m_130940_(ChatFormatting.GREEN));
                break;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void enchantabilityTooltip(ItemStack stack, List<Component> tooltip) {
        int enchantmentValue = EnchantmentsFeature.getEnchantmentValue((ItemStack)stack);
        if (enchantmentValue <= 0 || stack.m_204117_(NOT_ENCHANTABLE)) {
            return;
        }
        tooltip.add((Component)Component.m_237110_((String)"iguanatweaksexpanded.base_enchantability", (Object[])new Object[]{enchantmentValue}).m_130940_(ChatFormatting.LIGHT_PURPLE));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void infusedEmpoweredTooltip(ItemStack stack, CompoundTag tag, List<Component> tooltip) {
        if (EnchantingFeature.isPurified(stack)) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add(PURIFIED_COMPONENT);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void pendingEnchantmentsTooltip(ItemStack stack, CompoundTag tag, List<Component> tooltip) {
        if (tag.m_128441_("PendingEnchantments") && EnchantingFeature.canBeEnchanted(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"iguanatweaksexpanded.has_pending_enchantments").m_130940_(ChatFormatting.DARK_GRAY));
            if (Minecraft.m_91087_().f_91080_ instanceof ISEEnchantingTableScreen) {
                ListTag enchantmentsListTag = tag.m_128437_("PendingEnchantments", 10);
                for (int i = 0; i < enchantmentsListTag.size(); ++i) {
                    CompoundTag compoundtag = enchantmentsListTag.m_128728_(i);
                    Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)compoundtag.m_128461_("id")));
                    if (enchantment == null) continue;
                    short lvl = compoundtag.m_128448_("lvl");
                    MutableComponent mutablecomponent = CommonComponents.m_264333_().m_7220_((Component)Component.m_237115_((String)enchantment.m_44704_())).m_130940_(ChatFormatting.DARK_GRAY);
                    if (lvl != 1 || enchantment.m_6586_() != 1) {
                        mutablecomponent.m_7220_(CommonComponents.f_263701_).m_7220_((Component)Component.m_237115_((String)("enchantment.level." + lvl)));
                    }
                    tooltip.add((Component)mutablecomponent);
                }
            }
        }
    }
}

