/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.experience.enchanting;

import com.mojang.blaze3d.systems.RenderSystem;
import insane96mcp.iguanatweaksexpanded.module.experience.enchanting.EnchantingFeature;
import insane96mcp.iguanatweaksexpanded.module.experience.enchanting.ISEEnchantingTableMenu;
import insane96mcp.iguanatweaksexpanded.network.message.SyncISEEnchantingTableEnchantments;
import insane96mcp.iguanatweaksreborn.module.experience.DroppedExperience;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.EnchantmentsFeature;
import insane96mcp.insanelib.InsaneLib;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ISEEnchantingTableScreen
extends AbstractContainerScreen<ISEEnchantingTableMenu> {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("iguanatweaksexpanded", "textures/gui/container/enchanting_table.png");
    static final int CATALYST_SLOT_X = 38;
    static final int CATALYST_SLOT_Y = 19;
    static final int BUTTON_X = 9;
    static final int BUTTON_Y = 41;
    static final int BUTTON_U = 0;
    static final int BUTTON_V = 200;
    static final int BUTTON_W = 56;
    static final int BUTTON_H = 16;
    static final int EXP_ORB_U = 0;
    static final int EXP_ORB_V = 246;
    static final int EXP_ORB_W = 10;
    static final int EXP_ORB_H = 10;
    static final int SCROLL_BUTTON_U = 168;
    static final int SCROLL_BUTTON_V = 200;
    static final int SCROLL_BUTTON_W = 12;
    static final int SCROLL_BUTTON_H = 7;
    static final int LIST_X = 70;
    static final int LIST_Y = 23;
    static final int ENCH_ENTRY_V = 218;
    static final int LVL_BTN_W = 9;
    static final int LOWER_LVL_BTN_U = 0;
    static final int ENCH_DISPLAY_U = 9;
    static final int ENCH_DISPLAY_W = 136;
    static final int ENCH_LVL_U = 145;
    static final int ENCH_LVL_W = 17;
    static final int RISE_LVL_BTN_U = 145;
    static final int ENCH_ENTRY_W = 171;
    static final int ENCH_ENTRY_H = 14;
    private final List<EnchantmentEntry> enchantmentEntries = new ArrayList<EnchantmentEntry>();
    private ScrollButton scrollUpBtn;
    private ScrollButton scrollDownBtn;
    private ItemStack lastStack = ItemStack.f_41583_;
    private int maxCost = 0;
    public Map<Enchantment, Integer> learnedEnchantments = new HashMap<Enchantment, Integer>();
    public boolean forceUpdateEnchantmentsList;
    private int scroll = 0;

    public ISEEnchantingTableScreen(ISEEnchantingTableMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 234;
        this.f_97727_ = 194;
        this.f_97730_ += 29;
        this.f_97731_ += 20;
    }

    protected void m_7856_() {
        super.m_7856_();
        int topLeftCornerX = (this.f_96543_ - this.f_97726_) / 2;
        int topLeftCornerY = (this.f_96544_ - this.f_97727_) / 2;
        this.updateMaxCost();
        this.scrollUpBtn = new ScrollButton(topLeftCornerX + 70 + 85 - 12, topLeftCornerY + 23 - 7 - 2, 12, 7, ScrollButton.Type.UP);
        this.scrollUpBtn.f_93623_ = false;
        this.scrollDownBtn = new ScrollButton(topLeftCornerX + 70 + 85 - 12, topLeftCornerY + 23 + 56 + 2, 12, 7, ScrollButton.Type.DOWN);
        this.scrollDownBtn.f_93623_ = false;
        this.m_142416_((GuiEventListener)new MaxLvl(topLeftCornerX + 9, topLeftCornerY + 41 + 16 + 4, this.f_96547_).m_267729_());
    }

    private void updatePossibleEnchantments() {
        ItemStack stack = this.getItem();
        this.updateMaxCost();
        if ((ItemStack.m_150942_((ItemStack)stack, (ItemStack)this.lastStack) || !EnchantingFeature.canBeEnchanted(stack) && !stack.m_41619_()) && !this.forceUpdateEnchantmentsList) {
            return;
        }
        this.forceUpdateEnchantmentsList = false;
        this.lastStack = stack.m_41777_();
        ArrayList enchantments = new ArrayList();
        this.enchantmentEntries.clear();
        ArrayList<Enchantment> availableEnchantments = new ArrayList<Enchantment>();
        if (!stack.m_41619_() && !EnchantingFeature.canBeEnchanted(stack)) {
            this.scrollUpBtn.f_93623_ = false;
            this.scrollDownBtn.f_93623_ = false;
            return;
        }
        for (Enchantment enchantment2 : ForgeRegistries.ENCHANTMENTS) {
            if (EnchantingFeature.enchantingTableRequiresLearning.booleanValue() && !this.learnedEnchantments.containsKey(enchantment2) || EnchantmentsFeature.isEnchantmentDisabled((Enchantment)enchantment2)) continue;
            if (this.shouldShowKnownEnchantments()) {
                availableEnchantments.add(enchantment2);
            }
            if ((enchantment2.m_6591_() || !enchantment2.canApplyAtEnchantingTable(stack)) && (!this.learnedEnchantments.containsKey(enchantment2) || !enchantment2.canApplyAtEnchantingTable(stack))) continue;
            availableEnchantments.add(enchantment2);
        }
        availableEnchantments.stream().sorted(Comparator.comparing(enchantment -> {
            Object name = Component.m_237115_((String)enchantment.m_44704_()).getString();
            if (enchantment.m_6589_()) {
                name = "_" + (String)name;
            }
            return name;
        })).forEach(enchantment -> enchantments.add(new EnchantmentInstance(enchantment, this.learnedEnchantments.getOrDefault(enchantment, 0).intValue())));
        int topLeftCornerX = (this.f_96543_ - this.f_97726_) / 2;
        int topLeftCornerY = (this.f_96544_ - this.f_97727_) / 2;
        for (int i = 0; i < enchantments.size(); ++i) {
            EnchantmentInstance instance = (EnchantmentInstance)enchantments.get(i);
            int maxLvl = instance.f_44948_;
            this.enchantmentEntries.add(new EnchantmentEntry(topLeftCornerX + 70, topLeftCornerY + 23 + i * 14, instance.f_44947_, maxLvl));
        }
        List<EnchantmentInstance> pendingEnchantments = EnchantingFeature.getPendingEnchantments(stack);
        if (!pendingEnchantments.isEmpty()) {
            for (EnchantmentEntry enchantmentEntry : this.enchantmentEntries) {
                Optional<EnchantmentInstance> oInstance = pendingEnchantments.stream().filter(pendingEnchantment -> enchantmentEntry.enchantmentDisplay.enchantment.equals(pendingEnchantment.f_44947_)).findAny();
                oInstance.ifPresent(pendingEnchantment -> {
                    enchantmentEntry.enchantmentDisplay.setLvl(pendingEnchantment.f_44948_);
                    enchantmentEntry.updateActiveState();
                });
            }
        }
        this.scroll(0);
    }

    private float getCurrentCost() {
        float cost = 0.0f;
        for (EnchantmentEntry enchantmentEntry : this.enchantmentEntries) {
            int lvl = enchantmentEntry.enchantmentDisplay.lvl;
            if (lvl <= 0) continue;
            cost += (float)EnchantingFeature.getCost(enchantmentEntry.enchantmentDisplay.enchantment, lvl);
        }
        float decimalPart = cost - (float)((int)cost);
        if (decimalPart < 0.1f) {
            cost = (int)cost;
        }
        return cost;
    }

    private int getLapisCost() {
        int cost = 0;
        for (EnchantmentEntry enchantmentEntry : this.enchantmentEntries) {
            cost += enchantmentEntry.enchantmentDisplay.lvl;
        }
        return cost;
    }

    private void updateMaxCost() {
        this.maxCost = ((ISEEnchantingTableMenu)this.f_97732_).maxCost.m_6501_();
        ItemStack stack = this.getItem();
        if (stack.m_41619_()) {
            this.maxCost = 0;
            return;
        }
        if (!EnchantingFeature.canBeEnchanted(stack) && !this.forceUpdateEnchantmentsList) {
            return;
        }
        EnchantingFeature.getPendingEnchantments(stack).forEach(enchantmentInstance -> {
            boolean found = false;
            for (EnchantmentEntry enchantmentEntry : this.enchantmentEntries) {
                if (!enchantmentEntry.enchantmentDisplay.enchantment.equals(enchantmentInstance.f_44947_)) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
            if (enchantmentInstance.f_44947_.m_6589_()) {
                this.maxCost += EnchantingFeature.getCost(enchantmentInstance.f_44947_, enchantmentInstance.f_44948_, true);
            }
        });
    }

    private boolean isItemPurified() {
        return EnchantingFeature.isPurified(this.getItem());
    }

    private ItemStack getItem() {
        return ((ISEEnchantingTableMenu)this.f_97732_).m_38853_(0).m_7993_();
    }

    private boolean hasItem() {
        return !this.getItem().m_41619_();
    }

    private boolean hasEnchantment(Enchantment enchantment) {
        return EnchantmentHelper.getTagEnchantmentLevel((Enchantment)enchantment, (ItemStack)this.getItem()) > 0;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        int topLeftCornerX = (this.f_96543_ - this.f_97726_) / 2;
        int topLeftCornerY = (this.f_96544_ - this.f_97727_) / 2;
        double x = pMouseX - (double)(topLeftCornerX + 9);
        double y = pMouseY - (double)(topLeftCornerY + 41);
        if (this.isButtonEnabled() && x >= 0.0 && y >= 0.0 && x < 56.0 && y < 16.0 && ((ISEEnchantingTableMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, 0)) {
            this.f_96541_.f_91072_.m_105208_(((ISEEnchantingTableMenu)this.f_97732_).f_38840_, 0);
            this.enchantmentEntries.clear();
            this.maxCost = 0;
            return true;
        }
        for (EnchantmentEntry enchantmentEntry : this.enchantmentEntries) {
            enchantmentEntry.levelDownBtn.m_6375_(pMouseX, pMouseY, pButton);
            enchantmentEntry.levelUpBtn.m_6375_(pMouseX, pMouseY, pButton);
        }
        this.scrollUpBtn.m_6375_(pMouseX, pMouseY, pButton);
        this.scrollDownBtn.m_6375_(pMouseX, pMouseY, pButton);
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int topLeftCornerX = (this.f_96543_ - this.f_97726_) / 2;
        int topLeftCornerY = (this.f_96544_ - this.f_97727_) / 2;
        int x = pMouseX - (topLeftCornerX + 9);
        int y = pMouseY - (topLeftCornerY + 41);
        pGuiGraphics.m_280218_(TEXTURE_LOCATION, topLeftCornerX, topLeftCornerY, 0, 0, this.f_97726_, this.f_97727_);
        if (!this.isButtonEnabled()) {
            pGuiGraphics.m_280218_(TEXTURE_LOCATION, topLeftCornerX + 9, topLeftCornerY + 41, 56, 200, 56, 16);
        } else if (x >= 0 && y >= 0 && x < 56 && y < 16) {
            pGuiGraphics.m_280218_(TEXTURE_LOCATION, topLeftCornerX + 9, topLeftCornerY + 41, 112, 200, 56, 16);
        } else {
            pGuiGraphics.m_280218_(TEXTURE_LOCATION, topLeftCornerX + 9, topLeftCornerY + 41, 0, 200, 56, 16);
        }
    }

    private boolean isButtonEnabled() {
        if (this.getItem().m_41619_() || !EnchantingFeature.canBeEnchanted(this.getItem())) {
            return false;
        }
        float cost = this.getCurrentCost();
        if (cost <= 0.0f) {
            return false;
        }
        if (!this.f_96541_.f_91074_.m_150110_().f_35937_) {
            for (EnchantmentEntry enchantmentEntry : this.enchantmentEntries) {
                if (enchantmentEntry.enchantmentDisplay.lvl <= enchantmentEntry.enchantmentDisplay.getMaxLvl()) continue;
                return false;
            }
        }
        boolean hasEnoughExp = (float)this.f_96541_.f_91074_.f_36078_ >= cost || DroppedExperience.disableExperience != false;
        boolean hasEnoughLapis = ((ISEEnchantingTableMenu)this.f_97732_).m_38853_(1).m_7993_().m_41613_() >= this.getLapisCost();
        return hasEnoughExp && hasEnoughLapis && cost <= (float)this.maxCost || this.f_96541_.f_91074_.m_150110_().f_35937_;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int topLeftCornerX = (this.f_96543_ - this.f_97726_) / 2;
        int topLeftCornerY = (this.f_96544_ - this.f_97727_) / 2;
        this.updatePossibleEnchantments();
        for (EnchantmentEntry entry : this.enchantmentEntries) {
            entry.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        ItemStack stack = this.getItem();
        if ((EnchantingFeature.canBeEnchanted(stack) || stack.m_41619_()) && this.enchantmentEntries.isEmpty()) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"iguanatweaksexpanded.enchanting_table.no_enchantments_available").m_130940_(ChatFormatting.UNDERLINE), topLeftCornerX + 70 + 85 - 12, topLeftCornerY + 23, 0xFFAA00);
            if (mouseX >= topLeftCornerX + 70 && mouseX <= topLeftCornerX + 70 + 171 && mouseY >= topLeftCornerY + 23 && mouseY <= topLeftCornerY + 23 + 14) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"iguanatweaksexpanded.enchanting_table.no_enchantments_available.tooltip").m_130940_(ChatFormatting.GRAY), mouseX, mouseY);
            }
        }
        if (this.maxCost > 0) {
            int color;
            float cost = this.getCurrentCost();
            int n = color = (float)this.f_96541_.f_91074_.f_36078_ < cost && !this.f_96541_.f_91074_.m_7500_() && DroppedExperience.disableExperience == false ? 0xFF0000 : 0x11FF11;
            if (!EnchantingFeature.enchantingTableOneTimeUseEnchantments.booleanValue()) {
                if (this.isButtonEnabled()) {
                    guiGraphics.m_280218_(TEXTURE_LOCATION, topLeftCornerX + 9 + 3, topLeftCornerY + 41 + 3, 0, 246, 10, 10);
                } else {
                    guiGraphics.m_280218_(TEXTURE_LOCATION, topLeftCornerX + 9 + 3, topLeftCornerY + 41 + 3, 10, 246, 10, 10);
                }
            }
            int offset = EnchantingFeature.enchantingTableOneTimeUseEnchantments != false ? 0 : 6;
            String string = "%s".formatted(InsaneLib.ONE_DECIMAL_FORMATTER.format(cost));
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280137_(this.f_96547_, string, topLeftCornerX + 9 + 28 + offset, topLeftCornerY + 41 + 8 - 9 / 2, color);
            if (cost > 0.0f) {
                int lapis = this.getLapisCost();
                color = ((ISEEnchantingTableMenu)this.f_97732_).m_38853_(1).m_7993_().m_41613_() < lapis ? 0xFF0000 : 0x11FF11;
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
                String sLapis = "%d".formatted(lapis);
                guiGraphics.m_280488_(this.f_96547_, sLapis, topLeftCornerX + 38 + 16 - this.f_96547_.m_92895_(sLapis), topLeftCornerY + 19, color);
            }
        }
        this.scrollUpBtn.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.scrollDownBtn.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        this.scroll(-((int)(Screen.m_96638_() ? pDelta * 4.0 : pDelta)));
        return true;
    }

    public void scroll(int delta) {
        this.scroll = Mth.m_14045_((int)(this.scroll + delta), (int)0, (int)Math.max(this.enchantmentEntries.size() - 4, 0));
        this.updateEnchantmentEntryPositionAndVisibility();
        this.scrollUpBtn.f_93623_ = this.scroll > 0 && this.enchantmentEntries.size() > 4;
        this.scrollDownBtn.f_93623_ = this.scroll < this.enchantmentEntries.size() - 4 && this.enchantmentEntries.size() > 4;
    }

    private void updateEnchantmentEntryPositionAndVisibility() {
        int topLeftCornerY = (this.f_96544_ - this.f_97727_) / 2;
        for (int i = 0; i < this.enchantmentEntries.size(); ++i) {
            EnchantmentEntry enchantmentEntry = this.enchantmentEntries.get(i);
            enchantmentEntry.m_253211_(topLeftCornerY + 23 + (i - this.scroll) * enchantmentEntry.m_93694_());
            enchantmentEntry.setActive(i >= this.scroll && i < this.scroll + 4);
        }
    }

    public boolean shouldShowKnownEnchantments() {
        ItemStack stack = this.getItem();
        return stack.m_41619_();
    }

    private void syncEnchantments() {
        ArrayList<EnchantmentInstance> list = new ArrayList<EnchantmentInstance>();
        for (EnchantmentEntry enchantmentEntry : this.enchantmentEntries) {
            if (enchantmentEntry.enchantmentDisplay.lvl <= 0) continue;
            list.add(new EnchantmentInstance(enchantmentEntry.enchantmentDisplay.enchantment, enchantmentEntry.enchantmentDisplay.lvl));
        }
        SyncISEEnchantingTableEnchantments.sync(list);
    }

    private class ScrollButton
    extends AbstractWidget {
        final Type type;

        public ScrollButton(int pX, int pY, int pWidth, int pHeight, Type type) {
            super(pX, pY, pWidth, pHeight, (Component)Component.m_237119_());
            this.type = type;
        }

        protected void m_87963_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            if (!this.m_142518_()) {
                return;
            }
            guiGraphics.m_280218_(TEXTURE_LOCATION, this.m_252754_(), this.m_252907_(), 168 + this.getXOffset(), 200 + (this.type == Type.DOWN ? 7 : 0), 12, 7);
        }

        protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
        }

        public void m_5716_(double mouseX, double mouseY) {
            int amount = 1;
            if (Screen.m_96638_()) {
                amount = 4;
            }
            ISEEnchantingTableScreen.this.scroll(this.type == Type.DOWN ? amount : -amount);
        }

        private int getXOffset() {
            int i = 0;
            if (this.m_198029_()) {
                i = 1;
            }
            return i * this.f_93618_;
        }

        static enum Type {
            UP,
            DOWN;

        }
    }

    private class MaxLvl
    extends StringWidget {
        public MaxLvl(int x, int y, Font pFont) {
            super((Component)Component.m_237119_(), pFont);
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"iguanatweaksexpanded.enchanting_table.max_lvl_info")));
            this.m_252865_(x);
            this.m_253211_(y);
            this.m_93674_(56);
            this.setHeight(25);
        }

        public Component m_6035_() {
            if (ISEEnchantingTableScreen.this.maxCost == 0) {
                return super.m_6035_();
            }
            ChatFormatting color = ISEEnchantingTableScreen.this.getCurrentCost() > (float)ISEEnchantingTableScreen.this.maxCost ? ChatFormatting.RED : ChatFormatting.GREEN;
            return Component.m_237110_((String)"iguanatweaksexpanded.enchanting_table.max", (Object[])new Object[]{ISEEnchantingTableScreen.this.maxCost}).m_130940_(color);
        }

        @Nullable
        public Tooltip m_278622_() {
            return ISEEnchantingTableScreen.this.maxCost == 0 ? null : super.m_278622_();
        }
    }

    private class EnchantmentEntry
    extends AbstractWidget {
        public LevelBtn levelDownBtn;
        public EnchantmentDisplay enchantmentDisplay;
        public LevelBtn levelUpBtn;

        public EnchantmentEntry(int pX, int pY, Enchantment enchantment, int maxLvl) {
            super(pX, pY, 171, 14, (Component)Component.m_237119_());
            this.enchantmentDisplay = new EnchantmentDisplay(pX + 9, pY, enchantment, maxLvl);
            this.levelDownBtn = new LevelBtn(pX, pY, LevelBtn.Type.LOWER, this);
            this.levelUpBtn = new LevelBtn(pX + 145, pY, LevelBtn.Type.RISE, this);
            this.updateActiveState();
        }

        private void updateActiveState() {
            this.levelUpBtn.f_93623_ = this.enchantmentDisplay.canRiseLevel() && !ISEEnchantingTableScreen.this.getItem().m_41619_();
            this.levelDownBtn.f_93623_ = this.enchantmentDisplay.lvl > 0 && !ISEEnchantingTableScreen.this.getItem().m_41619_();
        }

        protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.levelDownBtn.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            this.enchantmentDisplay.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            this.levelUpBtn.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return this.levelDownBtn.m_6375_(mouseX, mouseY, button) || this.enchantmentDisplay.m_6375_(mouseX, mouseY, button) || this.levelUpBtn.m_6375_(mouseX, mouseY, button);
        }

        public void m_253211_(int pY) {
            super.m_253211_(pY);
            this.enchantmentDisplay.m_253211_(pY);
            this.levelUpBtn.m_253211_(pY);
            this.levelDownBtn.m_253211_(pY);
        }

        public void setActive(boolean active) {
            this.f_93624_ = active;
            this.enchantmentDisplay.f_93624_ = active;
            this.levelUpBtn.f_93624_ = active;
            this.levelDownBtn.f_93624_ = active;
        }

        protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
        }
    }

    private class EnchantmentDisplay
    extends AbstractWidget {
        public Enchantment enchantment;
        public int lvl;
        private final int storedLevels;

        public EnchantmentDisplay(int pX, int pY, Enchantment enchantment, int storedLevels) {
            super(pX, pY, 136, 14, (Component)(!enchantment.m_6589_() ? Component.m_237115_((String)enchantment.m_44704_()) : Component.m_237115_((String)enchantment.m_44704_()).m_130940_(ChatFormatting.RED)));
            this.enchantment = enchantment;
            this.lvl = ISEEnchantingTableScreen.this.getItem().m_41619_() ? storedLevels : 0;
            this.storedLevels = storedLevels;
        }

        protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            if (!this.m_142518_()) {
                this.m_257544_(null);
                return;
            }
            pGuiGraphics.m_280218_(TEXTURE_LOCATION, this.m_252754_(), this.m_252907_(), 9, 218 + this.getYOffset(), this.m_5711_(), this.m_93694_());
            this.m_280372_(pGuiGraphics, Minecraft.m_91087_().f_91062_, 1, 0xDDDDDD);
            MutableComponent lvlTxt = Component.m_237119_();
            if (this.lvl > 0) {
                if (EnchantingFeature.enchantingTableOneTimeUseEnchantments.booleanValue() && ((ISEEnchantingTableMenu)ISEEnchantingTableScreen.this.f_97732_).m_38853_(0).m_7993_().m_41619_()) {
                    lvlTxt = Component.m_237113_((String)("" + this.lvl));
                    if (this.lvl > 99) {
                        lvlTxt = Component.m_237113_((String)"99").m_130940_(ChatFormatting.BLUE);
                    }
                } else {
                    lvlTxt = Component.m_237115_((String)("enchantment.level." + Math.min(10, this.lvl)));
                    if (this.lvl == this.enchantment.m_6586_() && ISEEnchantingTableScreen.this.shouldShowKnownEnchantments() && !EnchantingFeature.isConsumedOnEnchant(this.enchantment)) {
                        lvlTxt.m_130940_(ChatFormatting.BLUE);
                    }
                }
            }
            pGuiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)lvlTxt, this.m_252754_() + 136 - 8 - 1, this.m_252907_() + 3, this.lvl > this.storedLevels ? 0xFF55FF : 0xDDDDDD);
            MutableComponent component = Component.m_237119_();
            boolean hasDesc = false;
            if ((Screen.m_96638_() || ISEEnchantingTableScreen.this.shouldShowKnownEnchantments()) && ModList.get().isLoaded("enchdesc")) {
                component.m_7220_((Component)Component.m_237115_((String)(this.enchantment.m_44704_() + ".desc")).m_130940_(ChatFormatting.LIGHT_PURPLE));
                hasDesc = true;
            }
            if (this.enchantment.m_6589_()) {
                if (hasDesc) {
                    component.m_7220_(CommonComponents.f_178388_);
                }
                this.m_257544_(Tooltip.m_257550_((Component)component.m_7220_((Component)Component.m_237110_((String)"iguanatweaksexpanded.enchanting_table.bonus_max_cost", (Object[])new Object[]{EnchantingFeature.getCost(this.enchantment, 1, true)}))));
            } else if (!ISEEnchantingTableScreen.this.shouldShowKnownEnchantments()) {
                if (hasDesc) {
                    component.m_7220_(CommonComponents.f_178388_);
                }
                this.m_257544_(Tooltip.m_257550_((Component)component.m_7220_((Component)Component.m_237110_((String)"iguanatweaksexpanded.enchanting_table.total_cost", (Object[])new Object[]{EnchantingFeature.getCost(this.enchantment, this.lvl)}))));
            } else {
                this.m_257544_(Tooltip.m_257550_((Component)component));
            }
        }

        protected void m_280372_(GuiGraphics pGuiGraphics, Font pFont, int pWidth, int pColor) {
            int i = this.m_252754_() + pWidth;
            int j = this.m_252754_() + this.m_5711_() - pWidth - 17;
            EnchantmentDisplay.m_280138_((GuiGraphics)pGuiGraphics, (Font)pFont, (Component)this.m_6035_(), (int)i, (int)this.m_252907_(), (int)j, (int)(this.m_252907_() + this.m_93694_()), (int)pColor);
        }

        public int getMaxLvl() {
            int maxLvl = Math.min(this.storedLevels, this.enchantment.m_6586_());
            if (this.enchantment.m_6586_() > 1 && ISEEnchantingTableScreen.this.isItemPurified() && EnchantingFeature.canOverLevel(this.enchantment) && (!EnchantingFeature.isConsumedOnEnchant(this.enchantment) || this.storedLevels >= maxLvl + 1)) {
                ++maxLvl;
            }
            return maxLvl;
        }

        public void rise() {
            if (this.canRiseLevel()) {
                ++this.lvl;
            }
        }

        public boolean canRiseLevel() {
            int maxLvl = this.getMaxLvl();
            boolean hasAlreadyEnchantment = ISEEnchantingTableScreen.this.hasEnchantment(this.enchantment);
            return this.lvl < maxLvl && !hasAlreadyEnchantment;
        }

        public void lower() {
            if (this.lvl > 0) {
                --this.lvl;
            }
        }

        public void setLvl(int lvl) {
            this.lvl = this.storedLevels > 0 ? Math.min(lvl, this.getMaxLvl()) : lvl;
        }

        private int getYOffset() {
            int i = 0;
            if (this.m_198029_()) {
                i = 1;
            }
            return i * this.f_93619_;
        }

        protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
        }
    }

    private class LevelBtn
    extends AbstractButton {
        Type type;
        EnchantmentEntry enchantmentEntry;

        public LevelBtn(int pX, int pY, Type type, EnchantmentEntry enchantmentEntry) {
            super(pX, pY, 9, 14, (Component)Component.m_237119_());
            this.type = type;
            this.enchantmentEntry = enchantmentEntry;
        }

        public void m_5691_() {
            if (!this.m_142518_()) {
                return;
            }
            if (this.type == Type.LOWER) {
                this.enchantmentEntry.enchantmentDisplay.lower();
            } else {
                this.enchantmentEntry.enchantmentDisplay.rise();
            }
            this.enchantmentEntry.updateActiveState();
            ISEEnchantingTableScreen.this.updateMaxCost();
            ISEEnchantingTableScreen.this.syncEnchantments();
        }

        protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (!this.m_142518_()) {
                this.m_257544_(null);
                return;
            }
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            guiGraphics.m_280218_(TEXTURE_LOCATION, this.m_252754_(), this.m_252907_(), this.type == Type.LOWER ? 0 : 145, 218 + this.getYOffset(), this.f_93618_, this.f_93619_);
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            Enchantment enchantment = this.enchantmentEntry.enchantmentDisplay.enchantment;
            if (enchantment.m_6589_()) {
                MutableComponent translatable = Component.m_237110_((String)"iguanatweaksexpanded.enchanting_table.level_btn_tooltip.curse", (Object[])new Object[]{EnchantingFeature.getCost(enchantment, 1, true)});
                if (EnchantingFeature.isConsumedOnEnchant(enchantment)) {
                    translatable.m_7220_(CommonComponents.f_178388_).m_7220_((Component)Component.m_237110_((String)"iguanatweaksexpanded.enchanting_table.available_levels", (Object[])new Object[]{this.enchantmentEntry.enchantmentDisplay.storedLevels}));
                }
                this.m_257544_(Tooltip.m_257550_((Component)translatable));
            } else {
                int currCost = EnchantingFeature.getCost(enchantment, this.enchantmentEntry.enchantmentDisplay.lvl);
                int newCost = EnchantingFeature.getCost(enchantment, this.enchantmentEntry.enchantmentDisplay.lvl + (this.type == Type.RISE ? 1 : -1));
                MutableComponent translatable = Component.m_237110_((String)"iguanatweaksexpanded.enchanting_table.level_btn_tooltip", (Object[])new Object[]{currCost, newCost});
                if (EnchantingFeature.isConsumedOnEnchant(enchantment)) {
                    translatable.m_7220_(CommonComponents.f_178388_).m_7220_((Component)Component.m_237110_((String)"iguanatweaksexpanded.enchanting_table.available_levels", (Object[])new Object[]{this.enchantmentEntry.enchantmentDisplay.storedLevels}));
                }
                this.m_257544_(Tooltip.m_257550_((Component)translatable));
            }
        }

        private int getYOffset() {
            int i = 0;
            if (this.m_198029_()) {
                i = 1;
            }
            return i * this.f_93619_;
        }

        protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
        }

        static enum Type {
            LOWER,
            RISE;

        }
    }
}

