/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.mining.forging;

import insane96mcp.iguanatweaksexpanded.InsaneSE;
import insane96mcp.iguanatweaksexpanded.module.mining.forging.ForgeBlock;
import insane96mcp.iguanatweaksexpanded.module.mining.forging.ForgeBlockEntity;
import insane96mcp.iguanatweaksexpanded.module.mining.forging.ForgeHammerItem;
import insane96mcp.iguanatweaksexpanded.module.mining.forging.ForgeMenu;
import insane96mcp.iguanatweaksexpanded.module.mining.forging.ForgeRecipe;
import insane96mcp.iguanatweaksexpanded.module.misc.ISEDataPacks;
import insane96mcp.iguanatweaksexpanded.setup.ISERegistries;
import insane96mcp.iguanatweaksexpanded.setup.registry.SimpleBlockWithItem;
import insane96mcp.iguanatweaksreborn.event.ISOLivingAttackEvent;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.EnchantmentsFeature;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegistryObject;

@LoadFeature(module="iguanatweaksexpanded:mining")
public class Forging
extends Feature {
    public static final SimpleBlockWithItem FORGE = SimpleBlockWithItem.register("forge", () -> new ForgeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50322_)));
    public static final RegistryObject<BlockEntityType<ForgeBlockEntity>> FORGE_BLOCK_ENTITY_TYPE = ISERegistries.BLOCK_ENTITY_TYPES.register("forge", () -> BlockEntityType.Builder.m_155273_(ForgeBlockEntity::new, (Block[])new Block[]{(Block)FORGE.block().get()}).m_58966_(null));
    public static final RegistryObject<RecipeType<ForgeRecipe>> FORGE_RECIPE_TYPE = ISERegistries.RECIPE_TYPES.register("forging", () -> new RecipeType<ForgeRecipe>(){

        public String toString() {
            return "forging";
        }
    });
    public static final RegistryObject<ForgeRecipe.ForgeRecipeSerializer> FORGE_RECIPE_SERIALIZER = ISERegistries.RECIPE_SERIALIZERS.register("forging", ForgeRecipe.ForgeRecipeSerializer::new);
    public static final RegistryObject<MenuType<ForgeMenu>> FORGE_MENU_TYPE = ISERegistries.MENU_TYPES.register("forge", () -> new MenuType(ForgeMenu::new, FeatureFlags.f_244377_));
    public static final RegistryObject<ForgeHammerItem> HAMMER = ISERegistries.ITEMS.register("forge_hammer", () -> new ForgeHammerItem((Tier)Tiers.IRON, 20, new Item.Properties()));
    @Config(description="Enchanted items can't be forged")
    public static Boolean unforgableEnchantedItems = true;
    @Config(description="Enables the following changes to vanilla data pack:\n* All metal gear requires a forge to be made\n* Diamond Gear requires Gold gear to be forged\n* Gold Gear requires Flint / Leather gear to be forged\n* Iron Gear requires Stone / Chained Copper gear to be forged\n* Buckets, Flint and Steel and Shears require a forge to be made")
    public static Boolean forgingEquipmentCraftingDataPack = true;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        InsaneSE.addServerPack("forging_equipment", "IguanaTweaks Expanded Forging Equipment", () -> this.isEnabled() && ISEDataPacks.disableAllDataPacks == false && forgingEquipmentCraftingDataPack != false);
    }

    @SubscribeEvent
    public void onHammerDamage(ISOLivingAttackEvent event) {
        LivingEntity attacker;
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity) || !(attacker = (LivingEntity)entity).m_21205_().m_150930_((Item)HAMMER.get()) || event.getEntity().m_9236_().f_46443_) {
            return;
        }
        event.getEntity().getPersistentData().m_128379_("iguanatweaksexpandedcancel_knockback", true);
        float attackStrengthScale = 1.0f;
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            attackStrengthScale = player.m_36403_(0.5f);
        }
        float range = 3.5f;
        float rangeSqr = range * range;
        for (LivingEntity livingEntity : event.getEntity().m_9236_().m_45976_(LivingEntity.class, event.getEntity().m_20191_().m_82377_((double)range, (double)(range / 2.0f), (double)range))) {
            ArmorStand armorStand;
            if (livingEntity == attacker || !livingEntity.m_20096_() || livingEntity.m_7307_((Entity)attacker) || livingEntity instanceof ArmorStand && (armorStand = (ArmorStand)livingEntity).m_31677_() || !(event.getEntity().m_20280_((Entity)livingEntity) < (double)rangeSqr)) continue;
            livingEntity.m_5997_(0.0, (double)(0.9f + Forging.getKnockbackBonus(attacker)) * (1.0 - livingEntity.m_21133_(Attributes.f_22278_)) * (double)attackStrengthScale * (double)attackStrengthScale, 0.0);
            if (!(livingEntity instanceof Player)) continue;
            Player player = (Player)livingEntity;
            player.f_19864_ = true;
        }
        event.getEntity().m_5496_(SoundEvents.f_11669_, 0.6f * attackStrengthScale * attackStrengthScale, 1.1f);
        ((ServerLevel)event.getEntity().m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50322_.f_49786_), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), 200, (double)(range / 2.0f), (double)(range / 4.0f), (double)(range / 2.0f), 1.0);
    }

    private static float getKnockbackBonus(LivingEntity entity) {
        return (float)Math.max(EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44980_, (LivingEntity)entity), EnchantmentHelper.m_44836_((Enchantment)((Enchantment)EnchantmentsFeature.KNOCKBACK.get()), (LivingEntity)entity)) * 0.15f;
    }

    @SubscribeEvent
    public void cancelKnockback(LivingKnockBackEvent event) {
        if (event.getEntity().getPersistentData().m_128471_("iguanatweaksexpandedcancel_knockback")) {
            event.setCanceled(true);
            event.getEntity().getPersistentData().m_128473_("iguanatweaksexpandedcancel_knockback");
        }
    }
}

