/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.data;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class ISERandomSpreadWithChance
extends StructurePlacement {
    public static final Codec<ISERandomSpreadWithChance> CODEC = RecordCodecBuilder.create(instance -> ISERandomSpreadWithChance.m_227041_((RecordCodecBuilder.Instance)instance).and(instance.group((App)RandomSpreadParams.CODEC.get().fieldOf("random_spread").forGetter(ISERandomSpreadWithChance::randomSpreadParams), (App)ChanceParams.CODEC.get().fieldOf("chance_data").forGetter(ISERandomSpreadWithChance::chanceParams))).apply((Applicative)instance, ISERandomSpreadWithChance::new));
    RandomSpreadParams randomSpreadParams;
    ChanceParams chanceParams;

    public ISERandomSpreadWithChance(Vec3i locateOffset, StructurePlacement.FrequencyReductionMethod frequencyReductionMethod, float frequency, int salt, Optional<StructurePlacement.ExclusionZone> exclusionZone, RandomSpreadParams randomSpreadParams, ChanceParams chanceParams) {
        super(locateOffset, frequencyReductionMethod, frequency, salt, exclusionZone);
        this.randomSpreadParams = randomSpreadParams;
        this.chanceParams = chanceParams;
    }

    public RandomSpreadParams randomSpreadParams() {
        return this.randomSpreadParams;
    }

    public ChanceParams chanceParams() {
        return this.chanceParams;
    }

    public ChunkPos getPotentialStructureChunk(long p_227009_, int p_227010_, int p_227011_) {
        int i = Math.floorDiv(p_227010_, this.randomSpreadParams.spacing);
        int j = Math.floorDiv(p_227011_, this.randomSpreadParams.spacing);
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_190058_(p_227009_, i, j, this.m_227075_());
        int k = this.randomSpreadParams.spacing - this.randomSpreadParams.separation;
        int l = this.randomSpreadParams.spreadType.m_227018_((RandomSource)worldgenrandom, k);
        int i1 = this.randomSpreadParams.spreadType.m_227018_((RandomSource)worldgenrandom, k);
        return new ChunkPos(i * this.randomSpreadParams.spacing + l, j * this.randomSpreadParams.spacing + i1);
    }

    public boolean m_255071_(ChunkGeneratorStructureState chunkGeneratorStructureState, int chunkX, int chunkZ) {
        if (!this.m_227073_().m_227119_(chunkGeneratorStructureState.m_254887_(), this.m_227075_(), chunkX, chunkZ, this.chanceParams.getChanceAt(chunkX, chunkZ))) {
            return false;
        }
        return super.m_255071_(chunkGeneratorStructureState, chunkX, chunkZ);
    }

    protected boolean m_214090_(ChunkGeneratorStructureState p_256267_, int p_256050_, int p_255975_) {
        ChunkPos chunkpos = this.getPotentialStructureChunk(p_256267_.m_254887_(), p_256050_, p_255975_);
        return chunkpos.f_45578_ == p_256050_ && chunkpos.f_45579_ == p_255975_;
    }

    public StructurePlacementType<?> m_203443_() {
        return StructurePlacementType.f_205041_;
    }

    public record RandomSpreadParams(int spacing, int separation, RandomSpreadType spreadType) {
        public static final Supplier<Codec<RandomSpreadParams>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(RandomSpreadParams::spacing), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(RandomSpreadParams::separation), (App)RandomSpreadType.f_205014_.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(RandomSpreadParams::spreadType)).apply((Applicative)instance, RandomSpreadParams::new)).flatXmap(p_275182_ -> p_275182_.spacing <= p_275182_.separation ? DataResult.error(() -> "Spacing has to be larger than separation") : DataResult.success((Object)p_275182_), DataResult::success).codec());
    }

    public record ChanceParams(int startRange, int endRange, float multiplierAtStart) {
        public static final Supplier<Codec<ChanceParams>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("start_range", (Object)0).forGetter(ChanceParams::startRange), (App)Codec.INT.fieldOf("end_range").forGetter(ChanceParams::endRange), (App)Codec.FLOAT.optionalFieldOf("multiplier_at_start", (Object)Float.valueOf(0.0f)).forGetter(ChanceParams::multiplierAtStart)).apply((Applicative)instance, ChanceParams::new)).codec());

        public float getChanceAt(int chunkX, int chunkY) {
            int x = chunkX * 16;
            int z = chunkY * 16;
            int distanceFromOrigin = (int)Math.sqrt(x * x + z * z);
            int distanceFromStart = distanceFromOrigin - this.startRange;
            return (float)(this.endRange - distanceFromStart) / ((float)this.endRange - (float)this.startRange) * (1.0f - this.multiplierAtStart);
        }
    }
}

