/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.experience.enchanting;

import insane96mcp.iguanatweaksexpanded.module.experience.enchanting.EnchantingFeature;
import insane96mcp.iguanatweaksexpanded.module.experience.enchanting.ISEEnchantingTableMenu;
import insane96mcp.iguanatweaksexpanded.network.message.SyncISEEnchantingTableStatus;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ISEEnchantingTableBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    public float rot;
    public float oRot;
    public float tRot;
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    public Map<Enchantment, Integer> knownEnchantments = new HashMap<Enchantment, Integer>();
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    protected ISEEnchantingTableBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)EnchantingFeature.ENCHANTING_TABLE_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        ListTag listTag = tag.m_128437_("learned_enchantments", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag = listTag.m_128728_(i);
            String enchantmentId = compoundTag.m_128461_("id");
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)enchantmentId));
            if (enchantment == null) continue;
            int lvl = compoundTag.m_128451_("lvl");
            this.knownEnchantments.put(enchantment, lvl);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        ListTag listTag = new ListTag();
        for (Map.Entry<Enchantment, Integer> learnedEnchantment : this.knownEnchantments.entrySet()) {
            ResourceLocation enchantmentId = ForgeRegistries.ENCHANTMENTS.getKey((Object)learnedEnchantment.getKey());
            if (enchantmentId == null) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("id", enchantmentId.toString());
            compoundTag.m_128405_("lvl", learnedEnchantment.getValue().intValue());
            listTag.add((Object)compoundTag);
        }
        if (!listTag.isEmpty()) {
            tag.m_128365_("learned_enchantments", (Tag)listTag);
        }
    }

    public boolean knowsEnchantment(Enchantment enchantment, int lvl) {
        return this.knownEnchantments.containsKey(enchantment) && this.knownEnchantments.get(enchantment) >= lvl;
    }

    public boolean teachEnchantment(Enchantment enchantment, int lvl) {
        int knownLvl = this.knownEnchantments.getOrDefault(enchantment, 0);
        if (EnchantingFeature.isConsumedOnEnchant(enchantment)) {
            this.knownEnchantments.put(enchantment, knownLvl + lvl);
            return true;
        }
        if (knownLvl >= lvl) {
            return false;
        }
        this.knownEnchantments.put(enchantment, lvl);
        this.m_6596_();
        return true;
    }

    public void forgetEnchantment(Enchantment enchantment) {
        this.forgetEnchantment(enchantment, enchantment.m_6586_());
    }

    public void forgetEnchantment(Enchantment enchantment, int lvl) {
        Integer currentLvl = this.knownEnchantments.get(enchantment);
        if (currentLvl == null) {
            return;
        }
        if (currentLvl - lvl <= 0) {
            this.knownEnchantments.remove(enchantment);
        } else {
            this.knownEnchantments.put(enchantment, currentLvl - lvl);
        }
        this.m_6596_();
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static void clientTick(Level pLevel, BlockPos pos, BlockState pState, ISEEnchantingTableBlockEntity blockEntity) {
        ISEEnchantingTableBlockEntity.bookAnimationTick(pLevel, pos, pState, blockEntity);
    }

    public static void bookAnimationTick(Level pLevel, BlockPos pPos, BlockState pState, ISEEnchantingTableBlockEntity pBlockEntity) {
        float f2;
        pBlockEntity.oOpen = pBlockEntity.open;
        pBlockEntity.oRot = pBlockEntity.rot;
        Player player = pLevel.m_45924_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, 3.0, false);
        if (player != null) {
            double d0 = player.m_20185_() - ((double)pPos.m_123341_() + 0.5);
            double d1 = player.m_20189_() - ((double)pPos.m_123343_() + 0.5);
            pBlockEntity.tRot = (float)Mth.m_14136_((double)d1, (double)d0);
            pBlockEntity.open += 0.1f;
            if (pBlockEntity.open < 0.5f || RANDOM.m_188503_(40) == 0) {
                float f1 = pBlockEntity.flipT;
                do {
                    pBlockEntity.flipT += (float)(RANDOM.m_188503_(4) - RANDOM.m_188503_(4));
                } while (f1 == pBlockEntity.flipT);
            }
        } else {
            pBlockEntity.tRot += 0.02f;
            pBlockEntity.open -= 0.1f;
        }
        while (pBlockEntity.rot >= (float)Math.PI) {
            pBlockEntity.rot -= (float)Math.PI * 2;
        }
        while (pBlockEntity.rot < (float)(-Math.PI)) {
            pBlockEntity.rot += (float)Math.PI * 2;
        }
        while (pBlockEntity.tRot >= (float)Math.PI) {
            pBlockEntity.tRot -= (float)Math.PI * 2;
        }
        while (pBlockEntity.tRot < (float)(-Math.PI)) {
            pBlockEntity.tRot += (float)Math.PI * 2;
        }
        for (f2 = pBlockEntity.tRot - pBlockEntity.rot; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        pBlockEntity.rot += f2 * 0.4f;
        pBlockEntity.open = Mth.m_14036_((float)pBlockEntity.open, (float)0.0f, (float)1.0f);
        ++pBlockEntity.time;
        pBlockEntity.oFlip = pBlockEntity.flip;
        float f = (pBlockEntity.flipT - pBlockEntity.flip) * 0.4f;
        float f3 = 0.2f;
        f = Mth.m_14036_((float)f, (float)(-f3), (float)f3);
        pBlockEntity.flipA += (f - pBlockEntity.flipA) * 0.9f;
        pBlockEntity.flip += pBlockEntity.flipA;
    }

    public int[] m_7071_(Direction pSide) {
        return new int[0];
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return false;
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return false;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.enchant");
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return new ISEEnchantingTableMenu(pContainerId, pInventory, (Container)this, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_));
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int pSlot) {
        return (ItemStack)this.items.get(pSlot);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return ContainerHelper.m_18969_(this.items, (int)pSlot, (int)pAmount);
    }

    public ItemStack m_8016_(int pSlot) {
        return ContainerHelper.m_18966_(this.items, (int)pSlot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SyncISEEnchantingTableStatus.sync(serverLevel, this.m_58899_(), this);
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player pPlayer) {
        return Container.m_272074_((BlockEntity)this, (Player)pPlayer);
    }

    public void m_6211_() {
        this.items.clear();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }
}

