/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.experience.enchanting;

import insane96mcp.iguanatweaksexpanded.module.experience.enchanting.EnchantingFeature;
import insane96mcp.iguanatweaksexpanded.utils.LogHelper;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.EnchantmentsFeature;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class ISEEnsorcellerBlockEntity
extends BlockEntity {
    public static final int ENOUGH_CHARGES = 5;
    private int charges;
    private int ensorcellingTicks;
    private ResourceLocation pendingEnchantId;
    private int pendingLevel;

    public ISEEnsorcellerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EnchantingFeature.ENSORCELLER_BLOCK_ENTITY.get(), pos, state);
    }

    public void addCharges(int added) {
        this.charges += added;
        this.m_6596_();
    }

    public boolean hasPendingEnchantment() {
        return this.pendingEnchantId != null && this.pendingLevel > 0;
    }

    public ItemStack createPendingBook(RandomSource random) {
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(this.pendingEnchantId);
        if (enchantment == null) {
            this.clearPending();
            LogHelper.warn("Invalid enchantment pending found. Discarding", new Object[0]);
            return ItemStack.f_41583_;
        }
        ItemStack out = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, this.pendingLevel));
        this.clearPending();
        this.m_6596_();
        return out;
    }

    private void clearPending() {
        this.pendingEnchantId = null;
        this.pendingLevel = 0;
    }

    private void tryRollEnchantment(Level level, BlockPos pos, BlockState state) {
        ArrayList<Enchantment> eligibleEnchantments = new ArrayList<Enchantment>();
        for (Enchantment ench : ForgeRegistries.ENCHANTMENTS.getValues()) {
            if (ench.m_6589_() || !ench.isAllowedOnBooks() || !ench.m_6592_() || EnchantmentsFeature.isEnchantmentDisabled((Enchantment)ench)) continue;
            eligibleEnchantments.add(ench);
        }
        if (eligibleEnchantments.isEmpty()) {
            return;
        }
        Enchantment enchantment = (Enchantment)eligibleEnchantments.get(level.f_46441_.m_188503_(eligibleEnchantments.size()));
        int cost = EnchantingFeature.getCost(enchantment, 1);
        if (this.charges >= cost) {
            this.charges -= cost;
            this.pendingEnchantId = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment);
            this.pendingLevel = 1;
            this.m_6596_();
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ISEEnsorcellerBlockEntity be) {
        if (level.f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!be.hasPendingEnchantment() && be.charges >= 5) {
            ++be.ensorcellingTicks;
            if (be.ensorcellingTicks >= EnchantingFeature.ensorceller$timeToGenerate) {
                be.ensorcellingTicks = 0;
                be.tryRollEnchantment(level, pos, state);
                serverLevel.m_5594_(null, pos, SoundEvents.f_11887_, SoundSource.BLOCKS, 2.0f, 0.5f);
            }
        } else {
            be.ensorcellingTicks = 0;
        }
        double x = (float)pos.m_123341_() + 0.5f;
        double y = (float)pos.m_123342_() + 0.5f;
        double z = (float)pos.m_123343_() + 0.5f;
        if (be.hasPendingEnchantment()) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123809_, x, y, z, 10, 1.0, 1.0, 1.0, 1.0);
        } else if (be.charges >= 5) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, x, y, z, be.charges / 2, 1.0, 1.0, 1.0, 0.1);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Charges", this.charges);
        tag.m_128405_("EnsorcellingTicks", this.ensorcellingTicks);
        if (this.hasPendingEnchantment()) {
            tag.m_128359_("PendingId", this.pendingEnchantId.toString());
            tag.m_128405_("PendingLvl", this.pendingLevel);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.charges = tag.m_128451_("Charges");
        this.ensorcellingTicks = tag.m_128451_("EnsorcellingTicks");
        if (tag.m_128441_("PendingId")) {
            this.pendingEnchantId = ResourceLocation.parse((String)tag.m_128461_("PendingId"));
            this.pendingLevel = tag.m_128451_("PendingLvl");
        } else {
            this.pendingEnchantId = null;
            this.pendingLevel = 0;
        }
    }
}

