/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.mining.multiblockfurnaces.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import insane96mcp.iguanatweaksexpanded.module.mining.multiblockfurnaces.crafting.AbstractMultiItemSmeltingRecipe;
import insane96mcp.iguanatweaksexpanded.setup.client.ISEBookCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractMultiItemSmeltingSerializer
implements RecipeSerializer<AbstractMultiItemSmeltingRecipe> {
    private final CookieBaker<AbstractMultiItemSmeltingRecipe> factory;

    public AbstractMultiItemSmeltingSerializer(CookieBaker<AbstractMultiItemSmeltingRecipe> pFactory) {
        this.factory = pFactory;
    }

    public AbstractMultiItemSmeltingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
        ItemStack result;
        String group = GsonHelper.m_13851_((JsonObject)pJson, (String)"group", (String)"");
        ISEBookCategory category = (ISEBookCategory)ISEBookCategory.CODEC.m_262792_(GsonHelper.m_13851_((JsonObject)pJson, (String)"category", null), (Enum)this.getDefaultBookCategory());
        NonNullList<Ingredient> ingredients = AbstractMultiItemSmeltingSerializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)pJson, (String)"ingredients"));
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (ingredients.size() > this.getIngredientSlotsCount()) {
            throw new JsonParseException("Too many ingredients for multi item smelting recipe. The maximum is %d".formatted(this.getIngredientSlotsCount()));
        }
        if (!pJson.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (pJson.get("result").isJsonObject()) {
            result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
        } else {
            String s1 = GsonHelper.m_13906_((JsonObject)pJson, (String)"result");
            ResourceLocation resourcelocation = new ResourceLocation(s1);
            result = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(resourcelocation));
        }
        float outputIncrease = GsonHelper.m_13820_((JsonObject)pJson, (String)"output_increase", (float)0.0f);
        float experience = GsonHelper.m_13820_((JsonObject)pJson, (String)"experience", (float)0.0f);
        int cookingTime = GsonHelper.m_13927_((JsonObject)pJson, (String)"cookingtime");
        AbstractMultiItemSmeltingRecipe.Recycle recycle = null;
        if (pJson.has("recycle")) {
            if (ingredients.size() > 1) {
                throw new JsonParseException("Too many ingredients for multi item smelting recipe. The maximum is 1 when recycling is present");
            }
            recycle = AbstractMultiItemSmeltingRecipe.Recycle.fromJson(pJson.getAsJsonObject("recycle"));
        }
        return this.factory.create(pRecipeId, group, category, ingredients, result, outputIncrease, experience, cookingTime, recycle);
    }

    protected abstract ISEBookCategory getDefaultBookCategory();

    private static NonNullList<Ingredient> itemsFromJson(JsonArray pIngredientArray) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < pIngredientArray.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)pIngredientArray.get(i));
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public AbstractMultiItemSmeltingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
        String group = pBuffer.m_130277_();
        ISEBookCategory category = (ISEBookCategory)pBuffer.m_130066_(ISEBookCategory.class);
        int ingredientsAmount = pBuffer.m_130242_();
        NonNullList ingredients = NonNullList.m_122780_((int)ingredientsAmount, (Object)Ingredient.f_43901_);
        ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
        ItemStack itemstack = pBuffer.m_130267_();
        float outputIncrease = pBuffer.readFloat();
        float experience = pBuffer.readFloat();
        int cookingTime = pBuffer.m_130242_();
        AbstractMultiItemSmeltingRecipe.Recycle recycle = AbstractMultiItemSmeltingRecipe.Recycle.fromNetwork(pBuffer);
        return this.factory.create(pRecipeId, group, category, (NonNullList<Ingredient>)ingredients, itemstack, outputIncrease, experience, cookingTime, recycle);
    }

    public void toNetwork(FriendlyByteBuf pBuffer, AbstractMultiItemSmeltingRecipe pRecipe) {
        pBuffer.m_130070_(pRecipe.m_6076_());
        pBuffer.m_130068_((Enum)pRecipe.category());
        pBuffer.m_130130_(pRecipe.m_7527_().size());
        for (Ingredient ingredient : pRecipe.m_7527_()) {
            ingredient.m_43923_(pBuffer);
        }
        pBuffer.m_130055_(pRecipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
        pBuffer.writeFloat(pRecipe.getOutputIncrease());
        pBuffer.writeFloat(pRecipe.getExperience());
        pBuffer.m_130130_(pRecipe.getCookingTime());
        if (pRecipe.getRecycle() != null) {
            pBuffer.writeBoolean(true);
            pRecipe.getRecycle().toNetwork(pBuffer);
        } else {
            pBuffer.writeBoolean(false);
        }
    }

    abstract int getIngredientSlotsCount();

    public static interface CookieBaker<T extends AbstractMultiItemSmeltingRecipe> {
        public T create(ResourceLocation var1, String var2, ISEBookCategory var3, NonNullList<Ingredient> var4, ItemStack var5, float var6, float var7, int var8, AbstractMultiItemSmeltingRecipe.Recycle var9);
    }
}

