/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import insane96mcp.iguanatweaksexpanded.module.mining.multiblockfurnaces.crafting.AbstractMultiItemSmeltingRecipe;
import insane96mcp.insanelib.InsaneLib;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public abstract class EmiMultiItemSmeltingRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final NonNullList<EmiIngredient> ingredients;
    final float experience;
    final float outputIncrease;
    private final EmiStack output;
    protected final int cookingTime;
    @Nullable
    final AbstractMultiItemSmeltingRecipe.Recycle recycle;

    public EmiMultiItemSmeltingRecipe(AbstractMultiItemSmeltingRecipe recipe) {
        this.id = recipe.m_6423_();
        this.ingredients = NonNullList.m_122780_((int)6, (Object)EmiIngredient.of((Ingredient)Ingredient.f_43901_));
        for (int i = 0; i < recipe.m_7527_().size(); ++i) {
            this.ingredients.set(i, (Object)EmiIngredient.of((Ingredient)((Ingredient)recipe.m_7527_().get(i))));
        }
        this.experience = recipe.getExperience();
        this.outputIncrease = recipe.getOutputIncrease();
        this.recycle = recipe.getRecycle();
        int amount = (int)(this.outputIncrease + 1.0f);
        if (this.recycle != null) {
            amount = this.recycle.amountAtFullDurability();
        }
        this.output = EmiStack.of((ItemStack)recipe.getResult(), (long)amount);
        this.cookingTime = recipe.getCookingTime();
    }

    public abstract EmiRecipeCategory getCategory();

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.ingredients;
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    public int getDisplayWidth() {
        return 153;
    }

    public int getDisplayHeight() {
        return 45;
    }

    public void addWidgets(WidgetHolder widgets) {
        float chance;
        widgets.addTexture(EmiTexture.EMPTY_FLAME, 3, 13);
        widgets.addAnimatedTexture(EmiTexture.FULL_FLAME, 3, 13, 4000, false, true, true);
        widgets.addFillingArrow(94, 16, this.cookingTime * 50).tooltip((mx, my) -> List.of(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237110_((String)"emi.cooking.time", (Object[])new Object[]{Float.valueOf((float)this.cookingTime / 20.0f)}).m_7532_())));
        widgets.addText((Component)Component.m_237110_((String)"emi.cooking.experience", (Object[])new Object[]{Float.valueOf(this.experience)}), 92, 5, -1, true);
        SlotWidget outputSlot = widgets.addSlot((EmiIngredient)this.output, 125, 12).large(true).recipeContext((EmiRecipe)this);
        if (this.recycle != null) {
            outputSlot.appendTooltip((Component)Component.m_237110_((String)"emi.tooltip.iguanatweaksexpanded.recycle", (Object[])new Object[]{(int)(this.recycle.ratio() * 100.0f)}).m_130940_(ChatFormatting.DARK_GREEN));
        }
        if (this.outputIncrease > 0.0f && (chance = this.outputIncrease - (float)((int)this.outputIncrease)) > 0.0f) {
            outputSlot.appendTooltip((Component)Component.m_237110_((String)"emi.tooltip.iguanatweaksexpanded.output_increase", (Object[])new Object[]{InsaneLib.ONE_DECIMAL_FORMATTER.format(chance * 100.0f)}).m_130940_(ChatFormatting.DARK_GREEN));
        }
    }
}

