/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.experience.enchantments.enchantment;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import insane96mcp.iguanatweaksexpanded.event.ISEEventFactory;
import insane96mcp.iguanatweaksexpanded.module.experience.enchantments.NewEnchantmentsFeature;
import insane96mcp.iguanatweaksexpanded.module.experience.enchantments.enchantment.Blasting;
import insane96mcp.iguanatweaksexpanded.module.experience.enchantments.enchantment.Expanded;
import insane96mcp.iguanatweaksreborn.module.items.unbreakableitems.UnbreakableItems;
import insane96mcp.insanelib.base.Feature;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.DiggingEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.event.level.BlockEvent;

public class Veining
extends Enchantment {
    public Veining() {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.DIGGER, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int m_6586_() {
        return 3;
    }

    public int m_6183_(int level) {
        return 22 * level;
    }

    public int m_6175_(int level) {
        return this.m_6183_(level) + 22;
    }

    public boolean m_5975_(Enchantment other) {
        return !(other instanceof DiggingEnchantment) && !(other instanceof Blasting) && !(other instanceof Expanded) && super.m_5975_(other);
    }

    public boolean m_6592_() {
        return Feature.isEnabled(NewEnchantmentsFeature.class);
    }

    public static void apply(LivingEntity entity, Level level, ItemStack heldStack, BlockPos pos, Direction face, BlockState state, Function<BlockPos, Boolean> function) {
        int enchLevel = heldStack.getEnchantmentLevel((Enchantment)NewEnchantmentsFeature.VEINING.get());
        if (enchLevel == 0) {
            return;
        }
        List<BlockPos> affectedBlocks = Veining.getAffectedBlocks(heldStack, enchLevel, level, entity, pos, face);
        for (BlockPos affectedBlock : affectedBlocks) {
            if (function.apply(affectedBlock).booleanValue()) break;
        }
    }

    public static void onBlockToolModification(BlockEvent.BlockToolModificationEvent event) {
        Player entity = event.getPlayer();
        Level level = entity.m_9236_();
        BlockState state = event.getState();
        BlockPos pos = event.getPos();
        Direction face = event.getContext().m_43719_();
        ItemStack heldStack = event.getContext().m_43722_();
        Veining.apply((LivingEntity)entity, level, heldStack, pos, face, state, blockPos -> {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    if (!player.m_150110_().f_35935_) {
                        heldStack.m_41720_().m_6225_(new UseOnContext((Level)serverLevel, null, event.getContext().m_43724_(), event.getContext().m_43722_(), new BlockHitResult(event.getContext().m_43720_(), event.getContext().m_43719_(), blockPos, event.getContext().m_43721_())));
                    }
                }
            }
            return UnbreakableItems.isBroken((ItemStack)heldStack) || heldStack.m_41619_();
        });
    }

    public static void onBlockBreak(LivingEntity entity, Level level, BlockPos pos, Direction face, BlockState state) {
        ItemStack heldStack = entity.m_21205_();
        if (!heldStack.m_41735_(state)) {
            return;
        }
        Veining.apply(entity, level, heldStack, pos, face, state, affectedBlock -> {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    if (!player.m_150110_().f_35935_) {
                        BlockState minedBlockState = level.m_8055_(affectedBlock);
                        BlockEntity blockEntity = state.m_155947_() ? level.m_7702_(affectedBlock) : null;
                        int exp = ISEEventFactory.onEnchantmentBlockBreak(player, level, affectedBlock, minedBlockState);
                        if (exp == -1) {
                            return false;
                        }
                        boolean blockRemoved = Veining.removeBlock((Level)serverLevel, affectedBlock, player);
                        if (blockRemoved) {
                            serverLevel.m_46953_(affectedBlock, false, (Entity)entity);
                            if (!player.m_7500_()) {
                                minedBlockState.m_60734_().m_6240_((Level)serverLevel, (Player)player, affectedBlock, minedBlockState, blockEntity, heldStack);
                                minedBlockState.m_60734_().m_49805_(serverLevel, affectedBlock, exp);
                            }
                            level.m_46796_(2001, affectedBlock, Block.m_49956_((BlockState)minedBlockState));
                            ISEEventFactory.onBlockDestroyPosts((LevelAccessor)serverLevel, affectedBlock, minedBlockState, (Player)player);
                        }
                        heldStack.m_41622_(1, entity, livingEntity -> livingEntity.m_21190_(InteractionHand.MAIN_HAND));
                    }
                }
            }
            return UnbreakableItems.isBroken((ItemStack)heldStack) || heldStack.m_41619_();
        });
    }

    private static boolean removeBlock(Level level, BlockPos pos, ServerPlayer player) {
        BlockState state = level.m_8055_(pos);
        boolean removed = state.onDestroyedByPlayer(level, pos, (Player)player, true, level.m_6425_(pos));
        if (removed) {
            state.m_60734_().m_6786_((LevelAccessor)level, pos, state);
        }
        return removed;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void applyOutlineAndDestroyAnimation(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            return;
        }
        MultiPlayerGameMode controller = Minecraft.m_91087_().f_91072_;
        if (controller == null) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (level == null || player == null || Minecraft.m_91087_().m_91288_() == null) {
            return;
        }
        int enchLevel = player.m_21205_().getEnchantmentLevel((Enchantment)NewEnchantmentsFeature.VEINING.get());
        if (enchLevel == 0) {
            return;
        }
        HitResult result = Minecraft.m_91087_().f_91077_;
        if (result == null || result.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult blockTrace = (BlockHitResult)result;
        BlockPos targetPos = blockTrace.m_82425_();
        BlockState targetState = level.m_8055_(targetPos);
        ItemStack heldStack = player.m_21205_();
        if (!heldStack.m_41735_(targetState)) {
            return;
        }
        List<BlockPos> minedBlocks = Veining.getAffectedBlocks(heldStack, enchLevel, (Level)level, (LivingEntity)player, targetPos, blockTrace.m_82434_());
        if (minedBlocks.isEmpty()) {
            return;
        }
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Veining.renderMineProgress(event.getPoseStack(), event.getLevelRenderer().f_109464_.m_110108_(), targetPos, (Level)level, camera.m_90583_().f_82479_, camera.m_90583_().f_82480_, camera.m_90583_().f_82481_, minedBlocks);
        Veining.renderBlockHighlight(event.getPoseStack(), (Level)level, camera.m_90592_(), camera.m_90583_().f_82479_, camera.m_90583_().f_82480_, camera.m_90583_().f_82481_, minedBlocks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderMineProgress(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, BlockPos targetPos, Level level, double xOffset, double yOffset, double zOffset, List<BlockPos> minedBlocks) {
        BlockDestructionProgress progress = null;
        for (Int2ObjectMap.Entry entry : Minecraft.m_91087_().f_91060_.f_109408_.int2ObjectEntrySet()) {
            if (!((BlockDestructionProgress)entry.getValue()).m_139985_().equals((Object)targetPos)) continue;
            progress = (BlockDestructionProgress)entry.getValue();
            break;
        }
        if (progress == null) {
            return;
        }
        poseStack.m_85836_();
        VertexConsumer vertexBuilder = bufferSource.m_6299_((RenderType)ModelBakery.f_119229_.get(progress.m_139988_()));
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        for (BlockPos minedPos : minedBlocks) {
            if (minedPos.equals((Object)targetPos)) continue;
            poseStack.m_85836_();
            poseStack.m_85837_((double)minedPos.m_123341_() - xOffset, (double)minedPos.m_123342_() - yOffset, (double)minedPos.m_123343_() - zOffset);
            PoseStack.Pose entry = poseStack.m_85850_();
            SheetedDecalTextureGenerator blockBuilder = new SheetedDecalTextureGenerator(vertexBuilder, entry.m_252922_(), entry.m_252943_(), 1.0f);
            dispatcher.renderBreakingTexture(level.m_8055_(minedPos), minedPos, (BlockAndTintGetter)level, poseStack, (VertexConsumer)blockBuilder, ModelData.EMPTY);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        bufferSource.m_109911_();
    }

    public static void renderBlockHighlight(PoseStack poseStack, Level level, Entity entity, double xOffset, double yOffset, double zOffset, List<BlockPos> minedBlocks) {
        VertexConsumer vertexConsumer = Minecraft.m_91087_().f_91060_.f_109464_.m_110104_().m_6299_(RenderType.m_110504_());
        for (BlockPos minedPos : minedBlocks) {
            poseStack.m_85836_();
            BlockState state = level.m_8055_(minedPos);
            LevelRenderer.m_109782_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (VoxelShape)state.m_60651_((BlockGetter)level, minedPos, CollisionContext.m_82750_((Entity)entity)), (double)((double)minedPos.m_123341_() - xOffset), (double)((double)minedPos.m_123342_() - yOffset), (double)((double)minedPos.m_123343_() - zOffset), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            poseStack.m_85849_();
        }
    }

    public static int getAmountMined(int lvl) {
        return lvl * 3 + (lvl - 1);
    }

    public static List<BlockPos> getAffectedBlocks(ItemStack heldStack, int lvl, Level level, LivingEntity entity, BlockPos targetPos, Direction face) {
        ArrayList<BlockPos> minedBlocks = new ArrayList<BlockPos>();
        int blocksMined = Veining.getAmountMined(lvl);
        ArrayList<Object> posToCheck = new ArrayList<Object>();
        posToCheck.add(targetPos);
        ArrayList<BlockPos> explored = new ArrayList<BlockPos>();
        int toMine = 0;
        while (!posToCheck.isEmpty() && toMine < blocksMined) {
            ArrayList<BlockPos> posToCheckTmp = new ArrayList<BlockPos>();
            for (BlockPos blockPos : posToCheck) {
                for (Direction direction : Direction.values()) {
                    BlockPos relativePos = blockPos.m_121945_(direction);
                    if (explored.contains(relativePos)) continue;
                    if (Veining.addIfCanBeMined(heldStack, minedBlocks, level, targetPos, relativePos)) {
                        posToCheckTmp.add(relativePos);
                        if (++toMine >= blocksMined) {
                            posToCheckTmp.clear();
                            break;
                        }
                    }
                    explored.add(relativePos);
                }
                if (toMine < blocksMined) continue;
                break;
            }
            posToCheck.clear();
            posToCheck.addAll(posToCheckTmp);
        }
        return minedBlocks;
    }

    private static boolean addIfCanBeMined(ItemStack stack, List<BlockPos> blockPos, Level level, BlockPos targetPos, BlockPos minedPos) {
        BlockState minedState;
        if (minedPos.equals((Object)targetPos)) {
            return false;
        }
        BlockState targetState = level.m_8055_(targetPos);
        if (targetState.m_60713_((minedState = level.m_8055_(minedPos)).m_60734_())) {
            blockPos.add(minedPos);
            return true;
        }
        return false;
    }
}

