/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.items.crate;

import insane96mcp.iguanatweaksexpanded.data.criterion.ISETriggers;
import insane96mcp.iguanatweaksexpanded.module.items.crate.CrateBlock;
import insane96mcp.iguanatweaksexpanded.module.items.crate.CrateBlockEntity;
import insane96mcp.iguanatweaksexpanded.module.items.crate.CrateItem;
import insane96mcp.iguanatweaksexpanded.setup.ISERegistries;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.MCUtils;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegistryObject;

@Label(name="Crate", description="A new block that can let you carry more stuff around.")
@LoadFeature(module="iguanatweaksexpanded:items")
public class PortableCrate
extends Feature {
    public static final UUID CRATE_WEIGHT_UUID = UUID.fromString("4ce89c45-a011-43fa-b9a8-7f2bd0ea2fc3");
    public static final RegistryObject<CrateBlock> BLOCK = ISERegistries.BLOCKS.register("crate", () -> new CrateBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_278183_().m_280658_(NoteBlockInstrument.BASS).m_60978_(2.5f)));
    public static final RegistryObject<CrateItem> ITEM = ISERegistries.ITEMS.register("crate", () -> new CrateItem((Block)BLOCK.get(), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<BlockEntityType<?>> BLOCK_ENTITY_TYPE = ISERegistries.BLOCK_ENTITY_TYPES.register("crate", () -> BlockEntityType.Builder.m_155273_(CrateBlockEntity::new, (Block[])new Block[]{(Block)BLOCK.get()}).m_58966_(null));
    @Config(min=0.0)
    @Label(name="Max crates without slowdown")
    public static Integer maxCratesWithoutSlowdown = 2;
    @Config(min=0.0, max=1.0)
    @Label(name="Base Slowness per crate over max", description="When you have > 'Max crates without slowdown' this is the base value for the slowdown. The slowdown is calculated as (crates above 'Max crates' ^ 2 * this)")
    public static Double slownessPerCrate = 0.05;

    public PortableCrate(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (slownessPerCrate == 0.0 || event.phase == TickEvent.Phase.START) {
            return;
        }
        int cratesInInventory = ContainerHelper.m_18956_((Container)event.player.m_150109_(), stack -> stack.m_150930_((Item)ITEM.get()), (int)0, (boolean)true);
        event.player.m_21051_(Attributes.f_22279_).m_22120_(CRATE_WEIGHT_UUID);
        if (cratesInInventory > maxCratesWithoutSlowdown) {
            Player player;
            double slowness = (double)(cratesInInventory - maxCratesWithoutSlowdown) * slownessPerCrate * (double)Math.max(1, cratesInInventory - maxCratesWithoutSlowdown);
            MCUtils.applyModifier((LivingEntity)event.player, (Attribute)Attributes.f_22279_, (UUID)CRATE_WEIGHT_UUID, (String)"Crate weight penalty", (double)(-slowness), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE, (boolean)false);
            if (event.player.f_19797_ % 20 == 4 && (player = event.player) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ISETriggers.OVERWEIGHT_CREATE_CARRY.trigger(serverPlayer);
            }
        }
    }
}

