/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksexpanded.module.mining.forging;

import com.google.common.collect.Lists;
import insane96mcp.iguanatweaksexpanded.module.mining.forging.ForgeMenu;
import insane96mcp.iguanatweaksexpanded.module.mining.forging.ForgeRecipe;
import insane96mcp.iguanatweaksexpanded.module.mining.forging.Forging;
import insane96mcp.insanelib.util.MathHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class ForgeBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    public static final int DATA_SMASHES_REQUIRED = 0;
    public static final int DATA_SMASHES = 1;
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    public int smashesRequired;
    public int smashes;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int dataId) {
            return switch (dataId) {
                case 0 -> ForgeBlockEntity.this.smashesRequired;
                case 1 -> ForgeBlockEntity.this.smashes;
                default -> 0;
            };
        }

        public void m_8050_(int dataId, int data) {
            switch (dataId) {
                case 0: {
                    ForgeBlockEntity.this.smashesRequired = data;
                    break;
                }
                case 1: {
                    ForgeBlockEntity.this.smashes = data;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeManager.CachedCheck<Container, ? extends ForgeRecipe> quickCheck;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public ForgeBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)Forging.FORGE_BLOCK_ENTITY_TYPE.get(), pPos, pBlockState);
        this.quickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)Forging.FORGE_RECIPE_TYPE.get()));
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)pTag, this.items);
        this.smashesRequired = pTag.m_128451_("SmashesRequired");
        this.smashes = pTag.m_128451_("Smashes");
        CompoundTag compoundtag = pTag.m_128469_("RecipesUsed");
        for (String s : compoundtag.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), compoundtag.m_128451_(s));
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("SmashesRequired", this.smashesRequired);
        pTag.m_128405_("Smashes", this.smashes);
        ContainerHelper.m_18973_((CompoundTag)pTag, this.items);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((p_187449_, p_187450_) -> compoundtag.m_128405_(p_187449_.toString(), p_187450_.intValue()));
        pTag.m_128365_("RecipesUsed", (Tag)compoundtag);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static boolean onUse(Level pLevel, BlockPos pPos, BlockState pState, ForgeBlockEntity pBlockEntity, int smashes) {
        ItemStack resultStack = (ItemStack)pBlockEntity.items.get(2);
        if (!resultStack.m_41619_()) {
            return false;
        }
        ItemStack ingredientStack = (ItemStack)pBlockEntity.items.get(0);
        if (ingredientStack.m_41793_()) {
            pBlockEntity.smashes = 0;
            return false;
        }
        ItemStack gearStack = (ItemStack)pBlockEntity.items.get(1);
        if (ingredientStack.m_41619_() || gearStack.m_41619_()) {
            pBlockEntity.smashes = 0;
            return false;
        }
        Recipe recipe = pBlockEntity.quickCheck.m_213657_((Container)pBlockEntity, pLevel).orElse(null);
        int maxStackSize = pBlockEntity.m_6893_();
        if (pBlockEntity.canForge(pLevel.m_9598_(), recipe, pBlockEntity.items, maxStackSize)) {
            pBlockEntity.smashes += smashes;
            if (pBlockEntity.smashes >= pBlockEntity.smashesRequired) {
                pBlockEntity.smashes = 0;
                pBlockEntity.smashesRequired = ForgeBlockEntity.getSmashesRequired(pLevel, pBlockEntity);
                if (pBlockEntity.forge(pLevel.m_9598_(), recipe, pBlockEntity.items, maxStackSize)) {
                    pBlockEntity.m_6029_(recipe);
                }
                pLevel.m_5594_(null, pPos, SoundEvents.f_11671_, SoundSource.BLOCKS, 0.5f, 0.8f);
            } else {
                pLevel.m_5594_(null, pPos, SoundEvents.f_11669_, SoundSource.BLOCKS, 0.5f, 1.7f);
            }
            pLevel.m_7260_(pPos, pState, pState, 3);
            return true;
        }
        pBlockEntity.smashes = 0;
        return false;
    }

    private boolean canForge(RegistryAccess registryAccess, @javax.annotation.Nullable Recipe<?> recipe, NonNullList<ItemStack> slotsStacks, int stackSize) {
        boolean hasGear;
        if (recipe == null) {
            return false;
        }
        boolean hasIngredient = !((ItemStack)slotsStacks.get(0)).m_41619_();
        boolean bl = hasGear = !((ItemStack)slotsStacks.get(1)).m_41619_();
        if (!hasIngredient || !hasGear) {
            return false;
        }
        ItemStack resultStack = recipe.m_5874_((Container)this, registryAccess);
        if (resultStack.m_41619_()) {
            return false;
        }
        ItemStack resultSlotStack = (ItemStack)slotsStacks.get(2);
        if (resultSlotStack.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_150942_((ItemStack)resultSlotStack, (ItemStack)resultStack)) {
            return false;
        }
        if (resultSlotStack.m_41613_() >= resultStack.m_41741_()) {
            return false;
        }
        return resultSlotStack.m_41613_() + resultStack.m_41613_() < stackSize;
    }

    private boolean forge(RegistryAccess registryAccess, @javax.annotation.Nullable Recipe<?> recipe, NonNullList<ItemStack> slotStacks, int stackSize) {
        ItemStack resultSlotStack;
        if (!this.canForge(registryAccess, recipe, slotStacks, stackSize)) {
            return false;
        }
        ItemStack resultStack = recipe.m_5874_((Container)this, registryAccess);
        ItemStack gearSlotStack = (ItemStack)slotStacks.get(1);
        if (gearSlotStack.m_41782_()) {
            resultStack.m_41751_(gearSlotStack.m_41783_());
        }
        if (resultStack.m_41720_().m_41465_()) {
            resultStack.m_41721_(0);
        }
        if ((resultSlotStack = (ItemStack)slotStacks.get(2)).m_41619_()) {
            slotStacks.set(2, (Object)resultStack.m_41777_());
        } else if (resultSlotStack.m_150930_(resultStack.m_41720_())) {
            resultSlotStack.m_41769_(resultStack.m_41613_());
        }
        ((ItemStack)slotStacks.get(0)).m_41774_(((ForgeRecipe)recipe).getIngredientAmount());
        gearSlotStack.m_41774_(1);
        return true;
    }

    private static int getSmashesRequired(Level pLevel, ForgeBlockEntity pBlockEntity) {
        return pBlockEntity.quickCheck.m_213657_((Container)pBlockEntity, pLevel).map(ForgeRecipe::getSmashesRequired).orElse(10);
    }

    public int[] m_7071_(Direction pSide) {
        if (pSide == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        if (pSide != Direction.UP) {
            return SLOTS_FOR_SIDES;
        }
        return SLOTS_FOR_UP;
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return this.m_7013_(pIndex, pItemStack);
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return true;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"iguanatweaksexpanded.container.forge");
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return new ForgeMenu(pContainerId, pInventory, (Container)this, this.dataAccess);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int pSlot) {
        return (ItemStack)this.items.get(pSlot);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        ItemStack ret = ContainerHelper.m_18969_(this.items, (int)pSlot, (int)pAmount);
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
        return ret;
    }

    public ItemStack m_8016_(int pSlot) {
        return ContainerHelper.m_18966_(this.items, (int)pSlot);
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        ItemStack itemstack = (ItemStack)this.items.get(pSlot);
        boolean flag = !pStack.m_41619_() && ItemStack.m_150942_((ItemStack)pStack, (ItemStack)itemstack);
        this.items.set(pSlot, (Object)pStack);
        if (pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
        if (pSlot < 2 && !flag) {
            this.smashesRequired = ForgeBlockEntity.getSmashesRequired(this.f_58857_, this);
            this.smashes = 0;
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean m_6542_(Player pPlayer) {
        return Container.m_272074_((BlockEntity)this, (Player)pPlayer);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_6029_(@Nullable Recipe<?> pRecipe) {
        if (pRecipe != null) {
            ResourceLocation resourcelocation = pRecipe.m_6423_();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel pLevel, Vec3 pPopVec) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            pLevel.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(p_155023_ -> {
                list.add(p_155023_);
                this.createExperience(pLevel, pPopVec, entry.getIntValue(), ((ForgeRecipe)p_155023_).getExperience());
            });
        }
        return list;
    }

    private void createExperience(ServerLevel pLevel, Vec3 pPopVec, int recipeAmount, float experience) {
        int xp = MathHelper.getAmountWithDecimalChance((RandomSource)pLevel.m_213780_(), (float)((float)recipeAmount * experience));
        ExperienceOrb.m_147082_((ServerLevel)pLevel, (Vec3)pPopVec, (int)xp);
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer pPlayer) {
        List<Recipe<?>> list = this.getRecipesToAwardAndPopExperience((ServerLevel)pPlayer.m_9236_(), pPlayer.m_20182_());
        pPlayer.m_7281_(list);
        this.recipesUsed.clear();
    }

    public void m_5809_(StackedContents pHelper) {
        for (ItemStack itemstack : this.items) {
            pHelper.m_36491_(itemstack);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }
}

